
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGSignificantDifferenceSymbol.SigDiffProperties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;




/**
 * 
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SGSignificantDifferenceElement extends SGFigureElement
	implements SGISignificantDifferenceElement, SGIStringConstants, CaretListener, ActionListener
{

	/**
	 * 
	 */
	private SGIAxisElement mAxisElement = null;
	
	
	/**
	 * 
	 */
	private JTextField mEditField = null;


	/**
	 * 
	 */
	private int mFocusedX = 0;


	/**
	 * 
	 */
	private int mFocusedY = 0;



	
	
	/**
	 * A symbol which the user is editing the text.
	 */
	private SigDiffSymbol mEditingSymbol = null;
	


	/**
	 * 
	 */
	private SGSignificantDifferenceSymbolDialog mDialog = null;



	/**
	 * 
	 *
	 */
	public SGSignificantDifferenceElement()
	{
		super();
		this.initEditField();
	}



	/**
	 * 
	 */
	private boolean createSignificanceDialog()
	{

		final SGSignificantDifferenceSymbolDialog dg
			= new SGSignificantDifferenceSymbolDialog(
				mDialogOwner, true );

		this.mDialog = dg;

		return true;
	}



	/**
	 * Y[
	 */
	public boolean zoom( final float ratio )
	{
		// hide the text field
		if( this.terminateEditField() == false )
		{
			return false;
		}

		super.zoom(ratio);

		this.onZoomed(ratio);

		return true;

	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogOwner( final Frame frame )
	{
		super.setDialogOwner(frame);
		this.createSignificanceDialog();
		return true;
	}





	/**
	 * 
	 */
	private final ArrayList mSignificantDifferentSymbolsList = new ArrayList();

	

	/**
	 * 
	 */
	public boolean addSignificantDifferenceSymbol(
			final SGAxis xAxis, final SGAxis yAxis, final int x, final int y )
	{
		SigDiffSymbol sd = new SigDiffSymbol();
		sd.zoom(this.mMagnification);

		// set axes
		sd.mXAxis = xAxis;
		sd.mYAxis = yAxis;
		
		// set the location
		sd.setLocation( x, y );

		// create drawing elements
		sd.createDrawingElement();

		// set axis values
		sd.setAxisValuesWithShape();
		
		//
		this.mSignificantDifferentSymbolsList.add(sd);

		//
		this.setChanged(true);

		// initialize history
		sd.initPropertiesHistory();

		this.notifyToRoot();
		

		return true;
	}


	
	
	/**
	 * 
	 */
	public boolean addSignificantDifferenceSymbol( final int x, final int y )
	{
		if( this.getGraphRect().contains( x, y ) == false )
		{
			return false;
		}

		SGAxis xAxis = this.mAxisElement.getAxis( SGDefaultValues.SIGDIFF_HORIZONTAL_AXIS );
		SGAxis yAxis = this.mAxisElement.getAxis( SGDefaultValues.SIGDIFF_PERPENDICULAR_AXIS );

		return this.addSignificantDifferenceSymbol( xAxis, yAxis, x, y );
	}



	/**
	 * Move the focused objects to front or back.
	 * @param toFront - flag whether to front or back
	 * @return true:succeeded, false:failed
	 */
	public boolean moveFocusedObjects( boolean toFront )
	{
		ArrayList list = this.getFocusedObjectsList();

		if( toFront )
		{
			for( int ii=0; ii<list.size(); ii++ )
			{
				SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
				this.moveSigDiffSymbolToFront(el);
			}
		}
		else
		{
			for( int ii=0; ii<list.size(); ii++ )
			{
				SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
				this.moveSigDiffSymbolToBack(el);
			}
		}

		return true;
	}


	/**
	 * 
	 */
	private boolean moveSigDiffSymbolToFront( final SigDiffSymbol el )
	{
		return this.moveObjectToFront( el, this.mSignificantDifferentSymbolsList );
	}


	/**
	 * 
	 */
	private boolean moveSigDiffSymbolToBack( final SigDiffSymbol el )
	{
		return this.moveObjectToBack( el, this.mSignificantDifferentSymbolsList );
	}


	/**
	 * 
	 * @param el
	 * @return
	 */
	private boolean hideSigDiffSymbol( final SigDiffSymbol el )
	{
		this.hideObject(el);
		this.clearFocusedObjects();
		return true;
	}


	/**
	 * 
	 */
	private boolean onZoomed( final float ratio )
	{

		// siginificant symbol
		for( int ii=0; ii<this.mSignificantDifferentSymbolsList.size(); ii++ )
		{
			final SigDiffSymbol sd = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(ii);
			sd.zoom(ratio);
		}

		return true;
	}

	
	/**
	 * 
	 * @param element
	 */
	public void setAxisElement( final SGIAxisElement element )
	{
		this.mAxisElement = element;
	}

	
	/**
	 * B
	 */
	public boolean synchronize( final SGIFigureElement element )
	{

		boolean flag = true;
		if( element instanceof SGIGraphElement )
		{
			
		}
		else if( element instanceof SGIStringElement )
		{
			
		}
		else if( element instanceof SGILegendElement )
		{
			
		}
		else if( element instanceof SGIAxisElement )
		{
			flag = this.synchronizeToAxisElement( (SGIAxisElement)element );
		}
		else if( element instanceof SGIAxisBreakElement )
		{
			
		}
		else if( element instanceof SGISignificantDifferenceElement )
		{
			
		}
		else if( element instanceof SGITimingLineElement )
		{
			
		}

		else
		{
			flag = element.synchronizeArgument( this );
		}


		return flag;
	}


	
	private boolean synchronizeToAxisElement( SGIAxisElement element )
	{
		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			el.setShapeWithAxesValues();
		}
		return true;
	}



	/**
	 * Synchronize the element given by the argument.
	 * @param element An object to be synchronized.
	 */
	public boolean synchronizeArgument( final SGIFigureElement element )
	{
	    // this shouldn't happen
	    throw new Error();
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SGProperties p = new SigDiffElementProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 */
	public String getTagName()
	{
		return TAG_NAME_SIGNIFICANT_DIFFERENCE;
	}


	
	/**
	 * 
	 */
	public boolean writeProperty(Element el)
	{
		return true;
	}

	

	/**
	 * 
	 */
	public boolean readProperty( final Element element )
	{
		NodeList nList = element.getElementsByTagName( SigDiffSymbol.TAG_NAME_SIGDIFF_SYMBOL );
		for( int ii=0; ii<nList.getLength(); ii++ )
		{
			Node node = nList.item(ii);
			if( node instanceof Element )
			{
				Element el = (Element)node;
				SigDiffSymbol sd = new SigDiffSymbol();
				if( sd.readProperty(el) == false )
				{
					return false;
				}
				sd.initPropertiesHistory();
				this.mSignificantDifferentSymbolsList.add( sd );
			}
		}
		
		return true;
	}


	/**
	 * 
	 */
	public void actionPerformed(ActionEvent e)
	{
		final Object source = e.getSource();
		final String command = e.getActionCommand();

		if( source.equals( this.mEditField ) )
		{
			this.terminateEditField();
		}

	}



	/**
	 * 
	 */
	public boolean setGraphRect(
		final float x, final float y, final float width, final float height )
	{
		if( super.setGraphRect(x,y,width,height) == false )
		{
			return false;
		}

		if( this.terminateEditField() == false )
		{
			return false;
		}

		for( int ii=0; ii<this.mSignificantDifferentSymbolsList.size(); ii++ )
		{
			final SigDiffSymbol el
				= (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(ii);
			el.setShapeWithAxesValues();			
		}

		return true;
	}



	/**
	 * 
	 */
	public boolean getMarginAroundGraphRect(
		SGTuple2f topAndBottom, SGTuple2f leftAndRight )
	{

		if( super.getMarginAroundGraphRect( topAndBottom, leftAndRight ) == false )
		{
			return false;
		}

		ArrayList sList = this.getVisibleSigDiffSymbolList();
		ArrayList rectList = new ArrayList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SigDiffSymbol el = (SigDiffSymbol)sList.get(ii);
			Rectangle2D rect = el.getElementBounds();
			rectList.add( rect );
		}
		if( rectList.size()==0 )
		{
			return true;
		}


		// ꂽ`
		Rectangle2D uniRect = SGUtility.createUnion(rectList);


		// `畝߂
		final float top = this.mGraphRectY - (float)uniRect.getY();
		final float bottom = -( this.mGraphRectY + this.mGraphRectHeight )
			 + (float)( uniRect.getY() + uniRect.getHeight() );
		final float left = this.mGraphRectX - (float)uniRect.getX();
		final float right = -( this.mGraphRectX + this.mGraphRectWidth )
			 + (float)( uniRect.getX() + uniRect.getWidth() );


		// ɐݒ
		topAndBottom.x += top;
		topAndBottom.y += bottom;
		leftAndRight.x += left;
		leftAndRight.y += right;

		return true;
	}



	/**
	 * 
	 */
	public void paintComponent( final Graphics g )
	{
		super.paintComponent(g);
		final Graphics2D g2d = (Graphics2D)g.create();


		// draw significant difference symbols
		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			el.drawSymbol(g2d);
		}

		// draw symbols around all objects
		if( this.mSymbolsVisibleFlagAroundAllObjects )
		{
			for( int ii=0; ii<list.size(); ii++ )
			{
				SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
				ArrayList pList = el.getAnchorPointList();
				SGUtilityForFigureElement.drawAnchorAsChildObject( pList, g2d );
			}
		}

		// draw symbols around focused objects
		if( this.mSymbolsVisibleFlagAroundFocusedObjects )
		{
			ArrayList fList = this.getFocusedObjectsList();
			for( int ii=0; ii<fList.size(); ii++ )
			{
				SigDiffSymbol el = (SigDiffSymbol)fList.get(ii);
				ArrayList pList = el.getAnchorPointList();
				SGUtilityForFigureElement.drawAnchorAsFocusedObject( pList, g2d );
			}
		}

	}

	

	/**
	 * 
	 */
	private ArrayList getVisibleSigDiffSymbolList()
	{
		ArrayList list = new ArrayList();

		for( int ii=0; ii<this.mSignificantDifferentSymbolsList.size(); ii++ )
		{
			SigDiffSymbol el
				= (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(ii);
			if( el.isVisible() )
			{
				list.add(el);
			}
		}

		return list;
	}



	/**
	 * 
	 */
	public boolean getFocusedObjectsList( ArrayList list )
	{
		ArrayList elList = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<elList.size(); ii++ )
		{
			SGISelectable s = (SGISelectable)elList.get(ii);
			if( s.isSelected() )
			{
				list.add(s);
			}
		}
		return true;
	}


	/**
	 * 
	 *
	 */
	public boolean hideSelectedObject( SGISelectable s )
	{
		SigDiffSymbol el = (SigDiffSymbol)s;
		el.setVisible(false);
		return true;
	}


	/**
	 * 
	 */
	public void caretUpdate( final CaretEvent e )
	{
		final String str = this.mEditField.getText();

		if( this.mEditingSymbol!=null )
		{
			final Font font = new Font(
				this.mEditingSymbol.getFontName(),
				this.mEditingSymbol.getFontStyle(),
				(int)(this.mEditingSymbol.getFontSize()*this.getMagnification()) );
			final Rectangle2D stringRect = font.getStringBounds(
				str, new FontRenderContext( null, false, false ) );
			
			final double width = stringRect.getWidth();
			if( width > this.mEditField.getWidth() )
			{
				this.mEditField.setSize(
					(int)( stringRect.getWidth() + this.getMagnification()*this.mEditingSymbol.getFontSize() ),
					this.mEditField.getHeight()
				);
			}
		}
	}



	/**
	 * 
	 * @param e
	 */
	public boolean onDrawingElement( final int x, final int y )
	{

		// significant difference symbols
		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol sd = (SigDiffSymbol)list.get(ii);
			if( sd.contains(x,y) )
			{
				if( sd.isSelected() )
				{
					sd.mMouseLocation = sd.getMouseLocation(x,y);
					setMouseCursor( sd.getCursor( sd.mMouseLocation ) );
					return true;
				}
				else
				{
					setMouseCursor( Cursor.HAND_CURSOR );
					return true;
				}
			}
		}

		// Oẗ̗OłΏI
		if( !this.isInsideGraphArea(x,y) )
		{
			return false;
		}

		return false;
	}




	/**
	 * 
	 */
	public boolean onMouseClicked( final MouseEvent e )
	{
		if( super.onMouseClicked(e) == false )
		{
			return false;
		}

		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			if( this.clickDrawingElements(el,e) )
			{
				return true;
			}
		}

		return false;
	}

	
	/**
	 * 
	 */
	private boolean clickDrawingElements(
		final SigDiffSymbol el, final MouseEvent e )
	{
		final int x = e.getX();
		final int y = e.getY();
		final int cnt = e.getClickCount();

		// clicked on the line elements
		if( el.contains(x,y) )
		{
			// clicked on the string element
			if( el.getStringElement().contains(x,y) )
			{
				if( SwingUtilities.isLeftMouseButton(e) & cnt==1 )
				{
					if( el.isSelected() )
					{
						this.mEditingSymbol = el;
						this.showEditField( el );
					}
					else
					{
						this.updateFocusedObjectsList( el, e );
					}
				}
				else if( SwingUtilities.isRightMouseButton(e) & cnt==1 )
				{
					el.getPopupMenu().show( this, x, y );
				}
			}
			else
			// otherwise
			{
				this.updateFocusedObjectsList( el, e );
				if( SwingUtilities.isLeftMouseButton(e) & cnt==1 )
				{
					
				}
				else if( SwingUtilities.isLeftMouseButton(e) & cnt==2 )
				{
					JDialog dialog = el.getDialog();
					dialog.setVisible(true);
				}
				else if( SwingUtilities.isRightMouseButton(e) & cnt==1 )
				{
					el.getPopupMenu().show( this, x, y );
				}
			}

			return true;
		}

		return false;
	}

	
	
	/**
	 * 
	 */
	public void translateSelectedObjects( final int dx, final int dy )
	{
		if( this.terminateEditField() == false )
		{
			return;
		}

		super.translateSelectedObjects(dx,dy);
	}



	/**
	 * 
	 * @param e
	 */
	public boolean onMousePressed( final MouseEvent e )
	{

		if( super.onMousePressed(e) == false )
		{
			return false;
		}

		
		if( this.terminateEditField() == false )
		{
			return false;
		}

		final int x = e.getX();
		final int y = e.getY();

		// significant difference symbols
		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			if( el.pressDrawingElements(e) )
			{
				this.mPressedPoint = e.getPoint();
				this.mPressedSymbol = el;
				return true;
			}
		}

		return false;
	}	

	
	private SigDiffSymbol mPressedSymbol = null;
	private Point mPressedPoint = null;
	
	
	/**
	 * 
	 * @param e
	 */
	public boolean onMouseDragged( final MouseEvent e )
	{
		if( super.onMouseDragged(e) == false )
		{
			return false;
		}

		
		final int dx = e.getX() - this.mPressedPoint.x;
		final int dy = e.getY() - this.mPressedPoint.y;

		
		ArrayList list = this.getFocusedObjectsList();
		if( list.size()==1 )
		{
			SigDiffSymbol sd = (SigDiffSymbol)list.get(0);
			if( sd.drag(e) == false )
			{
				return false;
			}

			sd.createDrawingElement();

			if( sd.setAxisValuesWithShape() == false )
			{
				return false;
			}
			if( sd.setShapeWithAxesValues() == false )
			{
				return false;
			}

			this.mPressedPoint = e.getPoint();

			return true;
			
		}
		else
		{

			for( int ii=0; ii<list.size(); ii++ )
			{
				SigDiffSymbol sd = (SigDiffSymbol)list.get(ii);
				
				sd.translate(dx,dy);

				sd.createDrawingElement();

				if( sd.setAxisValuesWithShape() == false )
				{
					return false;
				}
				if( sd.setShapeWithAxesValues() == false )
				{
					return false;
				}
			}

			this.mPressedPoint = e.getPoint();

			return true;
		}
		
	}


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseReleased( final MouseEvent e )
	{

		if( super.onMouseReleased(e) == false )
		{
			return false;
		}

/*
		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol sd = (SigDiffSymbol)list.get(ii);

			//
			SGProperties temp = sd.mTemporaryProperties;
			SGProperties p = sd.getProperties();
			if( p.equals(temp)==false )
			{
				sd.setChanged(true);
			}
			
			this.notifyToRoot();
		}
*/

		return true;
	}

	
	/**
	 * 
	 * @return
	 */
	public boolean setTemporaryPropertiesOfFocusedObjects()
	{
		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			el.mTemporaryProperties = el.getProperties();
		}
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setChangedFocusedObjects()
	{
		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol el = (SigDiffSymbol)list.get(ii);
			SGProperties temp = el.mTemporaryProperties;
			SGProperties p = el.getProperties();
			if( p.equals(temp)==false )
			{
				el.setChanged(true);
			}
		}
		return true;
	}

	
	/**
	 * 
	 * @return
	 */
	public boolean clearFocusedObjects()
	{
		if( super.clearFocusedObjects() == false )
		{
			return false;
		}
		
		if( this.terminateEditField() == false )
		{
			return false;
		}

		return true;
	}


	/**
	 * 
	 */
	public String toString()
	{
		return "SGSignificantDifferenceElement";
	}



	/**
	 * 
	 */
	private boolean initEditField()
	{
		this.mEditField = new JTextField(10);
		this.setLayout(null);
		this.add(this.mEditField);
		this.mEditField.setVisible(false);
		this.mEditField.addActionListener(this);
		this.mEditField.addCaretListener(this);

		return true;
	}



	/**
	 * 
	 */
	private boolean showEditField( final SigDiffSymbol el )
	{
		SGDrawingElementString2DExtended sElement
			= (SGDrawingElementString2DExtended)el.getStringElement();

		final Rectangle2D sRect = sElement.getElementBounds();
		final float fontSize = el.getMagnification()*el.getFontSize();

		JTextField tf = this.mEditField;
		final int w = (int)( sRect.getWidth() + fontSize );
		final int h = (int)( sRect.getHeight() + 0*fontSize );

		Insets insets = tf.getInsets();
		final int x = (int)( sRect.getX() - insets.left );
		final int y = (int)( sRect.getY() );

		Font font = new Font( el.getFontName(), el.getFontStyle(), (int)fontSize );
		tf.setLocation( x, y );
		tf.setSize( w, h );
		tf.setFont( font );
		tf.setForeground( el.getColor() );
		tf.setText( el.getStringElement().getString() );

		// show the text field
		tf.setVisible(true);
		tf.requestFocus();
		tf.setCaretPosition(0);

		return true;

	}


	/**
	 * 
	 */
	private boolean terminateEditField()
	{
		if( this.mEditField.isVisible() )
		{
			return this.commitEdit();
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	private boolean hideEditField()
	{
		this.mEditField.setText("");
		this.mEditField.setVisible(false);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	private boolean commitEdit()
	{
		if( this.mEditingSymbol==null )
		{
			return false;
		}

		String before = this.mEditingSymbol.mStringElement.getString();
		String after = this.mEditField.getText();
		if( SGUtilityText.isValidString(after) )
		{
			this.mEditingSymbol.setText( after );
			
			if( before.equals(after) == false )
			{
				this.mEditingSymbol.setChanged(true);
				this.notifyToRoot();
			}

			this.mEditingSymbol.createDrawingElement();
		}

		this.mEditingSymbol = null;
		this.hideEditField();
		this.repaint();
		
		return true;
	}



	/**
	 * 
	 */
	private boolean setVisibleSigDiffSymbols( final ArrayList listVisible )
	{
		return this.setVisibleDrawingElement( this.mSignificantDifferentSymbolsList, listVisible );
	}


	
	/**
	 * 
	 */
	public boolean getProperties( final SGProperties p )
	{

		if( ( p instanceof SigDiffElementProperties ) == false )
		{
			return false;
		}

		SigDiffElementProperties gp = (SigDiffElementProperties)p;
		gp.visibleSigDiffSymbolList = this.getVisibleSigDiffSymbolList();

		return true;

	}


	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{
		if( ( p instanceof SigDiffElementProperties ) == false )
		{
			return false;
		}

		SigDiffElementProperties gp = (SigDiffElementProperties)p;

		boolean flag = this.setVisibleSigDiffSymbols( gp.visibleSigDiffSymbolList );
		if( !flag )
		{
			return false;
		}


		return true;

	}



	/**
	 * 
	 */
	public Element createElement( final Document document )
	{
		Element el = this.createThisElement( document );
		if( el==null )
		{
			return null;
		}

		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SigDiffSymbol sd = (SigDiffSymbol)list.get(ii);
			Element elSigDiff = sd.createElement( document );
			if( elSigDiff==null )
			{
				return null;
			}
			el.appendChild( elSigDiff );
		}
		return el;
	}



	/**
	 * 
	 * @return
	 */
	public boolean addPropertiesHistory( SGProperties p )
	{

		if( ( p instanceof SigDiffElementProperties ) == false )
		{
			return false;
		}

		boolean flag = super.addPropertiesHistory(p);		

		return flag;
	}



	/**
	 * 
	 */
	public boolean undo()
	{
		boolean flag = super.undo();
		if( !flag )
		{
			return false;
		}
		this.notifyChange();
		this.clearFocusedObjects();

		return true;
	}


	/**
	 * 
	 */
	public boolean redo()
	{
		boolean flag = super.redo();
		if( !flag )
		{
			return false;
		}
		this.notifyChange();
		this.clearFocusedObjects();

		return true;
	}



	/**
	 * 
	 */
	public boolean updateHistory()
	{
		return this.updateHistory_( this.getVisibleSigDiffSymbolList() );
	}



	/**
	 * 
	 */
	public boolean isChanged()
	{
		if( super.isChanged() )
		{
			return true;
		}
		ArrayList list = this.getVisibleSigDiffSymbolList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGIUndoable el = (SGIUndoable)list.get(ii);
			if( el.isChanged() )
			{
				return true;
			}
		}
		return false;
	}




	/**
	 * Create copies of the focused objects.
	 * @return
	 */
	public boolean duplicateFocusedObjects()
	{
		final int ox = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_X );
		final int oy = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_Y );

		ArrayList cList = this.duplicateObjects();
		for( int ii=0; ii<cList.size(); ii++ )
		{
			// duplicate
			SigDiffSymbol el = (SigDiffSymbol)cList.get(ii);
			el.setShapeWithAxesValues();
			
			// translate the duplicate
			el.translate( ox, oy );

			// set selected
			el.setSelected(true);
			
			// add to the list
			this.mSignificantDifferentSymbolsList.add(el);

			el.initPropertiesHistory();
		}

		if( cList.size()!=0 )
		{
			this.setChanged(true);
		}
		
		return true;
	}



	/**
	 * Paste the objects.
	 * @param list of the objects to be pasted
	 * @return true:succeeded, false:failed
	 */
	public boolean paste( ArrayList list )
	{
		final int ox = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_X );
		final int oy = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_Y );

		int cnt = 0;
		for( int ii=0; ii<list.size(); ii++ )
		{
			Object obj = list.get(ii);
			if( obj instanceof SigDiffSymbol )
			{
				SigDiffSymbol sd = (SigDiffSymbol)obj;
				SGProperties p = sd.getProperties();
				
				SigDiffSymbol el = new SigDiffSymbol();
				el.setProperties(p);

				el.mXAxis = this.mAxisElement.getAxisInCube( sd.mTempXAxis );
				el.mYAxis = this.mAxisElement.getAxisInCube( sd.mTempYAxis );

				// set the shape
				el.setShapeWithAxesValues();

				// add to the list
				this.mSignificantDifferentSymbolsList.add(el);

				// initialize history
				el.initPropertiesHistory();

				cnt++;
			}
		}
		
		if( cnt!=0 )
		{
			this.setChanged(true);
		}

		this.repaint();

		return true;
	}



	/**
	 * 
	 */
	public static class SigDiffElementProperties extends SGProperties
	{
		ArrayList visibleSigDiffSymbolList = new ArrayList();


		/**
		 * 
		 *
		 */
		public SigDiffElementProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffElementProperties ) == false )
			{
				return false;
			}

			SigDiffElementProperties p = (SigDiffElementProperties)obj;

			if( p.visibleSigDiffSymbolList.equals(this.visibleSigDiffSymbolList) == false )
			{
				return false;
			}

			return true;
		}


		/**
		 * 
		 */
		public String toString()
		{
			String str = new String("[");
			str += this.visibleSigDiffSymbolList.toString();
			str += new String("]");

			return str;
		}
		
	}



	/**
	 * 
	 */
	class SigDiffSymbol extends SGSignificantDifferenceSymbol2D
		implements ActionListener, WindowListener,
			SGIUndoable, SGISelectable, SGIMovable, SGICopiable
	{

		/**
		 * 
		 */
		private SigDiffSymbol mTempSymbol = null;

		
		/**
		 * Flag whether this object is focused.
		 */
		private boolean mSelectedFlag = false;


		/**
		 * Get the flag as a focused object.
		 * @return whether this object is focused.
		 */
		public boolean isSelected()
		{
			return this.mSelectedFlag;
		}


		/**
		 * Set the flag as a focused object.
		 * @param b focused
		 */
		public void setSelected( final boolean b )
		{
			this.mSelectedFlag = b;
		}

		
		/**
		 * 
		 */
		private SGAxis mXAxis = null;
		
		
		/**
		 * 
		 */
		private SGAxis mYAxis = null;

		
		/**
		 * 
		 */
		private double mXValue1;
		
		
		/**
		 * 
		 */
		private double mXValue2;

		
		/**
		 * 
		 */
		private double mHorizontalYValue;

		
		/**
		 * 
		 */
		private double mYValue1;

		
		/**
		 * 
		 */
		private double mYValue2;
		

		/**
		 * 
		 */
		private Point mPressedSymbolOrigin = null;
		
		
		/**
		 * 
		 */
		private SGProperties mTemporaryProperties = null;


		/**
		 * |bvAbvj[
		 */
		private JPopupMenu mPopupMenu = new JPopupMenu();


		/**
		 * 
		 */
		private SigDiffSymbol()
		{
			super();
			this.init();
		}


		/**
		 * 
		 */
		public Object copy()
		{
			SigDiffSymbol el = new SigDiffSymbol();
			el.setMagnification( this.mMagnification );
			el.setProperties( this.getProperties() );
			el.setLocation( this.getX(), this.getY() );
			el.mTempXAxis = mAxisElement.getConfigurationInCube( this.mXAxis );
			el.mTempYAxis = mAxisElement.getConfigurationInCube( this.mYAxis );
			return el;
		}
		
		private int mTempXAxis = -1;
		private int mTempYAxis = -1;


		/**
		 * 
		 */
		private SigDiffSymbol(
			final float x, final float y, final float w, final float hl, final float hr )
		{
			super(x,y,w,hl,hr);
			this.init();
		}


		/**
		 * 
		 */
		private boolean createPopupMenu()
		{
			JPopupMenu p = this.mPopupMenu;
			
			p.setBounds( 0, 0, 100, 100 );

			p.add( new JLabel( "  -- Significant Difference --" ) );
			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_MOVE_TO_FRONT );
			SGUtility.addItem( p, this, MENUCMD_MOVE_TO_BACK );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_CUT );
			SGUtility.addItem( p, this, MENUCMD_COPY );
			SGUtility.addItem( p, this, MENUCMD_PASTE );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_DELETE );
			SGUtility.addItem( p, this, MENUCMD_DUPLICATE );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_PROPERTY );

			return true;
		}


		/**
		 * 
		 */
		private boolean init()
		{
			this.setWidth( SGDefaultValues.SIGDIFF_SYMBOL_WIDTH );
			this.setPerpendicularHeight1( SGDefaultValues.SIGDIFF_SYMBOL_LEFT_HEIGHT );
			this.setPerpendicularHeight2( SGDefaultValues.SIGDIFF_SYMBOL_RIGHT_HEIGHT );
			final int style = SGUtilityText.getFontStyle( SGDefaultValues.SIGDIFF_SYMBOL_FONT_STYLE );
			if( style==-1 )
			{
				return false;
			}
			this.setFont(
				SGDefaultValues.SIGDIFF_SYMBOL_FONT_NAME,
				style,
				SGDefaultValues.SIGDIFF_SYMBOL_FONT_SIZE
			);

			this.setLineWidth( SGDefaultValues.SIGDIFF_SYMBOL_LINE_WIDTH );
			this.setColor( SGDefaultValues.SIGDIFF_SYMBOL_COLOR );
			this.setSpace( SGDefaultValues.SIGDIFF_SYMBOL_SPACE );

			this.createPopupMenu();

			return true;
		}


		/**
		 * 
		 */
		private JPopupMenu getPopupMenu()
		{
			return mPopupMenu;
		}


		
		/**
		 * 
		 */
		private JDialog getDialog()
		{

			mDialog.setActionListener(this);
			mDialog.addWindowListener(this);

			mDialog.setLocation( mDialogOwner.getLocation() );

			mDialog.setColorButtonBorder(true);

			this.setDialogProperty();

			this.mTemporaryProperties = this.getProperties();

			mEditField.setVisible(false);
//			repaint();

			return mDialog;
		}


		/**
		 * @return
		 */
		public String getTagName()
		{
			return TAG_NAME_SIGDIFF_SYMBOL;
		}

		
		/**
		 * 
		 * @param document
		 * @return
		 */
		public Element createElement( final Document document )
		{
			Element el = document.createElement( this.getTagName() );
			if( this.writeProperty(el) == false )
			{
				return null;
			}
			return el;
		}
		
		
		/**
		 * 
		 * @param el
		 * @return
		 */
		public boolean writeProperty( final Element el )
		{
			String cm = SGUtilityNumber.cm;
			String pt = SGUtilityNumber.pt;
			final float ratio = SGIConstants.CM_POINT_RATIO;
			
			el.setAttribute( KEY_LEFT_X_VALUE, Double.toString( this.getLeftXValue() ) );
			el.setAttribute( KEY_LEFT_Y_VALUE, Double.toString( this.getLeftYValue() ) );
			el.setAttribute( KEY_RIGHT_X_VALUE, Double.toString( this.getRightXValue() ) );
			el.setAttribute( KEY_RIGHT_Y_VALUE, Double.toString( this.getRightYValue() ) );
			el.setAttribute( KEY_HORIZONTAL_Y_VALUE, Double.toString( this.getHorizontalYValue() ) );
			el.setAttribute( KEY_X_AXIS_POSITION, mAxisElement.getAxisLocation( this.mXAxis ) );
			el.setAttribute( KEY_Y_AXIS_POSITION, mAxisElement.getAxisLocation( this.mYAxis ) );
			
			el.setAttribute( KEY_TEXT, this.getText() );
			el.setAttribute( KEY_FONT_NAME, this.getFontName() );
			el.setAttribute( KEY_FONT_SIZE, Float.toString( this.getFontSize() ) + pt );
			el.setAttribute( KEY_FONT_STYLE, SGUtilityText.getFontStyleName( this.getFontStyle() ) );
			el.setAttribute( KEY_DRAWING_ELEMENT_COLORS, SGUtilityText.getColorListString( this.getColorList() ) );
			el.setAttribute( KEY_LINE_VISIBLE, Boolean.toString( this.isLineVisible() ) );
			el.setAttribute( KEY_LINE_WIDTH, Float.toString( this.getLineWidth() ) + pt );
			el.setAttribute( KEY_SPACE, Float.toString( this.getSpace()*ratio ) + cm );

			return true;
		}

		

		/**
		 * 
		 */
		public boolean readProperty( final Element element )
		{
			SigDiffPropertiesWithAxes p = this.readProperty_(element);
			if( p==null )
			{
				return false;
			}
			if( this.setProperties(p) == false )
			{
				return false;
			}
			return true;
		}

		

		private SigDiffPropertiesWithAxes readProperty_( final Element el )
		{
			final String cm = SGUtilityNumber.cm;
			final String pt = SGUtilityNumber.pt;
			final String degree = SGUtilityNumber.degree;
			final float ratio = SGIConstants.CM_POINT_RATIO;

			String str = null;
			Number num = null;
			Color cl = null;
			Boolean b = null;
			ArrayList list = null;

			
			// left x value
			str = el.getAttribute( KEY_LEFT_X_VALUE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getDouble(str);
			if( num==null )
			{
				return null;
			}
			final double leftXValue = num.doubleValue();
		
		
			// left y value
			str = el.getAttribute( KEY_LEFT_Y_VALUE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getDouble(str);
			if( num==null )
			{
				return null;
			}
			final double leftYValue = num.doubleValue();


			// right x value
			str = el.getAttribute( KEY_RIGHT_X_VALUE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getDouble(str);
			if( num==null )
			{
				return null;
			}
			final double rightXValue = num.doubleValue();
		
		
			// right y value
			str = el.getAttribute( KEY_RIGHT_Y_VALUE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getDouble(str);
			if( num==null )
			{
				return null;
			}
			final double rightYValue = num.doubleValue();


			// horizontal y value
			str = el.getAttribute( KEY_HORIZONTAL_Y_VALUE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getDouble(str);
			if( num==null )
			{
				return null;
			}
			final double horizontalYValue = num.doubleValue();


			// x axis location
			str = el.getAttribute( KEY_X_AXIS_POSITION );
			if( str.length()==0 )
			{
				return null;
			}
			final int configX = mAxisElement.getConfigurationInCube( str );
			SGAxis xAxis = mAxisElement.getAxisInCube( configX );
			if( xAxis==null )
			{
				return null;
			}
			
			
			// y axis location
			str = el.getAttribute( KEY_Y_AXIS_POSITION );
			if( str.length()==0 )
			{
				return null;
			}
			final int configY = mAxisElement.getConfigurationInCube( str );
			SGAxis yAxis = mAxisElement.getAxisInCube( configY );
			if( yAxis==null )
			{
				return null;
			}

			
			// text
			str = el.getAttribute( KEY_TEXT );
			if( str.length()==0 )
			{
				return null;
			}
			final String text = str;
		
		
			// font name
			str = el.getAttribute( KEY_FONT_NAME );
			if( str.length()==0 )
			{
				return null;
			}
			final String fontName = str;
		
		
			// font size
			str = el.getAttribute( KEY_FONT_SIZE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getFloat(str,pt);
			if( num==null )
			{
				return null;
			}
			final float fontSize = num.floatValue();
		
		
			// font style
			str = el.getAttribute( KEY_FONT_STYLE );
			if( str.length()==0 )
			{
				return null;
			}
			final int fontStyle = SGUtilityText.getFontStyle(str);
			if( fontStyle==-1 )
			{
				return null;
			}
		
		
			// set color
			str = el.getAttribute( KEY_DRAWING_ELEMENT_COLORS );
			if( str.length()==0 )
			{
				return null;
			}
			list = SGUtilityText.getColorList(str);
			if( list==null )
			{
				return null;
			}
			final ArrayList colorList = list;
		
			
			// line visible
			str = el.getAttribute( KEY_LINE_VISIBLE );
			if( str.length()==0 )
			{
				return null;
			}
			b = SGUtilityText.getBoolean(str);
			if( b==null )
			{
				return null;
			}
			final boolean lineVisible = b.booleanValue();

			
			// line width
			str = el.getAttribute( KEY_LINE_WIDTH );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getFloat(str,pt);
			if( num==null )
			{
				return null;
			}
			final float lineWidth = num.floatValue();

			
			// space
			str = el.getAttribute( KEY_SPACE );
			if( str.length()==0 )
			{
				return null;
			}
			num = SGUtilityText.getFloat(str,cm);
			if( num==null )
			{
				return null;
			}
			final float space = num.floatValue()/ratio;

		
			SigDiffPropertiesWithAxes p = new SigDiffPropertiesWithAxes();
			p.leftXValue = leftXValue;
			p.leftYValue = leftYValue;
			p.rightXValue = rightXValue;
			p.rightYValue = rightYValue;
			p.horizontalYValue = horizontalYValue;
			p.xAxis = xAxis;
			p.yAxis = yAxis;
			p.text = text;
			p.fontName = fontName;
			p.fontSize = fontSize;
			p.fontStyle = fontStyle;
			p.lineVisible = lineVisible;
			p.lineWidth = lineWidth;
			p.space = space;
			p.setColorList( colorList );

			// not from property file
			p.setVisible(true);

			return p;

		}
		
		
		
		/**
		 * 
		 */
		public SGProperties getProperties()
		{
			SigDiffPropertiesWithAxes p = new SigDiffPropertiesWithAxes();
			if( this.getProperties(p) == false ) return null;
			return p;
		}



		/**
		 * 
		 */
		public boolean getProperties( SGProperties p )
		{
			if( ( p instanceof SigDiffPropertiesWithAxes ) == false ) return false;

			if( super.getProperties(p) == false ) return false;

			SigDiffPropertiesWithAxes sp = (SigDiffPropertiesWithAxes)p;
			sp.leftXValue = this.getLeftXValue();
			sp.leftYValue = this.getLeftYValue();
			sp.rightXValue = this.getRightXValue();
			sp.rightYValue = this.getRightYValue();
			sp.horizontalYValue = this.getHorizontalYValue();
			sp.xAxis = this.mXAxis;
			sp.yAxis = this.mYAxis;
			
			return true;
		}
		
		

		/**
		 * 
		 */
		public boolean setProperties( final SGProperties p )
		{
			if( ( p instanceof SigDiffPropertiesWithAxes ) == false ) return false;
			
			if( super.setProperties(p) == false ) return false;

			SigDiffPropertiesWithAxes sp = (SigDiffPropertiesWithAxes)p;
			this.setLeftXValue( sp.leftXValue );
			this.setLeftYValue( sp.leftYValue );
			this.setRightXValue( sp.rightXValue );
			this.setRightYValue( sp.rightYValue );
			this.setHorizontalYValue( sp.horizontalYValue );
			this.mXAxis = sp.xAxis;
			this.mYAxis = sp.yAxis;
			
			return true;
		}



		/**
		 * 
		 */
		private SigDiffPropertiesWithAxes getPropertiesFromDialog()
		{
			SGSignificantDifferenceSymbolDialog dg = mDialog;
			SigDiffPropertiesWithAxes p = dg.getProperties();
			if( p==null )
			{
				return null;
			}

			final String xAxisLocation = dg.getXAxisLocation();
			final SGAxis xAxis = mAxisElement.getAxis( xAxisLocation );
			final String yAxisLocation = dg.getYAxisLocation();
			final SGAxis yAxis = mAxisElement.getAxis( yAxisLocation );
			p.xAxis = xAxis;
			p.yAxis = yAxis;
			
			// not from dialog
			p.setVisible( true );
			p.text = this.getText();

			return p;
		}




		/**
		 * 
		 */
		private boolean setDialogProperty()
		{

			final SGSignificantDifferenceSymbolDialog dg = mDialog;


			// axes
			this.setDialogPropertyOfAxis();

			
			//
			dg.setLeftXValue( this.getLeftXValue() );
			dg.setLeftYValue( this.getLeftYValue() );
			dg.setRightXValue( this.getRightXValue() );
			dg.setRightYValue( this.getRightYValue() );
			dg.setHorizontalYValue( this.getHorizontalYValue() );
			
			
			// space
			dg.setSpace( this.mSpace*SGIConstants.CM_POINT_RATIO );

			// font size
			dg.setFontSize( this.getFontSize() );


			// font name
			dg.setFontName( this.getFontName() );			


			// font style
			dg.setFontStyle( this.getFontStyle() );
			
			
			// line visible
			dg.setLineVisible( this.isLineVisible() );

			
			// line width
			dg.setLineWidth( this.getLineWidth() );


			// color
			dg.setColorList( this.getColorList() );


			return true;
		}


		/**
		 * 
		 */
		private boolean setDialogPropertyOfAxis()
		{
			final SGSignificantDifferenceSymbolDialog dg = mDialog;

			final int configX = mAxisElement.getConfigurationInPlane( this.mXAxis );
			final int configY = mAxisElement.getConfigurationInPlane( this.mYAxis );
			boolean flag = dg.setAxisRadioButton( configX, configY );
			if( !flag )
			{
				return false;
			}
			return true;
		}

		
		/**
		 * 
		 */
		public boolean setPropertyWithDialog()
		{
			SigDiffProperties p = this.getPropertiesFromDialog();
			if( p==null )
			{
				return false;
			}

			if( this.setProperties(p) == false )
			{
				return false;
			}
			
			if( this.setShapeWithAxesValues() == false )
			{
				return false;
			}

			return true;
		}



		/**
		 * 
		 */
		public void windowActivated(final WindowEvent e)
		{
//	System.out.println("windowActivated");
		}


		/**
		 * 
		 */
		public void windowDeactivated(final WindowEvent e)
		{
//	System.out.println("windowDeactivated");
		}


		/**
		 * 
		 */
		public void windowIconified(final WindowEvent e)
		{
//	System.out.println("windowIconified");
		}


		/**
		 * 
		 */
		public void windowDeiconified(final WindowEvent e)
		{
//	System.out.println("windowDeiconified");
		}


		/**
		 * 
		 */
		public void windowOpened(final WindowEvent e)
		{
//	System.out.println("windowOpened");
		}


		/**
		 * 
		 */
		public void windowClosed(final WindowEvent e)
		{
//	System.out.println("windowClosed");
		}


		/**
		 * 
		 */
		public void windowClosing(final WindowEvent e)
		{
//	System.out.println("windowClosing");

			Object obj = e.getSource();
//	System.out.println(obj);
			if( obj.equals( mDialog ) )
			{
				this.onCanceled();
			}

		}


		/**
		 * 
		 */
		public void actionPerformed( final ActionEvent e )
		{

			final String command = e.getActionCommand();
			final Object source = e.getSource();

			if( command.equals( MENUCMD_PROPERTY ) )
			{
				this.getDialog().setVisible(true);
				return;
			}
			else if(
				command.equals( MENUCMD_COPY )
				| command.equals( MENUCMD_CUT )
				| command.equals( MENUCMD_PASTE )
				| command.equals( MENUCMD_DELETE )
				| command.equals( MENUCMD_DUPLICATE )
				| command.equals( MENUCMD_MOVE_TO_FRONT )
				| command.equals( MENUCMD_MOVE_TO_BACK )
			)
			{
				notifyToListener( command );
			}


			//
			// for the properties of group
			//

			if( command.equals("OK")
				|| mDialog.getActiveComponentList().contains(source) )
			{
				if( this.onOK() == false ) return;
			}
			else if( command.equals("Cancel") )
			{
				if( this.onCanceled() == false ) return;
			}
			else if( command.equals("Preview") )
			{
				if( this.onPreviewed() == false ) return;
			}


			repaint();

		}


		/**
		 * 
		 */
		private boolean onOK()
		{

			boolean flag;

			// _CAOvpeB擾Đݒ
			flag = this.setPropertyWithDialog();
			if( !flag )
			{
				return false;
			}


			// _CAOoOŃvpeBύXĂꍇ̂݁A
			// XV

			SGProperties pTemp = this.mTemporaryProperties;
			SGProperties pPresent = this.getProperties();
			if( pTemp.equals(pPresent) == false )
			{
				this.mChangedFlag = true;
			}

			this.setShapeWithAxesValues();
			notifyChange();

			//
			this.notifyToRoot();

			this.mTemporaryProperties = null;
			mDialog.setVisible(false);
			mDialog.removeActionListener();
			mDialog.removeWindowListener(this);

			return true;

		}



		/**
		 * 
		 */
		private boolean onCanceled()
		{
			boolean flag = this.recover();
			if( !flag ) return false;

			this.setShapeWithAxesValues();
			notifyChange();

			this.mTemporaryProperties = null;

			mDialog.setVisible(false);
			mDialog.removeActionListener();
			mDialog.removeWindowListener(this);

			return true;
		}


		/**
		 * 
		 */
		private boolean onPreviewed()
		{
			boolean flag = this.setPropertyWithDialog();
			if( !flag ) return false;

			this.setShapeWithAxesValues();
			notifyChange();

			return true;
		}


		/**
		 * 
		 * @return
		 */
		private boolean recover()
		{

			if( this.setProperties( this.mTemporaryProperties ) == false )
			{
				return false;
			}

			this.mTemporaryProperties = null;

			return true;
		}



		/**
		 *
		 */
		public float getX()
		{
			return this.mMagnification*this.mX + mGraphRectX;
		}


		/**
		 *
		 */
		public float getY()
		{
			return this.mMagnification*this.mY + mGraphRectY;
		}


		/**
		 * 
		 * @param x
		 * @return
		 */
		public boolean setX( final float x )
		{
			this.mX = ( x - mGraphRectX )/this.mMagnification;
			return true;
		}


		/**
		 * 
		 * @param y
		 * @return
		 */
		public boolean setY( final float y )
		{
			this.mY = ( y - mGraphRectY )/this.mMagnification;
			return true;			
		}
		
		
		/**
		 * 
		 */
		public void translate( final int dx, final int dy )
		{
			this.setLocation( this.getX() + dx, this.getY() + dy );
			this.createDrawingElement();
			this.setAxisValuesWithShape();
			this.setShapeWithAxesValues();
		}

		
		/**
		 * 
		 * @return
		 */
		public double getLeftXValue()
		{
			if( !this.isFlippingHorizontal() )
			{
				return this.mXValue1;
			}
			else
			{
				return this.mXValue2;
			}
		}

		
		/**
		 * 
		 * @return
		 */
		public double getLeftYValue()
		{
			if( !this.isFlippingHorizontal() )
			{
				return this.mYValue1;
			}
			else
			{
				return this.mYValue2;
			}
		}

		
		/**
		 * 
		 * @return
		 */
		public double getRightXValue()
		{
			if( !this.isFlippingHorizontal() )
			{
				return this.mXValue2;
			}
			else
			{
				return this.mXValue1;
			}
		}

		
		/**
		 * 
		 * @return
		 */
		public double getRightYValue()
		{
			if( !this.isFlippingHorizontal() )
			{
				return this.mYValue2;
			}
			else
			{
				return this.mYValue1;
			}
		}


		/**
		 * 
		 * @return
		 */
		public double getHorizontalYValue()
		{
			return this.mHorizontalYValue;
		}
		
		
		/**
		 * 
		 * @param value
		 */
		public void setLeftXValue( final double value )
		{
			if( !this.isFlippingHorizontal() )
			{
				this.mXValue1 = value;
			}
			else
			{
				this.mXValue2 = value;
			}
		}

		
		/**
		 * 
		 * @param value
		 */
		public void setLeftYValue( final double value )
		{
			if( !this.isFlippingHorizontal() )
			{
				this.mYValue1 = value;
			}
			else
			{
				this.mYValue2 = value;
			}
		}


		/**
		 * 
		 * @param value
		 */
		public void setRightXValue( final double value )
		{
			if( !this.isFlippingHorizontal() )
			{
				this.mXValue2 = value;
			}
			else
			{
				this.mXValue1 = value;
			}
		}

		
		/**
		 * 
		 * @param value
		 */
		public void setRightYValue( final double value )
		{
			if( !this.isFlippingHorizontal() )
			{
				this.mYValue2 = value;
			}
			else
			{
				this.mYValue1 = value;
			}
		}


		/**
		 * 
		 * @param value
		 */
		public void setHorizontalYValue( final double value )
		{
			this.mHorizontalYValue = value;
		}
		
		
		/**
		 * 
		 */
		private boolean pressDrawingElements( final MouseEvent e )
		{

			final int x = e.getX();
			final int y = e.getY();

			if( this.contains(x,y) || this.mStringElement.contains(x,y) )
			{
				// record history
//				this.mTemporaryProperties = this.getProperties();

				// set the temporary object
				this.mTempSymbol = new SigDiffSymbol();
				mTempSymbol.setMagnification( this.mMagnification );
				mTempSymbol.setLocation( this.getX(), this.getY() );
				mTempSymbol.setSize(
					this.getWidth(),
					this.getPerpendicularHeight1(),
					this.getPerpendicularHeight2()
				);

				this.mFlippingHorizontalFlag = this.isFlippingHorizontal();

				this.mMouseLocation = this.getMouseLocation(x,y);
				Cursor cur = null;
				if( this.mMouseLocation==OTHER || this.mMouseLocation==ON_STRING )
				{
					cur = Cursor.getPredefinedCursor( Cursor.MOVE_CURSOR );
				}
				else
				{
					this.getCursor( this.mMouseLocation );
				}
				setMouseCursor( cur );

				return true;
			}

			return false;
		}



		/**
		 * 
		 */
		private boolean mFlippingHorizontalFlag;



		/**
		 * 
		 * @return
		 */
		private ArrayList getAnchorPointList()
		{
			ArrayList list = new ArrayList();
			if( this.isLineVisible() )
			{
				list.add( this.getLeftTerm() );
				list.add( this.getLeftMiddle() );
				list.add( this.getLeftJoint() );
				list.add( this.getHorizontalMiddle() );
				list.add( this.getRightJoint() );
				list.add( this.getRightMiddle() );
				list.add( this.getRightTerm() );
			}
			
			Rectangle2D rect = this.mStringElement.getElementBounds();
			final float x = (float)rect.getX();
			final float y = (float)rect.getY();
			final float w = (float)rect.getWidth();
			final float h = (float)rect.getHeight();
			Point2D pos0 = new Point2D.Float( x, y );
			Point2D pos1 = new Point2D.Float( x+w, y );
			Point2D pos2 = new Point2D.Float( x, y+h );
			Point2D pos3 = new Point2D.Float( x+w, y+h );
			list.add( pos0 );
			list.add( pos1 );
			list.add( pos2 );
			list.add( pos3 );

			return list;
		}



		/**
		 * Location of mouse pointer.
		 */
		private int mMouseLocation;



		/**
		 * 
		 * @param pos
		 * @param radius
		 * @param x
		 * @param y
		 * @return
		 */
		private boolean isInside( final Point2D pos, final int radius, final int x, final int y )
		{
			return( ( Math.abs( pos.getX() - x ) < radius )
				&& ( Math.abs( pos.getY() -  y ) < radius ) );
		}



		/**
		 * }EXʒu𑮐ɐݒ
		 */
		private int getMouseLocation( final int x, final int y )
		{
			final int radius = (int)( 1.25f*ANCHOR_SIZE_FOR_FOCUSED_OBJECTS );

			final Point2D posHorizontalMiddle = this.getHorizontalMiddle();
			final Point2D posLeftMiddle = this.getLeftMiddle();
			final Point2D posRightMiddle = this.getRightMiddle();
			final Point2D posLeftJoint = this.getLeftJoint();
			final Point2D posRightJoint = this.getRightJoint();
			final Point2D posLeftTerm = this.getLeftTerm();
			final Point2D posRightTerm = this.getRightTerm();


			int location = -1;

			if( this.isLineVisible() )
			{
				// 
				if( this.isInside( posHorizontalMiddle, radius, x, y ) )
				{
					location = HORIZONTAL_MIDDLE;
				}
				// ڍ
				else if( this.isInside( posLeftJoint, radius, x, y ) )
				{
					location = LEFT_JOINT;
				}
				// Eڍ
				else if( this.isInside( posRightJoint, radius, x, y ) )
				{
					location = RIGHT_JOINT;
				}
				// ̒[
				else if( this.isInside( posLeftTerm, radius, x, y ) )
				{
					location = LEFT_TERM;
				}
				// ̒
				else if( this.isInside( posLeftMiddle, radius, x, y ) )
				{
					location = LEFT_MIDDLE;
				}
				// E̒[
				else if( this.isInside( posRightTerm, radius, x, y ) )
				{
					location = RIGHT_TERM;
				}
				// E̒
				else if( this.isInside( posRightMiddle, radius, x, y ) )
				{
					location = RIGHT_MIDDLE;
				}
				else
				{
					location = OTHER;
				}
			}

			if( this.mStringElement.contains(x,y) )
			{
				location = ON_STRING;
			}

			return location;
		}



		/**
		 * 
		 */
		private Cursor getCursor( final int location )
		{

			// }EẌʒuɉăJ[\ύX
			Cursor cur = null;
			switch( location )
			{
				case HORIZONTAL_MIDDLE:
				{
					if( !this.isFlippingVertical() )
					{
						cur = new Cursor( Cursor.N_RESIZE_CURSOR );
					}
					else
					{
						cur = new Cursor( Cursor.S_RESIZE_CURSOR );
					}
					break;
				}
				case LEFT_MIDDLE:
				{
					cur = new Cursor( Cursor.W_RESIZE_CURSOR );
					break;
				}
				case RIGHT_MIDDLE:
				{
					cur = new Cursor( Cursor.E_RESIZE_CURSOR );
					break;
				}
				case LEFT_TERM:
				{
					if( !this.isFlippingVerticalLeft() )
					{
						cur = new Cursor( Cursor.SW_RESIZE_CURSOR );
					}
					else
					{
						cur = new Cursor( Cursor.NW_RESIZE_CURSOR );
					}
					break;
				}
				case LEFT_JOINT:
				{
					if( !this.isFlippingVerticalLeft() )
					{
						cur = new Cursor( Cursor.NW_RESIZE_CURSOR );
					}
					else
					{
						cur = new Cursor( Cursor.SW_RESIZE_CURSOR );
					}
					break;
				}
				case RIGHT_TERM:
				{
					if( !this.isFlippingVerticalRight() )
					{
						cur = new Cursor( Cursor.SE_RESIZE_CURSOR );
					}
					else
					{
						cur = new Cursor( Cursor.NE_RESIZE_CURSOR );
					}
					break;
				}
				case RIGHT_JOINT:
				{
					if( !this.isFlippingVerticalRight() )
					{
						cur = new Cursor( Cursor.NE_RESIZE_CURSOR );
					}
					else
					{
						cur = new Cursor( Cursor.SE_RESIZE_CURSOR );
					}
					break;
				}
				case ON_STRING:
				{
					cur = new Cursor( Cursor.HAND_CURSOR );
					break;
				}
				default:
				{
					cur = new Cursor( Cursor.HAND_CURSOR );
				}
			}

//System.out.println(cur);

			return cur;

		}



		/**
		 * 
		 */
		private boolean drag( final MouseEvent e )
		{
//System.out.println("<< drag >>");

			if( mPressedPoint == null )
			{
				return false;
			}

//System.out.println(e.getPoint());
//System.out.println();


			// translation
			if( mMouseLocation == OTHER || mMouseLocation == ON_STRING )
			{
				final boolean flag = this.dragOtherPoint(e);
				return flag;
			}


			SigDiffSymbol temp = this.mTempSymbol;
			final float xOld = temp.getX();
			final float yOld = temp.getY();
			final float wOld = temp.getWidth();
			final float h1Old = temp.getPerpendicularHeight1();
			final float h2Old = temp.getPerpendicularHeight2();

//final float hlOld = mTempSymbol.getLeftHeight();
//final float hrOld = mTempSymbol.getRightHeight();


			final int diffX = e.getX() - mPressedPoint.x;
			final int diffY = e.getY() - mPressedPoint.y;

			final float sizeOldX = wOld;
			final float sizeOldY1 = h1Old;
			final float sizeOldY2 = h2Old;

			float sizeNewX = 0.0f;
			float sizeNewY1 = 0.0f;
			float sizeNewY2 = 0.0f;


			// ȉ̏ōXV
			// ̂܂ܐVɂȂ
			float x = xOld;
			float y = yOld;
			float w = wOld;
			float h1 = h1Old;
			float h2 = h2Old;

//final float r = SGConstants.CM_POINT_RATIO;
//System.out.println(diffX*r+"  "+diffY*r);

			//
			// hbOĂ_ɉďꍇ
			//

			final int loc = this.mMouseLocation;
			final boolean flag = this.mFlippingHorizontalFlag;
			if( loc == HORIZONTAL_MIDDLE )
			{
//System.out.println("NORTH");
				sizeNewY1 = sizeOldY1 - diffY;
				sizeNewY2 = sizeOldY2 - diffY;

				y = yOld + sizeOldY1 - sizeNewY1;
				h1 = sizeNewY1;
				h2 = sizeNewY2;
			}
			else if(
				( loc==LEFT_MIDDLE && !flag )
				||
				( loc == RIGHT_MIDDLE && flag )
			)
			{
				sizeNewX = sizeOldX - diffX;
				x = xOld + sizeOldX - sizeNewX;
				w = sizeNewX;
			}
			else if(
				( loc==RIGHT_MIDDLE && !flag )
				||
				( loc==LEFT_MIDDLE && flag )
			)
			{
				sizeNewX = sizeOldX + diffX;
				w = sizeNewX;
			}
			else if(
				( loc==LEFT_JOINT && !flag )
				||
				( loc==RIGHT_JOINT && flag )
			)
			{
				sizeNewY1 = sizeOldY1 - diffY;
				sizeNewY2 = sizeOldY2 - diffY;
				sizeNewX = sizeOldX - diffX;

				x = xOld + sizeOldX - sizeNewX;
				y = yOld + sizeOldY1 - sizeNewY1;
				w = sizeNewX;
				h1 = sizeNewY1;
				h2 = sizeNewY2;
			}
			else if(
				( loc==RIGHT_JOINT && !flag )
				||
				( loc==LEFT_JOINT && flag )
			)
			{
				sizeNewX = sizeOldX + diffX;
				sizeNewY1 = sizeOldY1 - diffY;
				sizeNewY2 = sizeOldY2 - diffY;

				y = yOld + sizeOldY2 - sizeNewY2;
				w = sizeNewX;
				h1 = sizeNewY1;
				h2 = sizeNewY2;
			}
			else if( 
				( loc==LEFT_TERM && !flag )
				||
				( loc==RIGHT_TERM && flag )
			)
			{
				sizeNewX = sizeOldX - diffX;
				sizeNewY1 = sizeOldY1 + diffY;

				x = xOld + sizeOldX - sizeNewX;
				w = sizeNewX;
				h1 = sizeNewY1;
			}
			else if( 
				( loc==RIGHT_TERM && !flag )
				||
				( loc==LEFT_TERM && flag )
			)
			{
				sizeNewX = sizeOldX + diffX;
				sizeNewY2 = sizeOldY2 + diffY;

				w = sizeNewX;
				h2 = sizeNewY2;
			}

			// update the pressed point
			mPressedPoint.setLocation(
				mPressedPoint.getX() + diffX,
				mPressedPoint.getY() + diffY
			);


			// set properties
			this.setLocation( x, y );
			this.setSize(w,h1,h2);
			this.createDrawingElement();

			temp.setLocation( x, y );
			temp.setSize( w, h1, h2 );

			if( loc==LEFT_TERM | loc==LEFT_JOINT
				| loc==RIGHT_TERM | loc==RIGHT_JOINT )
			{
				final int location = this.getMouseLocation( e.getX(), e.getY() );
				setMouseCursor( this.getCursor( location ) );
			}

			return true;

		}



		/**
		 * 
		 */
		private boolean dragOtherPoint( final MouseEvent e )
		{
			// parallel displacement
			if ( mPressedPoint != null )
			{
				// set the location to the symbol
				final int dx = e.getX() - mPressedPoint.x;
				final int dy = e.getY() - mPressedPoint.y;
				this.translate(dx,dy);

				mPressedPoint = e.getPoint();
			}

			return true;
		}


		private boolean setShapeWithAxesValues()
		{
			final float x1 = calcLocation( this.mXValue1, this.mXAxis, true );
			final float x2 = calcLocation( this.mXValue2, this.mXAxis, true );
			final float y = calcLocation( this.mHorizontalYValue, this.mYAxis, false);
			final float y1 = calcLocation( this.mYValue1, this.mYAxis, false);
			final float y2 = calcLocation( this.mYValue2, this.mYAxis, false );
			
			this.setNodePointLocation(x1,y1,x2,y2,y);
			
			this.createDrawingElement();

			return true;
		}


		private boolean setAxisValuesWithShape()
		{
			final double xValue1 = calcValue( this.getX1(), this.mXAxis, true );
			final double yValue1 = calcValue( this.getY1(), this.mYAxis, false );
			final double xValue2 = calcValue( this.getX2(), this.mXAxis, true );
			final double yValue2 = calcValue( this.getY2(), this.mYAxis, false );
			final double hYValue = calcValue( this.getY(), this.mYAxis, false );

			this.mXValue1 = getNumberInRangeOrder( xValue1, this.mXAxis );
			this.mYValue1 = getNumberInRangeOrder( yValue1, this.mYAxis );
			this.mXValue2 = getNumberInRangeOrder( xValue2, this.mXAxis );
			this.mYValue2 = getNumberInRangeOrder( yValue2, this.mYAxis );
			this.mHorizontalYValue = getNumberInRangeOrder( hYValue, this.mYAxis );

//			this.mXValue1 = xValue1;
//			this.mYValue1 = yValue1;
//			this.mXValue2 = xValue2;
//			this.mYValue2 = yValue2;
//			this.mHorizontalYValue = hYValue;
			
			return true;
		}
		

		/**
		 * 
		 * @return
		 */
		private ArrayList mSigDiffSymbolPropertyHistoryList = new ArrayList();



		/**
		 * 
		 * @return
		 */
		private int mSigDiffStateCounter = 0;



		/**
		 * 
		 */
		public boolean initPropertiesHistory()
		{
			this.addSigDiffSymbolPropertyHistory( this.getProperties() );
			return true;
		}



		/**
		 * 
		 * @return
		 */
		private boolean addSigDiffSymbolPropertyHistory( SGProperties p )
		{

			if( ( p instanceof SigDiffProperties ) == false )
			{
				return false; 
			}

//System.out.println("<< addFigurePropertyHistory >>");
//System.out.println(this.mFigureStateCounter);

			ArrayList list = new ArrayList();
			for( int ii=0; ii<this.mSigDiffStateCounter; ii++ )
			{
				list.add( this.mSigDiffSymbolPropertyHistoryList.get(ii) );
			}
			list.add(p);

			this.mSigDiffSymbolPropertyHistoryList = list;

//System.out.println(this.mFigurePropertyHistoryList);
//System.out.println("x="+p.x+"  y="+p.y);
//System.out.println("w="+p.width+"  h="+p.height);
//System.out.println();

			return true;
		}



		/**
		 * ݁AԂ̂ǂ̈ʒuɂ̂JE^
		 */
		private int mCurrentStateCounter = 0;


		/**
		 * AhDΏۃIuWFNg̗Xg
		 */
		protected ArrayList mUndoableObjectHistoryList = new ArrayList();




		/**
		 * AhDs
		 */
		public boolean undo()
		{
//System.out.println("undo : SigDiffSymbol");
//System.out.println();

			this.mSigDiffStateCounter--;

			SigDiffProperties p
				= (SigDiffProperties)this.mSigDiffSymbolPropertyHistoryList.get(
					this.mSigDiffStateCounter);
//System.out.println(p);
//System.out.println();

			this.setProperties(p);

			if( this.setShapeWithAxesValues() == false )
			{
				return false;
			}

			this.createDrawingElement();
//			repaint();

			return true;
		}


		/**
		 * hDs
		 */
		public boolean redo()
		{
//System.out.println("redo : SigDiffSymbol");
//System.out.println();

			this.mSigDiffStateCounter++;

			SigDiffProperties p
				= (SigDiffProperties)this.mSigDiffSymbolPropertyHistoryList.get(
					this.mSigDiffStateCounter);
//System.out.println(p);
//System.out.println();

			this.setProperties(p);

			if( this.setShapeWithAxesValues() == false )
			{
				return false;
			}

			this.createDrawingElement();
//			repaint();

			return true;
		}



		/**
		 * AhD˗
		 */
		public boolean onUndo()
		{
			return this.undo();
		}

	
	
		/**
		 * hD˗
		 */
		public boolean onRedo()
		{
			return this.redo();
		}


		/**
		 * IuWFNg̗XV
		 * @return
		 */
		public boolean updateObjectHistory( final SGIUndoable obj )
		{
			ArrayList objList = new ArrayList();
			objList.add(obj);
			boolean flag = this.updateObjectHistory(objList);
			if( !flag )
			{
				return false;
			}

			return true;
		}



		/**
		 * IuWFNg̗XV
		 */
		public boolean updateObjectHistory( final ArrayList objList )
		{

			ArrayList list = new ArrayList();
			for( int ii=0; ii<this.mCurrentStateCounter; ii++ )
			{
				Object obj = this.mUndoableObjectHistoryList.get(ii);
				list.add(obj);
			}
			list.add( new ArrayList(objList) );

			this.mUndoableObjectHistoryList = list;
			this.mCurrentStateCounter++;

//System.out.println("<< updateObjectHistory >>");
//System.out.println(this.mUndoableObjectHistoryList);
//System.out.println(this.mCurrentStateCounter);
//System.out.println();

			return true;
		}



		/**
		 * ̍XV̎sBAhDΏۂ̑삪sꂽƂɁA^ɌĂ΂B
		 */
		public boolean updateHistory()
		{

			if( this.isChanged() )
			{
				this.updateThisObjectHistory();
				this.setChanged(false);
				this.updateObjectHistory(this);
			}

			return true;
		}


		/**
		 * 
		 */
		public boolean updateThisObjectHistory()
		{
			this.mSigDiffStateCounter++;
			this.addSigDiffSymbolPropertyHistory( this.getProperties() );
			return true;
		}


		/**
		 * 
		 */
		public boolean isChanged()
		{
			return this.mChangedFlag;
		}


		private boolean mChangedFlag = false;

		
		public void setChanged( final boolean b )
		{
			this.mChangedFlag = b;
		}


		/**
		 * 
		 *
		 */
		public void notifyToRoot()
		{
			notifyToRootFromFigureElement();
		}


	}



	/**
	 * 
	 */
	public static class SigDiffPropertiesWithAxes extends SigDiffProperties
	{

		double leftXValue;
		double rightXValue;
		double leftYValue;
		double rightYValue;
		double horizontalYValue;
		SGAxis xAxis;
		SGAxis yAxis;
		

		public SigDiffPropertiesWithAxes()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffPropertiesWithAxes ) == false ) return false;

			if( super.equals( obj ) == false ) return false;
			
			SigDiffPropertiesWithAxes p = (SigDiffPropertiesWithAxes)obj;

			if( p.leftXValue != this.leftXValue ) return false;
			if( p.rightXValue != this.rightXValue ) return false;
			if( p.leftYValue != this.leftYValue ) return false;
			if( p.rightYValue != this.rightYValue ) return false;
			if( p.horizontalYValue != this.horizontalYValue ) return false;
			if( p.xAxis.equals( this.xAxis ) == false ) return false;
			if( p.yAxis.equals( this.yAxis ) == false ) return false;

			return true;
		}

	}





}
