/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement;

public class SGLegendDialog
extends SGPropertyDialog {
    public static final String TITLE = "Legend Properties";
    private JButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBackgroundLabel;
    private JSeparator mBackgroundSeparator;
    private JCheckBox mBackgroundTransparentCheckBox;
    private JButton mCancelButton;
    private JPanel mCommonPanel;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFrameLabel;
    private JButton mFrameLineColorButton;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private JSeparator mFrameSeparator;
    private JCheckBox mFrameVisibleCheckBox;
    private JLabel mLabelSpace1;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JPanel mLegendPanel;
    private JCheckBox mLegendVisibleCheckBox;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JButton mStringColorButton;
    private JLabel mStringColorLabel;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mXValueLabel;
    private JTextField mXValueTextField;
    private JLabel mYValueLabel;
    private JTextField mYValueTextField;
    private JPanel mlButtonPanel;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGLegendDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mLabelSpace1 = new JLabel();
        this.mLegendPanel = new JPanel();
        this.mLegendVisibleCheckBox = new JCheckBox();
        this.mFrameVisibleCheckBox = new JCheckBox();
        this.mFrameLabel = new JLabel();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mBackgroundColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameLineColorButton = new JButton();
        this.mFrameSeparator = new JSeparator();
        this.mBackgroundColorButton = new JButton();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mStringColorLabel = new JLabel();
        this.mFontNameComboBox = new JComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontStyleComboBox = new JComboBox();
        this.mStringColorButton = new JButton();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBackgroundLabel = new JLabel();
        this.mBackgroundTransparentCheckBox = new JCheckBox();
        this.mLocationLabel = new JLabel();
        this.mBackgroundSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new JTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new JTextField();
        this.mFontStyleLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mlButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.mLabelSpace1.setText("  ");
        this.getContentPane().setLayout(new GridBagLayout());
        this.mLegendPanel.setLayout(new GridBagLayout());
        this.mLegendPanel.setBorder(new BevelBorder(0));
        this.mLegendPanel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLegendVisibleCheckBox.setText("Visible");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 70, 5, 5);
        this.mLegendPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.mLegendPanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameSeparator, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mStringColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mStringColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorLabel, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        this.mFontSizeSpinner.setMinimumSize(new Dimension(25, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mStringColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorButton, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mLegendPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        this.mBackgroundTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundTransparentCheckBox, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mLegendPanel.add((Component)this.mBackgroundSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mXValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mYValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.mLegendPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mLegendPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mlButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mlButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mlButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mlButtonPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mLeftBottomRadioButton);
        buttonGroup.add(this.mLeftTopRadioButton);
        buttonGroup.add(this.mRightBottomRadioButton);
        buttonGroup.add(this.mRightTopRadioButton);
        buttonGroup.add(this.mNoAxisSelectionRadioButton);
        this.mFrameLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mStringColorButton.addActionListener(this);
        this.mFrameLineColorButton.addActionListener(this);
        this.mBackgroundColorButton.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mBackgroundTransparentCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mFrameLineColorButton;
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mLegendVisibleCheckBox)) {
            this.setLegendVisible(this.mLegendVisibleCheckBox.isSelected());
        } else if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameComponentsEnabled(this.mFrameVisibleCheckBox.isSelected());
        } else if (object.equals(this.mBackgroundTransparentCheckBox)) {
            this.setBackgroundComponentsEnabled(!this.mBackgroundTransparentCheckBox.isSelected());
        }
    }

    private boolean setAllLegendComponentsEnabled(boolean bl) {
        this.mStringLabel.setEnabled(bl);
        this.setStringComponentsEnabled(bl);
        this.mFrameLabel.setEnabled(bl);
        this.mFrameVisibleCheckBox.setEnabled(bl);
        boolean bl2 = this.mFrameVisibleCheckBox.isSelected();
        this.setFrameComponentsEnabled(bl & bl2);
        this.mBackgroundLabel.setEnabled(bl);
        this.mBackgroundTransparentCheckBox.setEnabled(bl);
        boolean bl3 = !this.mBackgroundTransparentCheckBox.isSelected();
        this.setBackgroundComponentsEnabled(bl & bl3);
        return true;
    }

    private boolean setStringComponentsEnabled(boolean bl) {
        this.mFontFamilyLabel.setEnabled(bl);
        this.mFontStyleLabel.setEnabled(bl);
        this.mFontNameComboBox.setEnabled(bl);
        this.mFontStyleComboBox.setEnabled(bl);
        this.mFontSizeLabel.setEnabled(bl);
        this.mFontSizeSpinner.setEnabled(bl);
        this.mStringColorLabel.setEnabled(bl);
        this.mStringColorButton.setEnabled(bl);
        return true;
    }

    private boolean setFrameComponentsEnabled(boolean bl) {
        this.mFrameLineWidthLabel.setEnabled(bl);
        this.mFrameLineWidthSpinner.setEnabled(bl);
        this.mFrameLineColorLabel.setEnabled(bl);
        this.mFrameLineColorButton.setEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(boolean bl) {
        this.mBackgroundColorLabel.setEnabled(bl);
        this.mBackgroundColorButton.setEnabled(bl);
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        this.mXValueTextField.addActionListener(actionListener);
        this.mYValueTextField.addActionListener(actionListener);
        return true;
    }

    public String getXAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Top";
        }
        return string;
    }

    public String getYAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.isSelected();
    }

    public boolean getFrameVisible() {
        return this.mFrameVisibleCheckBox.isSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColorButton.getBackground();
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColorButton.getBackground();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mStringColorButton.getBackground();
    }

    public boolean isLegendTransparent() {
        return this.mBackgroundTransparentCheckBox.isSelected();
    }

    public boolean setXValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mXValueTextField.setText(string);
        return true;
    }

    public boolean setYValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mYValueTextField.setText(string);
        return true;
    }

    public boolean setLegendVisible(boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        this.setAllLegendComponentsEnabled(bl);
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        this.setFrameComponentsEnabled(bl);
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidthSpinner.setValue(new Float(f));
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColorButton.setBackground(color);
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColorButton.setBackground(color);
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColor(Color color) {
        this.mStringColorButton.setBackground(color);
        return true;
    }

    public boolean setLegendTransparent(boolean bl) {
        this.mBackgroundTransparentCheckBox.setSelected(bl);
        this.setBackgroundComponentsEnabled(!bl);
        return true;
    }

    public boolean setAxisRadioButton(int n, int n2) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        this.mLeftBottomRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightBottomRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        this.mLeftTopRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightTopRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mFrameLineColorButton);
        arrayList.add(this.mStringColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        return arrayList;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGLegendElement.LegendCommonProperties getCommonProperties() {
        SGLegendElement.LegendCommonProperties legendCommonProperties = new SGLegendElement.LegendCommonProperties();
        legendCommonProperties.visible = this.getLegendVisible();
        legendCommonProperties.frameLineVisible = this.getFrameVisible();
        Number number = this.getFrameLineWidth();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        legendCommonProperties.frameLineWidth = number.floatValue();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isLegendTransparent();
        legendCommonProperties.fontName = this.getFontName();
        Number number2 = this.getFontSize();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        legendCommonProperties.fontSize = number2.floatValue();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getTextColor();
        return legendCommonProperties;
    }
}

