/*
 * SGAxisDialog.java
 *
 * Created on 2004/06/09, 15:04
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/**
 *
 * @author  kuromaru
 */
public class SGAxisDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Axis Properties";


    /** Creates new form SGAxisDialog */
    public SGAxisDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTabbedPane = new javax.swing.JTabbedPane();
        mBottomPanel = new javax.swing.JPanel();
        mTopPanel = new javax.swing.JPanel();
        mLeftPanel = new javax.swing.JPanel();
        mRightPanel = new javax.swing.JPanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mAxisCommonPanel = new javax.swing.JPanel();
        mAxisLinePanel = new javax.swing.JPanel();
        mAxisLineSeparator = new javax.swing.JSeparator();
        mAxisWidthLabel1 = new javax.swing.JLabel();
        mAxisWidthLabel2 = new javax.swing.JLabel();
        mScaleWidthLabel1 = new javax.swing.JLabel();
        mScaleWidthLabel2 = new javax.swing.JLabel();
        mScaleLengthLabel1 = new javax.swing.JLabel();
        mScaleLengthLabel2 = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mAxisLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mScaleLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mScaleLineLengthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new javax.swing.JButton();
        mAxisLineLeftSpaceLabel = new javax.swing.JLabel();
        mAxisLineRightSpaceLabel = new javax.swing.JLabel();
        mFontSeparator = new javax.swing.JSeparator();
        mFontLabel = new javax.swing.JLabel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontSizeLabel = new javax.swing.JLabel();
        mFontColorLabel = new javax.swing.JLabel();
        mFontTypeComboBox = new javax.swing.JComboBox();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontNameComboBox = new javax.swing.JComboBox();
        mFontColorButton = new javax.swing.JButton();
        mFrameLabel = new javax.swing.JLabel();
        mFrameVisibleCheckBox = new javax.swing.JCheckBox();
        mFrameLineWidthLabel = new javax.swing.JLabel();
        mFrameLineColorLabel = new javax.swing.JLabel();
        mFrameLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFrameColorButton = new javax.swing.JButton();
        mFontStyleLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mTabbedPane.setFont(new java.awt.Font("Dialog", 1, 12));
        mBottomPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Bottom", mBottomPanel);

        mTopPanel.setLayout(new java.awt.GridBagLayout());

        mTopPanel.setFont(new java.awt.Font("Dialog", 1, 14));
        mTabbedPane.addTab("Top", mTopPanel);

        mLeftPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Left", mLeftPanel);

        mRightPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Right", mRightPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mTabbedPane, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mAxisCommonPanel.setLayout(new java.awt.GridBagLayout());

        mAxisLinePanel.setLayout(new java.awt.GridBagLayout());

        mAxisLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mAxisLinePanel.add(mAxisLineSeparator, gridBagConstraints);

        mAxisWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisWidthLabel1.setText("Axis Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        mAxisLinePanel.add(mAxisWidthLabel1, gridBagConstraints);

        mAxisWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 10, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mAxisLinePanel.add(mAxisWidthLabel2, gridBagConstraints);

        mScaleWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleWidthLabel1.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mAxisLinePanel.add(mScaleWidthLabel1, gridBagConstraints);

        mScaleWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 5);
        mAxisLinePanel.add(mScaleWidthLabel2, gridBagConstraints);

        mScaleLengthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mAxisLinePanel.add(mScaleLengthLabel1, gridBagConstraints);

        mScaleLengthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLengthLabel2.setText("Length");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 5);
        mAxisLinePanel.add(mScaleLengthLabel2, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mAxisLinePanel.add(mLineColorLabel, gridBagConstraints);

        mAxisLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mAxisLineWidthSpinner, gridBagConstraints);

        mScaleLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mScaleLineWidthSpinner, gridBagConstraints);

        mScaleLineLengthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mScaleLineLengthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mLineColorButton, gridBagConstraints);

        mAxisLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mAxisLinePanel.add(mAxisLineLeftSpaceLabel, gridBagConstraints);

        mAxisLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        mAxisLinePanel.add(mAxisLineRightSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mAxisLinePanel.add(mFontSeparator, gridBagConstraints);

        mFontLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFontLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontLabel, gridBagConstraints);

        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFontSizeLabel, gridBagConstraints);

        mFontColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFontColorLabel, gridBagConstraints);

        mFontTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontTypeComboBox, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontNameComboBox, gridBagConstraints);

        mFontColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontColorButton, gridBagConstraints);

        mFrameLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFrameLabel.setText("Frame");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFrameLabel, gridBagConstraints);

        mFrameVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mAxisLinePanel.add(mFrameVisibleCheckBox, gridBagConstraints);

        mFrameLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFrameLineWidthLabel, gridBagConstraints);

        mFrameLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFrameLineColorLabel, gridBagConstraints);

        mFrameLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFrameLineWidthSpinner, gridBagConstraints);

        mFrameColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFrameColorButton, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mAxisCommonPanel.add(mAxisLinePanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mAxisCommonPanel;
    private javax.swing.JLabel mAxisLineLeftSpaceLabel;
    private javax.swing.JPanel mAxisLinePanel;
    private javax.swing.JLabel mAxisLineRightSpaceLabel;
    private javax.swing.JSeparator mAxisLineSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mAxisLineWidthSpinner;
    private javax.swing.JLabel mAxisWidthLabel1;
    private javax.swing.JLabel mAxisWidthLabel2;
    private javax.swing.JPanel mBottomPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mFontColorButton;
    private javax.swing.JLabel mFontColorLabel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JLabel mFontLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JSeparator mFontSeparator;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JComboBox mFontTypeComboBox;
    private javax.swing.JButton mFrameColorButton;
    private javax.swing.JLabel mFrameLabel;
    private javax.swing.JLabel mFrameLineColorLabel;
    private javax.swing.JLabel mFrameLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFrameLineWidthSpinner;
    private javax.swing.JCheckBox mFrameVisibleCheckBox;
    private javax.swing.JPanel mLeftPanel;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JPanel mRightPanel;
    private javax.swing.JLabel mScaleLengthLabel1;
    private javax.swing.JLabel mScaleLengthLabel2;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mScaleLineLengthSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mScaleLineWidthSpinner;
    private javax.swing.JLabel mScaleWidthLabel1;
    private javax.swing.JLabel mScaleWidthLabel2;
    private javax.swing.JTabbedPane mTabbedPane;
    private javax.swing.JPanel mTopPanel;
    // ϐ錾̏I//GEN-END:variables

    
    
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGAxisDialog.TITLE );


		//
		// Xsi[f̐ݒ
		//

		// axis line width
		this.mAxisLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// scale line width
		this.mScaleLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// scale line length
		this.mScaleLineLengthSpinner.initProperties(
			new SpinnerNumberModel( 0.10, 0.0, 0.5, 0.05 ),
			SGSpinner.SPINNER_UNIT_CM );

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// frame line width
		this.mFrameLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// font name
		final String fontArray[] = SGUtility.getAvailableFontNames();
		for(int ii=0 ; ii<fontArray.length ; ii++)
		{
			this.mFontNameComboBox.addItem( fontArray[ii] );
		}

		// font style
		final String[] styleNameArray = {
			SGIConstants.FONT_PLAIN,
			SGIConstants.FONT_ITALIC,
			SGIConstants.FONT_BOLD,
			SGIConstants.FONT_BOLD_ITALIC
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mFontTypeComboBox.addItem( styleNameArray[ii] );
		}

		this.pack();


		//
		// add an action listener
		//

		// for color selection
		this.mLineColorButton.addActionListener(this);
		this.mFontColorButton.addActionListener(this);
		this.mFrameColorButton.addActionListener(this);

		// check box
		this.mFrameVisibleCheckBox.addActionListener(this);



		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;



		return true;
	}


	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
//System.out.println(source);

		if( source.equals( this.mFrameVisibleCheckBox ) )
		{
			this.setFrameLineComponentsEnabled( this.mFrameVisibleCheckBox.isSelected() );
		}

	}



	/**
	 * 
	 * @return
	 */
	private boolean setFrameLineComponentsEnabled( final boolean b )
	{
		this.mFrameLineWidthLabel.setEnabled(b);
		this.mFrameLineWidthSpinner.setEnabled(b);
		this.mFrameLineColorLabel.setEnabled(b);
		this.mFrameColorButton.setEnabled(b);
		return true;
	}




	/**
	 * 
	 */
	public JPanel getTopAxisPanel()
	{
		return this.mTopPanel;
	}

	/**
	 * 
	 */
	public JPanel getBottomAxisPanel()
	{
		return this.mBottomPanel;
	}

	/**
	 * 
	 */
	public JPanel getLeftAxisPanel()
	{
		return this.mLeftPanel;
	}

	/**
	 * 
	 */
	public JPanel getRightAxisPanel()
	{
		return this.mRightPanel;
	}



	/**
	 * 
	 */
	public Number getAxisLineWidth()
	{
		return this.mAxisLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getScaleLineWidth()
	{
		return this.mScaleLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getScaleLineLength()
	{
		return this.mScaleLineLengthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getBackground();
	}

	/**
	 * 
	 */
	public String getFontName()
	{
		return this.mFontNameComboBox.getSelectedItem().toString();
	}

	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}

	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontTypeComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}

	/**
	 * 
	 */
	public Color getStringColor()
	{
		return this.mFontColorButton.getBackground();
	}

	/**
	 * 
	 */
	public boolean getFrameLinesVisibleFlag()
	{
		return this.mFrameVisibleCheckBox.isSelected();
	}

	/**
	 * 
	 */
	public Number getFrameLineWidth()
	{
		return this.mFrameLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getFrameLineColor()
	{
		return this.mFrameColorButton.getBackground();
	}



	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mAxisLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleLineWidth( final float width )
	{
		this.mScaleLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleLineLength( final float length )
	{
		this.mScaleLineLengthSpinner.setValue(	new Double( length ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color cl )
	{
		this.mLineColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double( size ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setStringColor( final Color cl )
	{
		this.mFontColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontTypeComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameVisible( final boolean flag )
	{
		this.mFrameVisibleCheckBox.setSelected( flag );
		this.setFrameLineComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineWidth( final float width )
	{
		this.mFrameLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineColor( final Color cl )
	{
		this.mFrameColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();

		list.add( this.mLineColorButton );
		list.add( this.mFontColorButton );
		list.add( this.mFrameColorButton );

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mAxisLineWidthSpinner );
		list.add( this.mScaleLineWidthSpinner );
		list.add( this.mScaleLineLengthSpinner );
		list.add( this.mFontSizeSpinner );
		list.add( this.mFrameLineWidthSpinner );

		return list;
	}



	/**
	 * 
	 * @param panel
	 * @return
	 */
	public boolean setSelectedPanel( final SGAxisPanel panel )
	{
		Component[] array = this.mTabbedPane.getComponents();
		for( int ii=0; ii<array.length; ii++ )
		{
			JPanel p = (JPanel)array[ii];
			Component com = p.getComponent(0);
			if( com.equals(panel) )
			{
				this.mTabbedPane.setSelectedComponent(p);
				break;
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGAxisElement.AxisCommonProperties getCommonProperties()
	{

		final SGAxisElement.AxisCommonProperties p
			= new SGAxisElement.AxisCommonProperties();


		// axis line width
		final Number axisLineWidth = this.getAxisLineWidth();
		if( axisLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.axisLineWidth = axisLineWidth.floatValue();
		}


		// scale line width
		final Number scaleLineWidth = this.getScaleLineWidth();
		if( scaleLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.scaleLineWidth = scaleLineWidth.floatValue();
		}


		// scale line length
		final Number scaleLineLength = this.getScaleLineLength();
		if( scaleLineLength==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.scaleLineLength = scaleLineLength.floatValue()/SGIConstants.CM_POINT_RATIO;
		}


		// line color
		p.lineColor = this.getLineColor();


		// font name
		p.fontName = this.getFontName();


		// font size
		final Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize = fontSize.floatValue();
		}


		// font style
		p.fontStyle = this.getFontStyle();


		// string color
		p.stringColor = this.getStringColor();


		// frame line visible
		p.frameLinesVisibleFlag = this.getFrameLinesVisibleFlag();


		// frame line width
		final Number frameLineWidth = this.getFrameLineWidth();
		if( frameLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.frameLineWidth = frameLineWidth.floatValue();
		}


		// frame line color
		p.frameLineColor = this.getFrameLineColor();


		return p;

	}



}
