
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * An interface for objects on a figure.
 */

public interface SGIFigureElement extends SGIUndoable, SGIConstants
{

	/**
	 * Add a new data.
	 * @param data a new data.
	 * @return true:secceeded, false:failed
	 */
//	public boolean addData( SGData data );



	/**
	 * 
	 * @param data
	 * @param name
	 * @return
	 */
	public boolean addData( final SGData data, final String name );



	/**
	 * 
	 * @param data
	 * @return
	 */
	public boolean removeData( SGData data );



	/**
	 * 
	 * @return
	 */
	public ArrayList getDataList();



	/**
	 * 
	 * @param data
	 * @param name
	 * @param p
	 * @return
	 */
	public boolean addData( final SGData data, final String name, final SGProperties p );


	/*
	 * 
	 */
	public SGProperties getDataProperties( SGData data );


	/**
	 * Zoom in/out this component.<BR>
	 */
	public boolean zoom( float mag );


	/**
	 * Synchronize this component to the other component. <BR>
	 * @param element the SGFigureElement object whose property has chenged.
	 * @return true:succeeded, false:failed
	 */
	public boolean synchronize( SGIFigureElement element );


	/**
	 * 
	 */
	public boolean synchronizeArgument( SGIFigureElement element );



	/**
	 * 
	 * @param rect
	 * @return
	 */
	public void notifyChange();


	/**
	 * 
	 */
	public boolean setViewBounds( Rectangle2D rect );



	/**
	 * 
	 * @param topAndBottom
	 * @param leftAndRight
	 * @return
	 */
	public boolean getMarginAroundGraphRect(
		final SGTuple2f topAndBottom,
		final SGTuple2f leftAndRight );


	/**
	 * 
	 * @return
	 */
	public float getGraphRectX();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectY();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectWidth();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectHeight();


	/**]
	 * 
	 */
	public Rectangle2D getGraphRect();



	/**
	 * 
	 * @return
	 */
	public boolean setGraphRect( float x, float y, float width, float height );

	
	
	/**
	 * 
	 * @param rect
	 * @return
	 */
	public boolean setGraphRect( Rectangle2D rect );

	

	/**
	 * 
	 */
	public boolean setGraphRectLocation( float x, float y );


	/**
	 * 
	 */
	public boolean setGraphRectSize( float width, float height );



	/**
	 * 
	 */
	public SGTuple2f getISize();


	/**
	 * 
	 */
	public SGTuple2f getILocation();


	/**
	 * 
	 */
	public boolean setISize( SGTuple2f size );


	/**
	 * 
	 */
	public boolean setILocation( SGTuple2f pos );



	/**
	 * 
	 */
	public boolean setDialogOwner( Frame frame );



	/**
	 * 
	 */
	public Cursor getFigureElementCursor();



	/**
	 * 
	 * @param e
	 */
	public boolean onMouseClicked( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMousePressed( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseDragged( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseReleased( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onDrawingElement( int x, int y );



	/**
	 * 
	 */
	public void addActionListener( ActionListener listener );


	/**
	 * 
	 */
	public void removeActionListener( ActionListener listener );


	/**
	 * 
	 * @param document
	 * @return
	 */
	public Element createElement( final Document document );
	
	
	
	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean readProperty( final Element element );

	
	
	/**
	 * Create objects related to the data with information given by an Element object.
	 * @param el an Element object
	 * @param data a data object
	 * @return true:succeeded, false:failed
	 */
	public boolean createDataObject( Element el, SGData data );
	


	/**
	 * Clear all focused objects.
	 * @return true:succeeded, false:failed
	 */
	public boolean clearFocusedObjects();

	

	/**
	 * 
	 *
	 */
	public boolean hideSelectedObjects();


	/**
	 * Set the visibility of symbols around the focused objects.
	 * This method just hide the symbol, and does not clear
	 * the list of the focused objects.
	 * @param b visibility
	 */
	public void setSymbolsVisibleAroundFocusedObjects( final boolean b );

	
	
	/**
	 * Set the visibility of symbols around all objects.
	 * @param b visibility
	 */
	public void setSymbolsVisibleAroundAllObjects( final boolean b );
	

	
	/**
	 * 
	 * @param dx
	 * @param dy
	 */
	public void translateSelectedObjects( final int dx, final int dy );


	/**
	 * 
	 * @return
	 */
	public boolean setTemporaryPropertiesOfFocusedObjects();


	/**
	 * 
	 * @return
	 */
	public boolean setChangedFocusedObjects();


	/**
	 * 
	 * @return
	 */
	public ArrayList getFocusedObjectsList();
	

	/**
	 * Duplicate the focused objects.
	 * @return true:succeeded, false:failed
	 */
	public boolean duplicateFocusedObjects();


	/**
	 * Returns the list of copied objects.
	 * @return list of copied objects
	 */
	public ArrayList getCopiedObjectsList();


	/**
	 * Cut focused copiable objects.
	 * @return a list of cut objects
	 */
	public ArrayList cutFocusedObjects();


	/**
	 * Paste the objects.
	 * @param list of the objects to be pasted
	 * @return true:succeeded, false:failed
	 */
	public boolean paste( ArrayList list );


	/**
	 * Move the focused objects to front or back.
	 * @param toFront - flag whether to front or back
	 * @return true:succeeded, false:failed
	 */
	public boolean moveFocusedObjects( boolean toFront );



	public static final String KEY_DATA_TYPE = "Type";

	public static final String KEY_DATA_NAME = "Name";
	public static final String KEY_VISIBLE_IN_LEGEND = "VisibleInLegend";


	public static final String KEY_AXIS_POSITION = "AxisPosition";
	public static final String KEY_X_AXIS_POSITION = "XAxisPosition";
	public static final String KEY_Y_AXIS_POSITION = "YAxisPosition";

	
	/**
	 * The effective digit for the axis range.
	 */
	public static final int AXIS_SCALE_EFFECTIVE_DIGIT = 4;

	
	
}


