/*
 * SGColorDialog.java
 *
 * Created on 2004/07/12, 18:44
 */

package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.DefaultColorSelectionModel;


/**
 *
 * @author  kuromaru
 */
public class SGColorDialog extends JDialog
{

	/** Creates new form SGColorDialog */
	public SGColorDialog( final JDialog parent, final String title, final boolean modal )
	{
		super(parent, title, modal);
		initComponents();
		this.initProperty();
	}


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mColorChooserPanel = new javax.swing.JPanel();
        mColorChooser = new javax.swing.JColorChooser();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mColorChooserPanel.add(mColorChooser);

        getContentPane().add(mColorChooserPanel, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JColorChooser mColorChooser;
    private javax.swing.JPanel mColorChooserPanel;
    // ϐ錾̏I//GEN-END:variables




	/**
	 * 
	 */
	private boolean initProperty()
	{
		mColorChooser.setPreviewPanel( new JPanel() );
		mColorChooser.setSelectionModel( new OriginalColorSelectionModel() );
		pack();
		this.setResizable(false);
		return true;
	}




	/**
	 * 
	 */
	public JColorChooser getColorChooser()
	{
		return this.mColorChooser;
	}



	/**
	 * 
	 */
	public static class OriginalColorSelectionModel extends DefaultColorSelectionModel
	{

		// {NXɓȎ邪privateȂ̂ŁAōĒ`
		private Color selectedColor;

		protected OriginalColorSelectionModel()
		{
			super();
			selectedColor = Color.white;
		}

		public OriginalColorSelectionModel(Color color) {
			super(color);
			selectedColor = color;
		}


		public Color getSelectedColor() {
			return selectedColor;
		}

		// IĂFƓ͂̐Fꍇł
		// ChangeEvent𓊂悤ɏC
		public void setSelectedColor( final Color color) {
			if (color != null) {
				selectedColor = color;
				fireStateChanged();
			}
		}


	}



    
}
