
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;




/**
 *
 * @author  kuromaru
 */
public class SGMultiDataFileChooserWizardDialog
	extends SGFileChooserWizardDialog implements TableModelListener, DropTargetListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Choose data files.";


	/**
	 * 
	 */
	public SGMultiDataFileChooserWizardDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /** Creates new form SGDataFileChooseWizardDialog */
    public SGMultiDataFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mScrollPane = new javax.swing.JScrollPane();
        mInsideScrollPanePanel = new javax.swing.JPanel();
        mSingleFileChooserButtonPanel = new javax.swing.JPanel();
        mTableScrollPane = new javax.swing.JScrollPane();
        mTable = new javax.swing.JTable();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        mScrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        mScrollPane.setPreferredSize(new java.awt.Dimension(458, 200));
        mInsideScrollPanePanel.setLayout(new java.awt.GridBagLayout());

        mInsideScrollPanePanel.setFont(new java.awt.Font("Dialog", 0, 11));
        mSingleFileChooserButtonPanel.setLayout(new javax.swing.BoxLayout(mSingleFileChooserButtonPanel, javax.swing.BoxLayout.Y_AXIS));

        mSingleFileChooserButtonPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mInsideScrollPanePanel.add(mSingleFileChooserButtonPanel, gridBagConstraints);

        mTableScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        mTableScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        mTableScrollPane.setBorder(null);
        mTableScrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        mTableScrollPane.setPreferredSize(new java.awt.Dimension(434, 196));
        mTable.setFont(new java.awt.Font("Dialog", 0, 11));
        mTableScrollPane.setViewportView(mTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mInsideScrollPanePanel.add(mTableScrollPane, gridBagConstraints);

        mScrollPane.setViewportView(mInsideScrollPanePanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        mPanel.add(mScrollPane, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mButtonPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        mPreviousButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mInsideScrollPanePanel;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JScrollPane mScrollPane;
    private javax.swing.JPanel mSingleFileChooserButtonPanel;
    protected javax.swing.JTable mTable;
    private javax.swing.JScrollPane mTableScrollPane;
    // ϐ錾̏I//GEN-END:variables


    
	/**
	 * 
	 */
	public static final String[] COLUMN_NAME
		= { "Figure ID", "Data Type", "Data Name", "File Name" };

	
	public static final int COLUMN_NUM_FIGURE_ID = 0;
	public static final int COLUMN_NUM_DATA_TYPE = 1;
	public static final int COLUMN_NUM_DATA_NAME = 2;
	public static final int COLUMN_NUM_FILE_NAME = 3;


	/**
	 * 
	 */
	private int mFileNumber;

	
	/**
	 * 
	 */
	private DefaultTableModel mTableModel = null;


	
	/**
	 * 
	 */
	private boolean initProperty()
	{
		//
		this.setTitle( SGMultiDataFileChooserWizardDialog.TITLE );

		//
		this.mOKButton.setEnabled(false);

		// table model
		this.mTableModel = new OriginalTableModel();
		this.mTableModel.addTableModelListener(this);
		
		// set the height of all rows
		this.mTable.setRowHeight( DEFAULT_ROW_HEIGHT );
		
		// drag and drop
		DropTarget target = new DropTarget(
			this.mTable,
			DnDConstants.ACTION_COPY_OR_MOVE,
			this,
			true
		);
		this.setDropTarget(target);
		
this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;
	}


	
	/**
	 * 
	 */
	public static final int DEFAULT_ROW_HEIGHT = 16;
	

	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();

		JTable table = this.getTable();
		for( int ii=0; ii<this.mSingleFileChooserButtonArray.length; ii++ )
		{
			if( source.equals( this.mSingleFileChooserButtonArray[ii] ) )
			{
				// disable multi selection
				this.mFileChooser.setMultiSelectionEnabled(false);

				File[] files = this.showFileChooser();
				if( files==null )
				{
					return;
				}

				File f = files[0];
				this.setSelectedFile( ii, f );
				break;
			}
		}
		
	}



	/**
	 * 
	 */
	public static final String NO_DATA = "NO_DATA";


	
	/**
	 * 
	 */
	public void tableChanged( TableModelEvent e )
	{
		boolean enable = true;

		TableModel model = this.mTableModel;
		final int row = model.getRowCount();
		final int column = model.getColumnCount();

		for( int ii=0; ii<row; ii++ )
		{
			for( int jj=0; jj<column; jj++ )
			{
				Object obj = model.getValueAt(ii,jj);
				if( obj==null )
				{
					enable = false;
					break;
				}
			}
			if( !enable )
			{
				break;
			}
		}
		
		this.getOKButton().setEnabled( enable );
	}
	
	

	/**
	 * 
	 */
	public JTable getTable()
	{
		return this.mTable;
	}


	/**
	 * 
	 */
	public boolean setTable( final JTable table )
	{
		this.mTable = table;
		return true;
	}


	/**
	 * 
	 */
	public TableModel getTableModel()
	{
		return this.mTable.getModel();
	}



	/**
	 * 
	 */
	public boolean setTableModel( final TableModel model )
	{
		this.mTable.setModel( model );
		return true;
	}

	
	/**
	 * 
	 * @param array
	 */
	public void setFigureIDArray( final String[] array )
	{
		this.setData( array, COLUMN_NUM_FIGURE_ID );
	}

	
	/**
	 * 
	 * @param array
	 */
	public void setDataNameArray( final String[] array )
	{
		this.setData( array, COLUMN_NUM_DATA_NAME );
	}


	/**
	 * 
	 * @param array
	 */
	public void setDataTypeArray( final String[] array )
	{
		this.setData( array, COLUMN_NUM_DATA_TYPE );
	}

	
	/**
	 * 
	 * @param array
	 */
	public void setFileNameArray( final String[] array )
	{
		this.setData( array, COLUMN_NUM_FILE_NAME );
	}
	

	private void setData( final Object[] data, final int index )
	{
		DefaultTableModel model = this.mTableModel;

		final int column = COLUMN_NAME.length;
		final int row = this.mTableModel.getRowCount();
		Object[][] array = new Object[row][column];
		for( int ii=0; ii<column; ii++ )
		{
			if( ii==index )
			{
				for( int jj=0; jj<row; jj++ )
				{
					array[jj][ii] = data[jj];
				}
			}
			else
			{
				for( int jj=0; jj<row; jj++ )
				{
					array[jj][ii] = ((Vector)model.getDataVector().elementAt(jj)).elementAt(ii);
				}
			}
		}
		model.setDataVector( array, COLUMN_NAME );
		this.setTableModel(model);


		// set selection button unabled
		int num = -1;
		final int col = COLUMN_NUM_DATA_NAME;
		for( int jj=0; jj<row; jj++ )
		{
			Object obj = array[jj][col];
			if( NO_DATA.equals(obj) )
			{
				num = jj;
				break;
			}
		}

		ArrayList list = new ArrayList();
		Component[] cArray = this.mSingleFileChooserButtonPanel.getComponents();
		for( int ii=0; ii<cArray.length; ii++ )
		{
			if( cArray[ii] instanceof JButton )
			{
				list.add( cArray[ii] );
			}
		}

		if( num!=-1 )
		{
			JButton btn = (JButton)list.get(num);
			btn.setEnabled(false);
		}

	}
	

	
	
	/**
	 * 
	 * @param dataNumber
	 */
	public void init( final int dataNumber )
	{

		// remove old buttons
		Component[] old = this.mSingleFileChooserButtonPanel.getComponents();
		for( int ii=0; ii<old.length; ii++ )
		{
			if( old[ii] instanceof JButton )
			{
				JButton b = (JButton)old[ii];
				b.removeActionListener(this);
			}
		}
		this.mSingleFileChooserButtonPanel.removeAll();


		// Set the preferred size of a JPanel component which contains buttons.
		JTable table = this.getTable();
		JTableHeader header = table.getTableHeader();
		final int width = DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH;
		final int height = DEFAULT_ROW_HEIGHT;
		final int pHeight = height*( dataNumber + 1 );
		this.mSingleFileChooserButtonPanel.setPreferredSize( new Dimension( width, pHeight ) );

		
		// Set the preferred size of the scroll pane which contains a JTable component.
		// For the height, use the larger value of mInsideScrollPanePanel and pHeight
		final int insideHeight = this.mInsideScrollPanePanel.getHeight();
		final int h = insideHeight<pHeight ? pHeight : insideHeight;
		final int prefWidth = this.mTableScrollPane.getPreferredSize().width;
		this.mTableScrollPane.setPreferredSize( new Dimension( prefWidth, h ) );

		
		// add a dummy label
		JComponent space = new JLabel(" ");
		space.setFont(new java.awt.Font("Dialog", 1, 12));
		space.setPreferredSize( new Dimension( width, height ) );
		this.mSingleFileChooserButtonPanel.add( space );

		
		// add new buttons
		this.mSingleFileChooserButtonArray = new JButton[dataNumber];
		JButton[] bArray = this.mSingleFileChooserButtonArray;
		for( int ii=0; ii<dataNumber; ii++ )
		{
			JButton b = new JButton(" ");
			b.setFont(new java.awt.Font("Dialog", 1, 12));
			b.setPreferredSize( new Dimension( width, height ) );
			b.addActionListener(this);
			bArray[ii] = b;
			this.mSingleFileChooserButtonPanel.add( b );
		}

		
		// init the table model
		Object[][] data = new Object[dataNumber][];
		for( int ii=0; ii<data.length; ii++ )
		{
			data[ii] = new Object[COLUMN_NAME.length];
		}
		this.setData(data);

	}
	

/*
	public void paint( Graphics g )
	{
		super.paint(g);
		Graphics2D g2d = (Graphics2D)g;
		
		g2d.setStroke( new BasicStroke(3) );
		g2d.setPaint( Color.red );

		JTable table = this.getTable();
		JTableHeader header = table.getTableHeader();
		
		final int x = this.getInsets().left + this.mPanel.getX() + this.mScrollPane.getX()
			+ this.mInsideScrollPanePanel.getX() + this.mTableScrollPane.getX()
			+ this.mTable.getX();
		final int y = this.getInsets().top + this.mPanel.getY() + this.mScrollPane.getY()
			+ this.mInsideScrollPanePanel.getY() + this.mTableScrollPane.getY()
			+ this.mTable.getY();
		final int w = this.mTable.getWidth();
		final int h = this.mTable.getHeight() + header.getHeight();
		Rectangle rect = new Rectangle( x, y, w, h );
//		g2d.draw( rect );

	}
*/	
	
	
	/**
	 * 
	 */
	public static final int DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH = 20;
	
	
	/**
	 * 
	 */
	private JButton[] mSingleFileChooserButtonArray = null;

	
	
	/**
	 * 
	 * @param data
	 */
	public void setData( final Object[][] data )
	{
		DefaultTableModel model = this.mTableModel;
		model.setDataVector( data, COLUMN_NAME );
		this.setTableModel( model );
	}
	
	
	
	/**
	 * 
	 */
	private File[] showFileChooser()
	{
		ArrayList list = this.openFileChooser();
		if( list==null )
		{
			return null;
		}
		if( list.size()==0 )
		{
			return null;
		}

		File[] files = new File[list.size()];
		for( int ii=0; ii<files.length; ii++ )
		{
			files[ii] = (File)list.get(ii);
		}

		return files;
	}


	
	/**
	 * Returns a TreeMap object of figure ID to a list of data files.
	 * @return map object obtained from dialog
	 */
	public TreeMap getSelectedFilePathListMap()
	{
		JTable tab = this.mTable;

		TreeMap map = new TreeMap();
		for( int ii=0; ii<tab.getRowCount(); ii++ )
		{
			// figure ID
			Object id = tab.getValueAt(ii,COLUMN_NUM_FIGURE_ID);

			// list of the path of data files
			Object obj = map.get(id);
			if( obj==null )
			{
				obj = new ArrayList();
				map.put( id, obj );
			}
			ArrayList list = (ArrayList)obj;

			// add the path to the list
			Object name = tab.getValueAt(ii,COLUMN_NUM_FILE_NAME);
			list.add( name );
		}

		return map;
	}





	/**
	 * 
	 */
	public String[] getSelectedFileNames()
	{
		JTable table = this.getTable();
		final int col = COLUMN_NUM_FILE_NAME;
		final int num = table.getRowCount();
		String[] array = new String[num];
		for( int ii=0; ii<num; ii++ )
		{
			array[ii] = (String)table.getValueAt(ii,col);
		}
		return array;
	}


	/**
	 * 
	 */
	private boolean setSelectedFiles( final File[] files )
	{

		JTable table = this.getTable();
		final int col = COLUMN_NUM_FILE_NAME;

		// t@CXV
		for( int ii=0; ii<table.getRowCount(); ii++ )
		{
			table.setValueAt( null, ii, col );
		}

		for( int ii=0; ii<files.length; ii++ )
		{
			this.setSelectedFile( ii, files[ii] );
		}

		return true;
	}

	
	
	/**
	 * 
	 */
	private boolean setSelectedFile( final int row, final File file )
	{
		final int col = COLUMN_NUM_FILE_NAME;
		String path = file.getPath();
		this.mTable.setValueAt( path, row, col );
		return true;
	}

	

	/**
	 * 
	 * @return
	 */
	public int getFileNumber()
	{
		return this.mFileNumber;
	}


	/**
	 * 
	 * @param num
	 */
	public void setFileNumber( final int num )
	{
		if( num<0 )
		{
			new IllegalArgumentException("num<0");
		}
		this.mFileNumber = num;
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


	
	
	/**
	 * 
	 */
	public void dragEnter( final DropTargetDragEvent dtde )
	{
		dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}



	/**
	 * 
	 */
	public void dragExit( final DropTargetEvent dte )
	{
	}



	/**
	 * 
	 */
	public void dragOver( final DropTargetDragEvent dtde )
	{
	}



	/**
	 * 
	 */
	public void drop( final DropTargetDropEvent dtde )
	{
		DropTarget tg = (DropTarget)dtde.getSource();
		Component com = tg.getComponent();
		SGMultiDataFileChooserWizardDialog dg
			= (SGMultiDataFileChooserWizardDialog)com;
		dtde.acceptDrop( DnDConstants.ACTION_COPY_OR_MOVE );

		JTable table = this.mTable;
		TableModel model = this.mTableModel;
		JViewport vp = this.mScrollPane.getViewport();
		Point vpPos = vp.getViewPosition();
		Point location = dtde.getLocation();
		final int originX = this.getInsets().left - vpPos.x;
		final int originY
			= this.getInsets().top
				+ this.mScrollPane.getY() - vpPos.y
				+ table.getRowHeight();
		final Point pos = new Point( location.x-originX, location.y-originY );
		final int column = COLUMN_NUM_FILE_NAME;
		try
		{
			if( ( dtde.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE ) != 0 )
			{
				Transferable trans = dtde.getTransferable();
				List list = (List)trans.getTransferData( DataFlavor.javaFileListFlavor );
				if( list.size()==0 )
				{
					return;
				}
				File file = (File)list.get(0);
				final int row = table.rowAtPoint(pos);
				final int num = table.getRowCount();
				if( NO_DATA.equals( model.getValueAt(row,column) ) == false )
				{
					Rectangle rect = table.getCellRect(row,column,true);
					if( row!=-1 )
					{
						table.setValueAt( file.getPath(), row, column );
					}
				}
			}
		}
		catch ( Exception ex )
		{

		}
		finally
		{
			dtde.dropComplete( false );
		}
	}

	
	
	/**
	 * 
	 */
	public void dropActionChanged( final DropTargetDragEvent dtde )
	{
	}

	
	
	/**
	 * 
	 * @author LANDAU
	 *
	 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
	 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
	 */
	private class OriginalTableModel extends DefaultTableModel
	{
		public OriginalTableModel()
		{
			super();
		}

		public boolean isCellEditable( int rowIndex, int columnIndex )
		{
			return false;
//			return ( columnIndex==COLUMN_NUM_FILE_NAME );
		}

	}

	
/*
    private class OriginalPanel extends JPanel
    {
    	public OriginalPanel()
    	{
    		super();
    	}
    	
    	public void paint( Graphics g )
    	{
    		super.paint(g);

    		Graphics2D g2d = (Graphics2D)g;
    		
    		g2d.setStroke( new BasicStroke(3) );
    		g2d.setPaint( Color.red );
    		
    		final Dimension dim = this.getSize();
    		Rectangle rect = new Rectangle( 0, 0, dim.width, dim.height );
    		g2d.draw(rect);
    	}
   	
    }
*/    
    

	
}

