
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Toolkit;

import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;

import org.freehep.util.export.ExportDialog;


/**
 * A class used to preview, print and export an image.
 */
public class SGImageExportManager implements SGIImageExportManager
{

	/**
	 * An export dialog.
	 */
	private ExportDialog mExportDialog = new ExportDialog();


	/**
	 * A Color object set to the background of the preview dialog.
	 */
	private Color mBackgroundColor = Color.WHITE;


	/**
	 * Default constructor.
	 *
	 */
	public SGImageExportManager()
	{
	}


	/**
	 * Export as image the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
	public boolean export(
		Component target, Frame owner, final int w, final int h )
	{
		// create and show a nonmodal preview dialog
		SGPreviewDialog dg = this.createPreviewDialog( target, owner, w, h, false );
		dg.setVisible(true);

		// show the modal export dialog
		this.mExportDialog.showExportDialog
		(
			owner,
			"Export view as ...",
			target,
			"export"
		);

		// hide the preview dialog
		dg.setVisible(false);

		return true;
	}



	/**
	 * Preview image of the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
	public boolean preview(
		Component target, Frame owner, final int w, final int h )
	{
		// create and show a modal preview dialog
		SGPreviewDialog dg = this.createPreviewDialog( target, owner, w, h, true );
		dg.setVisible(true);

		return true;
	}



	/**
	 * Print image of the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
	public boolean print( Component target, Frame owner, int w, int h )
	{
		// preview the target object
		this.preview( target, owner, w, h );

		// get a PrintJob object
		PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob( owner, "Print Image", null);
		if ( pj!=null )
		{
			Graphics g = pj.getGraphics();

			// print
			target.printAll(g);

			g.dispose();
			pj.end();
		}

		return true;
	}



	/**
	 * Create a preview dilaog.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @param modal - whether the preview dialog is modal
	 * @return true:succeeded, false:failed
	 */
	private SGPreviewDialog createPreviewDialog(
		Component target, Frame owner,
		final int w, final int h, final boolean modal )
	{
		SGPreviewDialog dg = new SGPreviewDialog( owner, "Preview", modal );
		dg.pack();

		Insets in = dg.getInsets();
		final int width = w + in.left + in.right;
		final int height = h + in.top + in.bottom;
		dg.setSize( width, height );
		dg.setLocation( owner.getLocation() );
		dg.getContentPane().add( target );

		dg.setBackgroundColor( this.mBackgroundColor );

		return dg;		
	}


	/**
	 * @return
	 */
	public Color getBackgroundColor()
	{
		return mBackgroundColor;
	}

	/**
	 * @param color
	 */
	public void setBackgroundColor( Color color )
	{
		mBackgroundColor = color;
	}

}

