/*
 * SGAboutDialog.java
 *
 * Created on 2004/09/14, 11:04
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;

import javax.swing.JDialog;

import jp.riken.brain.ni.samuraigraph.base.SGBrowserLauncher;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

/**
 *
 * @author  kuromaru
 */
public class SGAboutDialog extends JDialog
	implements ActionListener, ComponentListener
//	implements ActionListener, HyperlinkListener, ComponentListener
{

   	/**
	 * 
	 *
	 */
	public SGAboutDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


	/**
	 * 
	 * @param owner
	 * @param modal
	 */
	public SGAboutDialog( Frame owner, boolean modal )
	{
		super( owner, modal );
		initComponents();
		this.initProperty();
	}


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mLayeredPanel = new javax.swing.JLayeredPane();
        mImagePanel = new jp.riken.brain.ni.samuraigraph.base.SGImagePanel();
        mVersionLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 10);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mLayeredPanel.setPreferredSize(new java.awt.Dimension(400, 300));
        mImagePanel.setPreferredSize(new java.awt.Dimension(400, 300));
        mImagePanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mImagePanelMouseClicked(evt);
            }
        });
        mImagePanel.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                mImagePanelMouseMoved(evt);
            }
        });

        mImagePanel.setBounds(0, 0, 400, 300);
        mLayeredPanel.add(mImagePanel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        mVersionLabel.setFont(new java.awt.Font("Serif", 1, 14));
        mVersionLabel.setText(" ");
        mVersionLabel.setBounds(0, 0, 90, 20);
        mLayeredPanel.add(mVersionLabel, javax.swing.JLayeredPane.DEFAULT_LAYER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        getContentPane().add(mLayeredPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mImagePanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mImagePanelMouseClicked
        // ɏR[hǉ:
        final int x = evt.getX();
        final int y = evt.getY();
        if ( web_rect.contains(x, y) ) {
            try {
                SGBrowserLauncher.openURL( SAMURAI_GRAPH_URL );
            }
            catch( IOException ex )
            {
                ex.printStackTrace();
            }
        } else if ( lab_rect.contains(x, y) ) {
            try {
                SGBrowserLauncher.openURL( NEUROINFORMATICS_LAB_URL );
            }
            catch( IOException ex )
            {
                ex.printStackTrace();
            }
        }

    }//GEN-LAST:event_mImagePanelMouseClicked

    private void mImagePanelMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mImagePanelMouseMoved
        // ɏR[hǉ:
        final int x = evt.getX();
        final int y = evt.getY();
       if ( web_rect.contains(x, y) ) {
            setLinkCursorForm(true);
        } else if ( lab_rect.contains(x, y) ) {
            setLinkCursorForm(true);
        } else {
            setLinkCursorForm(false);
        }
    }//GEN-LAST:event_mImagePanelMouseMoved
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGImagePanel mImagePanel;
    private javax.swing.JLayeredPane mLayeredPanel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JLabel mVersionLabel;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * Title of this dialog.
	 */
	public static final String TITLE = "About Samurai Graph";
        
    /**
     * Background Image of the About Dialog
     */
    public static final String ABOUT_IMAGE_FILE = "About.png";
    
    /**
     * About Dialog ̃Ntqkւ̗̈
     * web_rect : http://samurai-graph.sourceforge.jp/
     * lab_rect : Neuroinformatics Laboratory
     */
    private static final Rectangle web_rect = new Rectangle(157, 200, 216, 14);
    private static final Rectangle lab_rect = new Rectangle(216, 230, 166, 14);

    
    /**
     * URLS
     */
    private static String SAMURAI_GRAPH_URL = "http:/"+"/samurai-graph.sourceforge.jp/";
    private static String NEUROINFORMATICS_LAB_URL = "http:/"+"/www.ni.brain.riken.jp/";
    
    private static final int verpos_r = 375;  // right position of the version label
    private static final int verpos_t = 125;  // top position of the version label
    private static final int verpos_b = 155;  // bottom position of the version label
       
    /**
     * J[\`󂪃Ň`ǐ`jǂH
     */
    private boolean is_linkcursor = false;


	/**
	 * true ƃJ[\`Ň`ǐ`jɕς܂D
	 */
        private void setLinkCursorForm(boolean m)
        {
            if(is_linkcursor == false && m == true){
                final Cursor cur = new Cursor(Cursor.HAND_CURSOR);
                setCursor(cur);
               is_linkcursor = true;
            }else if(is_linkcursor == true && m == false){
                final Cursor cur = Cursor.getDefaultCursor();
                setCursor(cur);            
                is_linkcursor = false;
            }
        }
    
	/**
	 * 
	 */
	private boolean initProperty()
	{
		this.setTitle(TITLE);
		this.setVisible(false);
		this.setResizable(false);

		//
		this.mOKButton.addActionListener(this);

		//
		this.addComponentListener(this);
                
		// set the image
		Class inClass = getClass();
		String name = null;
		URL url = null;

		name = SGIConstants.RESOURCES_DIRNAME + ABOUT_IMAGE_FILE;
		url = inClass.getResource(name);
		Image image = Toolkit.getDefaultToolkit().getImage( url );
		this.mImagePanel.setImage( image );

		// set text and potision of the version number label .
		final String vertext = "Version "
			+ SGDrawingServer.MAJOR_VERSION_NUMBER + "."
			+ SGDrawingServer.MINOR_VERSION_NUMBER + "."
			+ SGDrawingServer.MICRO_VERSION_NUMBER;
		this.mVersionLabel.setText(vertext);

		final Font font = mVersionLabel.getFont();
		final Rectangle2D verrect = font.getStringBounds(
		    vertext, new FontRenderContext(null, false, false));
		final int vh = (int)verrect.getHeight();
		final int vw = (int)verrect.getWidth();
		final int h = (verpos_b - verpos_t - vh) / 2 + verpos_t;
		final int w = verpos_r - vw;
		this.mVersionLabel.setSize(vw, vh);
		this.mVersionLabel.setBounds(w, h, vw, vh);

        // set the layer superposition
        this.mLayeredPanel.setLayer(this.mImagePanel,1);
		this.mLayeredPanel.setLayer(this.mVersionLabel,2);

		this.pack();

		return true;

	}



	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		Object source = e.getSource();
		if( source.equals( this.mOKButton ) )
		{
			this.setVisible(false);
		}
	}



	/**
	 * R|[lgɂȂƌĂяo܂B 
	 */
	public void componentShown(final ComponentEvent e)
	{
	}


	/**
	 * R|[lgsɂȂƌĂяo܂B 
	 */
	public void componentHidden(final ComponentEvent e)
	{
	}


	/**
	 * R|[lg̈ʒuςƌĂяo܂B 
	 */
	public void componentMoved(final ComponentEvent e)
	{
		Object owner = this.getOwner();
		if( owner instanceof Window )
		{
			Window wnd = (Window)owner;
			wnd.repaint();
		}
	}


	/**
	 * R|[lg̃TCYςƌĂяo܂B 
	 */
	public void componentResized(final ComponentEvent e)
	{
	}



	/**
	 * 
	 *
	 */
	public void terminate()
	{

		ActionListener[] aListener = this.mOKButton.getActionListeners();
		for( int ii=0; ii<aListener.length; ii++ )
		{
			this.mOKButton.removeActionListener( aListener[ii] );
		}
		
		ComponentListener[] cListener = this.getComponentListeners();
		for( int ii=0; ii<cListener.length; ii++ )
		{
			this.removeComponentListener( cListener[ii] );
		}
		
		MouseListener[] mListener = this.mImagePanel.getMouseListeners();
		for( int ii=0; ii<mListener.length; ii++ )
		{
			this.removeMouseListener( mListener[ii] );
		}

		MouseMotionListener[] mmListener = this.mImagePanel.getMouseMotionListeners();
		for( int ii=0; ii<mmListener.length; ii++ )
		{
			this.removeMouseMotionListener( mmListener[ii] );
		}
		
		this.removeAll();

	}



	/**
	 * Finalize method.
	 */
	public void finalize()
	{
//		System.out.println(this);
	}

}
