/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureElementConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGFigureElement
extends JPanel
implements SGIFigureElement,
SGIFigureElementConstants {
    protected float mGraphRectX;
    protected float mGraphRectY;
    protected float mGraphRectWidth;
    protected float mGraphRectHeight;
    protected float mMagnification = 1.0f;
    protected Rectangle2D mViewBounds = null;
    protected ArrayList mDataList = new ArrayList();
    protected final ArrayList mActionListenerList = new ArrayList();
    private Cursor mCursor = null;
    protected Frame mDialogOwner = null;
    protected int mFigureElementStateCounter = 0;
    protected ArrayList mPropertyHistoryList = new ArrayList();
    protected int mCurrentStateCounter = 0;
    protected ArrayList mUndoableObjectHistoryList = new ArrayList();
    protected boolean mChangedFlag = false;
    protected boolean mSymbolsVisibleFlagAroundFocusedObjects = true;
    protected boolean mSymbolsVisibleFlagAroundAllObjects = false;
    public static final int OFFSET_DUPLICATED_OBJECT_X = 10;
    public static final int OFFSET_DUPLICATED_OBJECT_Y = 10;

    public boolean addData(SGData sGData, String string) {
        this.mDataList.add(sGData);
        return true;
    }

    public boolean removeData(SGData sGData) {
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            return true;
        }
        return true;
    }

    public ArrayList getDataList() {
        return this.mDataList;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (sGTuple2f == null || sGTuple2f2 == null) {
            return false;
        }
        sGTuple2f.clear();
        sGTuple2f2.clear();
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocation(f, f2);
        this.setGraphRectSize(f3, f4);
        return true;
    }

    public boolean setGraphRect(Rectangle2D rectangle2D) {
        return this.setGraphRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public boolean setGraphRectLocation(float f, float f2) {
        this.mGraphRectX = f;
        this.mGraphRectY = f2;
        return true;
    }

    public boolean setGraphRectSize(float f, float f2) {
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            throw new IllegalArgumentException("width<0.0 || height<0.0");
        }
        this.mGraphRectWidth = f;
        this.mGraphRectHeight = f2;
        return true;
    }

    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public boolean isInsideGraphArea(SGTuple2f sGTuple2f) {
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = this.mGraphRectX;
        float f4 = this.mGraphRectY;
        float f5 = this.mGraphRectWidth;
        float f6 = this.mGraphRectHeight;
        if (f < f3 || f > f3 + f5) {
            return false;
        }
        return !(f2 < f4) && !(f2 > f4 + f6);
    }

    public boolean isInsideGraphArea(Point2D point2D) {
        return this.isInsideGraphArea((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean isInsideGraphArea(int n, int n2) {
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        return this.isInsideGraphArea(sGTuple2f);
    }

    public SGTuple2f getISize() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        sGTuple2f.x = this.getWidth();
        sGTuple2f.y = this.getHeight();
        return sGTuple2f;
    }

    public SGTuple2f getILocation() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        sGTuple2f.x = this.getX();
        sGTuple2f.y = this.getY();
        return sGTuple2f;
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        this.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        return true;
    }

    public boolean setILocation(SGTuple2f sGTuple2f) {
        this.setLocation((int)sGTuple2f.x, (int)sGTuple2f.y);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        this.mDialogOwner = frame;
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public Cursor getFigureElementCursor() {
        return this.mCursor;
    }

    protected void setMouseCursor(int n) {
        this.mCursor = Cursor.getPredefinedCursor(n);
        this.notifyChangeCursor();
    }

    protected void setMouseCursor(Cursor cursor) {
        this.mCursor = cursor;
        this.notifyChangeCursor();
    }

    public void notifyChangeCursor() {
        this.notifyToListener("Notify the change of cursor");
    }

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public abstract boolean synchronize(SGIFigureElement var1);

    public abstract boolean synchronizeArgument(SGIFigureElement var1);

    public boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        return true;
    }

    public Rectangle2D getViewBounds() {
        return this.mViewBounds;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (element == null || sGData == null) {
            throw new IllegalArgumentException();
        }
        this.mDataList.add(sGData);
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    protected boolean updateFocusedObjectsList(SGISelectable sGISelectable, int n) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if ((n & 2) == 0 & (n & 1) == 0) {
            if (!arrayList.contains(sGISelectable)) {
                this.notifyToListener("Clear focused objects");
                sGISelectable.setSelected(true);
            }
        } else {
            sGISelectable.setSelected(!sGISelectable.isSelected());
        }
        return true;
    }

    protected boolean updateFocusedObjectsList(SGISelectable sGISelectable, MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return this.updateFocusedObjectsList(sGISelectable, n);
    }

    public abstract boolean getFocusedObjectsList(ArrayList var1);

    public void translateSelectedObjects(int n, int n2) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGIMovable)) continue;
            SGIMovable sGIMovable = (SGIMovable)e;
            sGIMovable.translate(n, n2);
        }
    }

    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyChange() {
        this.notifyToListener("Notify the change");
    }

    public boolean setPropertyOfSelectedData() {
        this.notifyToListener("Set properties of selected data");
        return true;
    }

    public void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public float getGraphRectX() {
        return this.mGraphRectX;
    }

    public float getGraphRectY() {
        return this.mGraphRectY;
    }

    public float getGraphRectWidth() {
        return this.mGraphRectWidth;
    }

    public float getGraphRectHeight() {
        return this.mGraphRectHeight;
    }

    protected float calcLocation(double d, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = sGTuple2d.x;
        double d3 = sGTuple2d.y;
        int n = sGAxis.getScaleType();
        float f = 0.0f;
        if (n == 0) {
            f = (float)((d - d2) / (d3 - d2));
        } else if (n == 1) {
            double d4 = Math.log(d2);
            double d5 = Math.log(d3);
            double d6 = Math.log(d);
            f = (float)((d6 - d4) / (d5 - d4));
        }
        float f2 = 0.0f;
        f2 = bl ? this.mGraphRectX + f * this.mGraphRectWidth : this.mGraphRectY + (1.0f - f) * this.mGraphRectHeight;
        return f2;
    }

    protected double calcValue(float f, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        int n = sGAxis.getScaleType();
        float f2 = bl ? (f - this.mGraphRectX) / this.mGraphRectWidth : 1.0f - (f - this.mGraphRectY) / this.mGraphRectHeight;
        double d3 = 0.0;
        if (n == 0) {
            d3 = d + (double)f2 * (d2 - d);
        } else if (n == 1) {
            double d4 = Math.log(d);
            double d5 = Math.log(d2);
            d3 = Math.exp(d4 + (double)f2 * (d5 - d4));
        }
        return d3;
    }

    protected boolean showPopupMenu(JPopupMenu jPopupMenu, int n, int n2) {
        jPopupMenu.show(this, n, n2);
        return true;
    }

    public abstract SGProperties getProperties();

    public abstract boolean setProperties(SGProperties var1);

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mFigureElementStateCounter; ++i) {
            arrayList.add(this.mPropertyHistoryList.get(i));
        }
        arrayList.add(sGProperties);
        this.mPropertyHistoryList = arrayList;
        return true;
    }

    public boolean initPropertiesHistory() {
        this.addPropertiesHistory(this.getProperties());
        return true;
    }

    public boolean updateHistory() {
        if (this.isChanged()) {
            this.updateThisObjectHistory();
            this.updateObjectHistory(this);
            this.setChanged(false);
        }
        return true;
    }

    protected boolean updateHistory_(ArrayList arrayList) {
        ArrayList<SGIUndoable> arrayList2 = new ArrayList<SGIUndoable>();
        if (this.mChangedFlag) {
            this.updateThisObjectHistory();
            arrayList2.add(this);
            this.setChanged(false);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            sGIUndoable.updateHistory();
            arrayList2.add(sGIUndoable);
        }
        if (arrayList2.size() != 0) {
            this.updateObjectHistory(arrayList2);
        }
        return true;
    }

    public boolean updateThisObjectHistory() {
        ++this.mFigureElementStateCounter;
        this.addPropertiesHistory(this.getProperties());
        return true;
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean undo() {
        --this.mFigureElementStateCounter;
        SGProperties sGProperties = (SGProperties)this.mPropertyHistoryList.get(this.mFigureElementStateCounter);
        return this.setProperties(sGProperties);
    }

    public boolean redo() {
        ++this.mFigureElementStateCounter;
        SGProperties sGProperties = (SGProperties)this.mPropertyHistoryList.get(this.mFigureElementStateCounter);
        return this.setProperties(sGProperties);
    }

    public void notifyToRoot() {
        this.notifyToListener("Notify the change to root");
    }

    protected void notifyToRootFromFigureElement() {
        this.notifyToRoot();
    }

    public boolean isChanged() {
        return this.mChangedFlag;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    protected boolean setVisibleDrawingElement(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        ArrayList<SGDrawingElement> arrayList3 = new ArrayList<SGDrawingElement>();
        for (n = 0; n < arrayList.size(); ++n) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(n);
            boolean bl = arrayList2.contains(sGDrawingElement);
            sGDrawingElement.setVisible(bl);
            if (bl) continue;
            arrayList3.add(sGDrawingElement);
        }
        arrayList.clear();
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(arrayList2.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            arrayList.add(arrayList3.get(n));
        }
        return true;
    }

    protected void setParentChanged(boolean bl) {
        this.setChanged(bl);
    }

    protected boolean moveObjectToFront(Object object, ArrayList arrayList) {
        return this.moveObject(object, arrayList, arrayList.size() - 1);
    }

    protected boolean moveObjectToBack(Object object, ArrayList arrayList) {
        return this.moveObject(object, arrayList, 0);
    }

    private boolean moveObject(Object object, ArrayList arrayList, int n) {
        if (!arrayList.contains(object)) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!object.equals(arrayList.get(i))) continue;
            arrayList.remove(i);
            break;
        }
        arrayList.add(n, object);
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    protected boolean hideObject(SGDrawingElement sGDrawingElement) {
        sGDrawingElement.setVisible(false);
        this.notifyChange();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public abstract boolean hideSelectedObject(SGISelectable var1);

    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            if (this.hideSelectedObject(sGISelectable)) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.notifyChange();
        }
        return true;
    }

    public abstract String getTagName();

    public abstract boolean writeProperty(Element var1);

    protected Element createThisElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public void setSymbolsVisibleAroundFocusedObjects(boolean bl) {
        this.mSymbolsVisibleFlagAroundFocusedObjects = bl;
    }

    public void setSymbolsVisibleAroundAllObjects(boolean bl) {
        this.mSymbolsVisibleFlagAroundAllObjects = bl;
    }

    protected double getNumberInRangeOrder(double d, SGAxis sGAxis) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = SGUtilityNumber.getNumberInRangeOrder(d, sGTuple2d, 4);
        return d2;
    }

    protected ArrayList getCopyList(ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGICopiable sGICopiable = (SGICopiable)arrayList.get(i);
            arrayList2.add(sGICopiable.copy());
        }
        return arrayList2;
    }

    public ArrayList getFocusedObjectsList() {
        ArrayList arrayList = new ArrayList();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    protected ArrayList getCopiableFocusedObjectsList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e instanceof SGICopiable) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public boolean duplicateFocusedObjects() {
        return true;
    }

    protected ArrayList duplicateObjects() {
        ArrayList arrayList = this.getCopiableFocusedObjectsList();
        ArrayList arrayList2 = this.getCopyList(arrayList);
        this.clearFocusedObjects();
        return arrayList2;
    }

    public ArrayList getCopiedObjectsList() {
        ArrayList arrayList = this.getCopiableFocusedObjectsList();
        return this.getCopyList(arrayList);
    }

    public boolean paste(ArrayList arrayList) {
        return true;
    }

    public ArrayList cutFocusedObjects() {
        ArrayList arrayList = this.getCopiedObjectsList();
        this.hideSelectedObjects();
        return arrayList;
    }

    public SGProperties getDataProperties(SGData sGData) {
        return null;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        return this.addData(sGData, string);
    }

    public boolean moveFocusedObjects(boolean bl) {
        return true;
    }
}

