/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;

public abstract class SGDrawingElementLine
extends SGDrawingElement
implements SGILineConstants,
SGIDrawingElementConstants {
    protected SGTuple2f mStartPoint = new SGTuple2f();
    protected SGTuple2f mEndPoint = new SGTuple2f();
    protected int mLineType = 1;
    protected float mLineWidth = 0.0f;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;

    public SGDrawingElementLine() {
    }

    public SGDrawingElementLine(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.setTermPoints(sGTuple2f, sGTuple2f2);
    }

    public SGDrawingElementLine(float f, float f2, float f3, float f4) {
        this.setTermPoints(f, f2, f3, f4);
    }

    public SGDrawingElementLine(SGDrawingElementLine sGDrawingElementLine) {
        this(new SGTuple2f(sGDrawingElementLine.getStart()), new SGTuple2f(sGDrawingElementLine.getEnd()));
        this.mLineWidth = sGDrawingElementLine.getLineWidth();
        this.mLineType = sGDrawingElementLine.getLineType();
    }

    public boolean setType(int n) {
        this.mLineType = n;
        return true;
    }

    public boolean setTermPoints(float f, float f2, float f3, float f4) {
        return this.setTermPoints(new SGTuple2f(f, f2), new SGTuple2f(f3, f4));
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mStartPoint = sGTuple2f;
        this.mEndPoint = sGTuple2f2;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        return true;
    }

    public SGTuple2f getStart() {
        return this.mStartPoint;
    }

    public SGTuple2f getEnd() {
        return this.mEndPoint;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public static Integer getLineTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals("Solid")) {
            n = 1;
        } else if (string.equals("Broken")) {
            n = 2;
        } else if (string.equals("Dotted")) {
            n = 3;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getLineTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Solid";
                break;
            }
            case 2: {
                string = "Broken";
                break;
            }
            case 3: {
                string = "Dotted";
                break;
            }
        }
        return string;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElement;
        this.setLineType(sGDrawingElementLine.getLineType());
        this.setLineWidth(sGDrawingElementLine.getLineWidth());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        return true;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        this.getProperties(lineProperties);
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        return true;
    }

    public static class LineProperties
    extends SGDrawingElement.DrawingElementProperties {
        public static final String[] keys = new String[]{"Width", "Type"};

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(lineProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getLineWidth() {
            String string = this.getProperty("Width");
            return SGUtilityText.getFloat(string);
        }

        public Integer getLineType() {
            String string = this.getProperty("Type");
            return SGUtilityText.getInteger(string);
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("Width", new Float(f).toString());
            return true;
        }

        public boolean setLineType(int n) {
            this.setProperty("Type", new Integer(n).toString());
            return true;
        }
    }
}

