/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Toolkit;
import jp.riken.brain.ni.samuraigraph.application.SGPreviewDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import org.freehep.util.export.ExportDialog;

public class SGImageExportManager
implements SGIImageExportManager {
    private ExportDialog mExportDialog = new ExportDialog();
    private Color mBackgroundColor = Color.WHITE;

    public boolean export(Component component, Frame frame, int n, int n2) {
        SGPreviewDialog sGPreviewDialog = this.createPreviewDialog(component, frame, n, n2, false);
        sGPreviewDialog.setVisible(true);
        this.mExportDialog.showExportDialog(frame, "Export view as ...", component, "export");
        sGPreviewDialog.setVisible(false);
        return true;
    }

    public boolean preview(Component component, Frame frame, int n, int n2) {
        SGPreviewDialog sGPreviewDialog = this.createPreviewDialog(component, frame, n, n2, true);
        sGPreviewDialog.setVisible(true);
        return true;
    }

    public boolean print(Component component, Frame frame, int n, int n2) {
        this.preview(component, frame, n, n2);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, "Print Image", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            component.printAll(graphics);
            graphics.dispose();
            printJob.end();
        }
        return true;
    }

    private SGPreviewDialog createPreviewDialog(Component component, Frame frame, int n, int n2, boolean bl) {
        SGPreviewDialog sGPreviewDialog = new SGPreviewDialog(frame, "Preview", bl);
        sGPreviewDialog.pack();
        Insets insets = sGPreviewDialog.getInsets();
        int n3 = n + insets.left + insets.right;
        int n4 = n2 + insets.top + insets.bottom;
        sGPreviewDialog.setSize(n3, n4);
        sGPreviewDialog.setLocation(frame.getLocation());
        sGPreviewDialog.getContentPane().add(component);
        sGPreviewDialog.setBackgroundColor(this.mBackgroundColor);
        return sGPreviewDialog;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
    }
}

