/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupArrow
extends SGElementGroupVXY
implements SGIArrowConstants,
SGIElementGroupConstants {
    protected int mLineType;
    protected float mLineWidth;
    protected float mHeadSize;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;
    protected float mHeadEdgeLineWidth;
    protected Color mHeadEdgeLineColor;
    protected int mStartHeadType;
    protected int mEndHeadType;

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public float getHeadEdgeLineWidth() {
        return this.mHeadEdgeLineWidth;
    }

    public Color getHeadEdgeLineColor() {
        return this.mHeadEdgeLineColor;
    }

    public int getStartHeadType() {
        return this.mStartHeadType;
    }

    public int getEndHeadType() {
        return this.mEndHeadType;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setLineType(this.mLineType);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
            }
        }
        return true;
    }

    public boolean setHeadSize(float f) {
        this.mHeadSize = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadSize(this.mHeadSize);
            }
        }
        return true;
    }

    public boolean setHeadOpenAngle(float f) {
        this.mHeadOpenAngle = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
            }
        }
        return true;
    }

    public boolean setHeadCloseAngle(float f) {
        this.mHeadCloseAngle = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
            }
        }
        return true;
    }

    public boolean setHeadEdgeLineWidth(float f) {
        this.mHeadEdgeLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadEdgeLineWidth(f);
            }
        }
        return true;
    }

    public boolean setHeadEdgeLineColor(Color color) {
        this.mHeadEdgeLineColor = color;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
            }
        }
        return true;
    }

    public boolean setStartHeadType(int n) {
        this.mStartHeadType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setStartHeadType(n);
            }
        }
        return true;
    }

    public boolean setEndHeadType(int n) {
        this.mEndHeadType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setEndHeadType(n);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementArrow2D sGDrawingElementArrow2D = new SGDrawingElementArrow2D();
        sGDrawingElementArrow2D.setVisible(this.mVisibleFlag);
        sGDrawingElementArrow2D.setLineType(this.mLineType);
        sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
        sGDrawingElementArrow2D.setColorList(this.mColorList);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadSize(this.mHeadSize);
        sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
        sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadEdgeLineWidth(this.mHeadEdgeLineWidth);
        ((SGDrawingElementArrow)sGDrawingElementArrow2D).setHeadEdgeLineColor(this.mHeadEdgeLineColor);
        sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
        sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
        return sGDrawingElementArrow2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementArrow)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElement;
        this.mLineType = sGDrawingElementArrow.getLineType();
        this.mLineWidth = sGDrawingElementArrow.getLineWidth();
        this.mHeadSize = sGDrawingElementArrow.getHeadSize();
        this.mHeadOpenAngle = sGDrawingElementArrow.getHeadOpenAngle();
        this.mHeadCloseAngle = sGDrawingElementArrow.getHeadCloseAngle();
        this.mHeadEdgeLineWidth = sGDrawingElementArrow.getHeadEdgeLineWidth();
        this.mHeadEdgeLineColor = sGDrawingElementArrow.getHeadEdgeLineColor();
        this.mStartHeadType = sGDrawingElementArrow.getStartHeadType();
        this.mEndHeadType = sGDrawingElementArrow.getEndHeadType();
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        Object object;
        if (this.mDrawingElementArray == null) {
            return true;
        }
        float f = this.mMagnification * this.mLineWidth;
        switch (this.mLineType) {
            case 1: {
                graphics2D.setStroke(new BasicStroke(f, 0, 0));
                break;
            }
            case 2: {
                float[] fArray = new float[]{2.0f * f, f};
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f));
                break;
            }
            case 3: {
                float[] fArray = new float[]{f};
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f));
                break;
            }
            default: {
                throw new Error();
            }
        }
        graphics2D.setPaint(this.getColor(0));
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
            object = sGDrawingElementArrow2D.getBodyShape();
            graphics2D.draw((Shape)object);
        }
        float f2 = this.mMagnification * this.mHeadEdgeLineWidth;
        graphics2D.setStroke(new BasicStroke(f2));
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            Shape shape;
            object = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
            Shape shape2 = ((SGDrawingElementArrow2D)object).getStartHeadShape();
            if (shape2 != null) {
                graphics2D.setPaint(this.mHeadEdgeLineColor);
                graphics2D.draw(shape2);
                graphics2D.setPaint(this.getColor(0));
                graphics2D.fill(shape2);
            }
            if ((shape = ((SGDrawingElementArrow2D)object).getEndHeadShape()) == null) continue;
            graphics2D.setPaint(this.mHeadEdgeLineColor);
            graphics2D.draw(shape);
            graphics2D.setPaint(this.getColor(0));
            graphics2D.fill(shape);
        }
        return true;
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Circle";
                break;
            }
            case 1: {
                string = "Square";
                break;
            }
            case 2: {
                string = "Triangle";
                break;
            }
            case 4: {
                string = "Cross";
                break;
            }
            case 6: {
                string = "Transverse Line";
                break;
            }
            case 10: {
                string = "Arrow head";
                break;
            }
            case -1: {
                string = "No symbol";
                break;
            }
        }
        return string;
    }

    public String getTagName() {
        return "Arrow";
    }

    public boolean writeProperty(Element element) {
        String string = "cm";
        String string2 = "pt";
        String string3 = SGIConstants.degree;
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + string2);
        element.setAttribute("LineType", Integer.toString(this.mLineType));
        element.setAttribute("HeadSize", Float.toString(this.mHeadSize * 0.035277776f) + string);
        element.setAttribute("StartHeadType", Integer.toString(this.mStartHeadType));
        element.setAttribute("EndHeadType", Integer.toString(this.mEndHeadType));
        element.setAttribute("HeadLineWidth", Float.toString(this.mHeadEdgeLineWidth) + string2);
        element.setAttribute("HeadLineColor", SGUtilityText.getColorString(this.mHeadEdgeLineColor));
        element.setAttribute("HeadOpenAngle", Double.toString(this.mHeadOpenAngle) + string3);
        element.setAttribute("HeadCloseAngle", Double.toString(this.mHeadCloseAngle) + string3);
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public SGProperties readProperties(Element element) {
        return null;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementArrow2D[] sGDrawingElementArrow2DArray = new SGDrawingElementArrow2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementArrow2DArray[i] = new SGDrawingElementArrow2D();
        }
        this.mDrawingElementArray = sGDrawingElementArrow2DArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("startArray.length != this.mDrawingElementArray.length");
        }
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN() && !sGTuple2fArray2[i].isInfinite() && !sGTuple2fArray2[i].isNaN();
            sGDrawingElementArrow2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementArrow2D.setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
            sGDrawingElementArrow2D.setMagnification(this.mMagnification);
            sGDrawingElementArrow2D.setColorList(this.mColorList);
            sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
            sGDrawingElementArrow2D.setLineType(this.mLineType);
            sGDrawingElementArrow2D.setHeadSize(this.mHeadSize);
            sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
            sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
            sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
            sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
        }
        return true;
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        this.getProperties(arrowProperties);
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setHeadLineWidth(this.getHeadEdgeLineWidth());
        arrowProperties.setHeadLineColor(this.getHeadEdgeLineColor());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Float f3 = arrowProperties.getHeadLineWidth();
        if (f3 == null) {
            return false;
        }
        this.setHeadEdgeLineWidth(f3.floatValue());
        Color color = arrowProperties.getHeadLineColor();
        if (color == null) {
            return false;
        }
        this.setHeadEdgeLineColor(color);
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        Float f4 = arrowProperties.getHeadOpenAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadOpenAngle(f4.floatValue());
        Float f5 = arrowProperties.getHeadCloseAngle();
        if (f5 == null) {
            return false;
        }
        this.setHeadCloseAngle(f5.floatValue());
        return true;
    }

    public static class ArrowProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"LineWidth", "LineType", "HeadSize", "StartHeadType", "EndHeadType", "HeadLineWidth", "HeadLineColor", "HeadOpenAngle", "HeadCloseAngle"};

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(arrowProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getLineWidth() {
            String string = this.getProperty("LineWidth");
            return SGUtilityText.getFloat(string);
        }

        public Integer getLineType() {
            String string = this.getProperty("LineType");
            return SGUtilityText.getInteger(string);
        }

        public Float getHeadLineWidth() {
            String string = this.getProperty("HeadLineWidth");
            return SGUtilityText.getFloat(string);
        }

        public Float getHeadSize() {
            String string = this.getProperty("HeadSize");
            return SGUtilityText.getFloat(string);
        }

        public Color getHeadLineColor() {
            String string = this.getProperty("HeadLineColor");
            return SGUtilityText.getColorFromString(string);
        }

        public Integer getStartHeadType() {
            String string = this.getProperty("StartHeadType");
            return SGUtilityText.getInteger(string);
        }

        public Integer getEndHeadType() {
            String string = this.getProperty("EndHeadType");
            return SGUtilityText.getInteger(string);
        }

        public Float getHeadOpenAngle() {
            String string = this.getProperty("HeadOpenAngle");
            return SGUtilityText.getFloat(string);
        }

        public Float getHeadCloseAngle() {
            String string = this.getProperty("HeadCloseAngle");
            return SGUtilityText.getFloat(string);
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("LineWidth", new Float(f).toString());
            return true;
        }

        public boolean setLineType(int n) {
            this.setProperty("LineType", new Integer(n).toString());
            return true;
        }

        public boolean setHeadLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("HeadLineWidth", new Float(f).toString());
            return true;
        }

        public boolean setStartHeadType(int n) {
            this.setProperty("StartHeadType", new Integer(n).toString());
            return true;
        }

        public boolean setEndHeadType(int n) {
            this.setProperty("EndHeadType", new Integer(n).toString());
            return true;
        }

        public boolean setHeadSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("HeadSize", new Float(f).toString());
            return true;
        }

        public boolean setHeadLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty("HeadLineColor", string);
            return true;
        }

        public boolean setHeadOpenAngle(float f) {
            this.setProperty("HeadOpenAngle", new Float(f).toString());
            return true;
        }

        public boolean setHeadCloseAngle(float f) {
            this.setProperty("HeadCloseAngle", new Float(f).toString());
            return true;
        }
    }
}

