/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;

public class SGXYDataTypeSelectionWizardDialog
extends SGWizardDialog {
    public static final String TITLE = "Data Type";
    private JPanel mButtonPanel;
    protected JButton mCancelButton;
    private JRadioButton mMultipleXYRadioButton;
    protected JButton mNextButton;
    protected JButton mOKButton;
    private JPanel mPanel;
    protected JButton mPreviousButton;
    private JTextField mSamplingRateField;
    private JLabel mSamplingUnitLabel;
    private JRadioButton mSamplingXYRadioButton;
    private JRadioButton mScalarXYRadioButton;
    private JRadioButton mVectorXYRadioButton;
    private TreeMap mDataTypeMap = new TreeMap();

    public SGXYDataTypeSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGXYDataTypeSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScalarXYRadioButton = new JRadioButton();
        this.mMultipleXYRadioButton = new JRadioButton();
        this.mSamplingXYRadioButton = new JRadioButton();
        this.mSamplingRateField = new JTextField();
        this.mVectorXYRadioButton = new JRadioButton();
        this.mSamplingUnitLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new TitledBorder(null, "Select the Data Type", 0, 0, new Font("Dialog", 1, 12)));
        this.mScalarXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mScalarXYRadioButton.setText("Scalar-XY");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.mPanel.add((Component)this.mScalarXYRadioButton, gridBagConstraints);
        this.mMultipleXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mMultipleXYRadioButton.setText("Multiple-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mPanel.add((Component)this.mMultipleXYRadioButton, gridBagConstraints);
        this.mSamplingXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mSamplingXYRadioButton.setText("Sampling-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.mPanel.add((Component)this.mSamplingXYRadioButton, gridBagConstraints);
        this.mSamplingRateField.setColumns(3);
        this.mSamplingRateField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.mPanel.add((Component)this.mSamplingRateField, gridBagConstraints);
        this.mVectorXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mVectorXYRadioButton.setText("Vector-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mPanel.add((Component)this.mVectorXYRadioButton, gridBagConstraints);
        this.mSamplingUnitLabel.setFont(new Font("Dialog", 0, 12));
        this.mSamplingUnitLabel.setText("Hz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        this.mPanel.add((Component)this.mSamplingUnitLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mScalarXYRadioButton);
        buttonGroup.add(this.mVectorXYRadioButton);
        buttonGroup.add(this.mMultipleXYRadioButton);
        buttonGroup.add(this.mSamplingXYRadioButton);
        this.mScalarXYRadioButton.setSelected(true);
        this.mSamplingRateField.setEnabled(false);
        this.mSamplingRateField.setText(Double.toString(1.0));
        this.mScalarXYRadioButton.addActionListener(this);
        this.mVectorXYRadioButton.addActionListener(this);
        this.mMultipleXYRadioButton.addActionListener(this);
        this.mSamplingXYRadioButton.addActionListener(this);
        this.mDataTypeMap.put("SXY", this.mScalarXYRadioButton);
        this.mDataTypeMap.put("VXY", this.mVectorXYRadioButton);
        this.mDataTypeMap.put("SXY_MULTIPLE", this.mMultipleXYRadioButton);
        this.mDataTypeMap.put("SXY_SAMPLING", this.mSamplingXYRadioButton);
        this.mVectorXYRadioButton.setVisible(false);
        this.pack();
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
        }
        return true;
    }

    public String getSelectedDataType() {
        String string = null;
        Iterator iterator = this.mDataTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            JRadioButton jRadioButton = (JRadioButton)this.mDataTypeMap.get(k);
            if (!jRadioButton.isSelected()) continue;
            string = (String)k;
            break;
        }
        return string;
    }

    public boolean setEffectiveDataType(ArrayList arrayList) {
        boolean bl;
        JRadioButton jRadioButton;
        Object k;
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = this.mDataTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            jRadioButton = (JRadioButton)this.mDataTypeMap.get(k);
            bl = arrayList.contains(k);
            if (jRadioButton.isSelected() && !bl) {
                bl2 = true;
            }
            jRadioButton.setEnabled(bl);
        }
        if (bl2 && (iterator = this.mDataTypeMap.keySet().iterator()).hasNext()) {
            k = iterator.next();
            jRadioButton = (JRadioButton)this.mDataTypeMap.get(k);
            bl = arrayList.contains(k);
            jRadioButton.setSelected(bl);
        }
        return true;
    }

    public Double getSamplingRate() {
        String string = this.mSamplingRateField.getText();
        Double d = null;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mSamplingXYRadioButton)) {
            this.mSamplingRateField.setEnabled(true);
        } else if (object instanceof JRadioButton) {
            this.mSamplingRateField.setEnabled(false);
        }
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

