/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;

public class SGStartupFigurePropertySettingDialog
extends SGWizardDialog {
    private JButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JSeparator mColorSeparator;
    private JPanel mFigurePanel;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JLabel mLeftSpaceLabel;
    private JCheckBox mLegendVisibleCheckBox;
    private JLabel mLegendVisibleLabel;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mNextButton;
    private JButton mOKButton;
    private JButton mPreviousButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mSpaceLabel;
    private JLabel mSpaceLineAndScaleLabel;
    private SGSpinner mSpaceLineAndScaleSpinner;
    private JLabel mSpaceScaleAndTitleLabel;
    private SGSpinner mSpaceScaleAndTitleSpinner;
    private JSeparator mSpaceSeparator;
    private JCheckBox mTransparentCheckBox;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JLabel mXLabel;
    private SGSpinner mXSpinner;
    private JLabel mYLabel;
    private SGSpinner mYSpinner;

    public SGStartupFigurePropertySettingDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGStartupFigurePropertySettingDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mFigurePanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mLocationLabel = new JLabel();
        this.mSizeLabel = new JLabel();
        this.mXLabel = new JLabel();
        this.mXSpinner = new SGSpinner();
        this.mYLabel = new JLabel();
        this.mYSpinner = new SGSpinner();
        this.mSpaceLabel = new JLabel();
        this.mSpaceLineAndScaleLabel = new JLabel();
        this.mSpaceScaleAndTitleLabel = new JLabel();
        this.mSpaceLineAndScaleSpinner = new SGSpinner();
        this.mSpaceScaleAndTitleSpinner = new SGSpinner();
        this.mBackgroundColorLabel = new JLabel();
        this.mBackgroundColorButton = new JButton();
        this.mLegendVisibleCheckBox = new JCheckBox();
        this.mLegendVisibleLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mSizeSeparator = new JSeparator();
        this.mSpaceSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mTransparentCheckBox = new JCheckBox();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mFigurePanel.setLayout(new GridBagLayout());
        this.mFigurePanel.setBorder(new EtchedBorder());
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLocationLabel, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mXLabel.setFont(new Font("Dialog", 0, 12));
        this.mXLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mXLabel, gridBagConstraints);
        this.mXSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mXSpinner, gridBagConstraints);
        this.mYLabel.setFont(new Font("Dialog", 0, 12));
        this.mYLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mYLabel, gridBagConstraints);
        this.mYSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mYSpinner, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 3, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceLineAndScaleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleLabel, gridBagConstraints);
        this.mSpaceScaleAndTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleLabel, gridBagConstraints);
        this.mSpaceLineAndScaleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleSpinner, gridBagConstraints);
        this.mSpaceScaleAndTitleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleSpinner, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mLegendVisibleLabel.setFont(new Font("Dialog", 3, 12));
        this.mLegendVisibleLabel.setText("Legend ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLegendVisibleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 60, 0, 0);
        this.mFigurePanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mFigurePanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 48, 0, 0);
        this.mFigurePanel.add((Component)this.mSpaceSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.mFigurePanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mTransparentCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mFigurePanel, gridBagConstraints);
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle("Figure Properties");
        this.mNextButton.setEnabled(false);
        this.mXSpinner.setDigitForRoundingOut(-2);
        this.mXSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 50.0, 1.0), " cm");
        this.mXSpinner.setMinimumFractionDigits(1);
        this.mXSpinner.setMaximumFractionDigits(1);
        this.mYSpinner.setDigitForRoundingOut(-2);
        this.mYSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 50.0, 1.0), " cm");
        this.mYSpinner.setMinimumFractionDigits(1);
        this.mYSpinner.setMaximumFractionDigits(1);
        this.mWidthSpinner.setDigitForRoundingOut(-2);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(10.0, 1.0, 50.0, 1.0), " cm");
        this.mWidthSpinner.setMinimumFractionDigits(1);
        this.mWidthSpinner.setMaximumFractionDigits(1);
        this.mHeightSpinner.setDigitForRoundingOut(-2);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(10.0, 1.0, 50.0, 1.0), " cm");
        this.mHeightSpinner.setMinimumFractionDigits(1);
        this.mHeightSpinner.setMaximumFractionDigits(1);
        this.mSpaceLineAndScaleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.01), " cm");
        this.mSpaceScaleAndTitleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.01), " cm");
        this.mBackgroundColorButton.addActionListener(this);
        this.mTransparentCheckBox.addActionListener(this);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    public Number getFigureX() {
        return this.mXSpinner.getNumber();
    }

    public Number getFigureY() {
        return this.mYSpinner.getNumber();
    }

    public Number getFigureWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getFigureHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Number getSpaceLineAndNumber() {
        return this.mSpaceLineAndScaleSpinner.getNumber();
    }

    public Number getSpaceNumberAndTitle() {
        return this.mSpaceScaleAndTitleSpinner.getNumber();
    }

    public Color getFigureBackgroundColor() {
        return this.mBackgroundColorButton.getBackground();
    }

    public boolean getFigureTransparentFlag() {
        return this.mTransparentCheckBox.isSelected();
    }

    public boolean getFigureLegendVisible() {
        return this.mLegendVisibleCheckBox.isSelected();
    }

    public boolean setFigureX(float f) {
        this.mXSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureY(float f) {
        this.mYSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureWidth(float f) {
        this.mWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureHeight(float f) {
        this.mHeightSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureSpaceLineAndNumber(float f) {
        this.mSpaceLineAndScaleSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureSpaceNumberAndTitle(float f) {
        this.mSpaceScaleAndTitleSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFigureBackgroundColor(Color color) {
        this.mBackgroundColorButton.setBackground(color);
        return true;
    }

    public boolean setFigureTransparentFlag(boolean bl) {
        this.mTransparentCheckBox.setSelected(bl);
        return true;
    }

    public boolean setFigureLegendVisible(boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        return true;
    }
}

