/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGGraphElement
extends SGFigureElement
implements SGIGraphElement {
    protected SGIAxisElement mAxisElement = null;
    protected ArrayList mGroupSetList = new ArrayList();
    protected static SGPropertyDialog mPropertyDialogForData = null;
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    public static final String MENUCMD_MOVE_DATA_TO_FRONT = "Move to Front";
    public static final String MENUCMD_MOVE_DATA_TO_BACK = "Move to Back";
    public static final String MENUCMD_REMOVE_DATA = "Delete";

    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        this.focusedDataChanged();
        return true;
    }

    public int getVisibleDataNumber() {
        return this.getVisibleElementGroupSetList().size();
    }

    public String toString() {
        return new String("SGGraphElement");
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDataDialog();
        return true;
    }

    protected abstract boolean createDataDialog();

    public abstract boolean addData(SGData var1);

    protected abstract boolean setAllDrawingElementsLocation();

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    protected ElementGroupSetInGraph getGraphData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            return elementGroupSetInGraph;
        }
        return null;
    }

    protected SGData getData(ElementGroupSetInGraph elementGroupSetInGraph) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph2 = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph2.equals(elementGroupSetInGraph)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mName;
        }
        return null;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getDrawingElementList();
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
        return arrayList;
    }

    public boolean getVisibleInLegendFlag(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        boolean bl = elementGroupSetInGraph.isVisibleInLegend();
        return bl;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mXAxis;
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mYAxis;
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getGraphData(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mZAxis;
        }
        return null;
    }

    public JPopupMenu getPopupMenu(SGData sGData) {
        return null;
    }

    public JDialog getDialog(SGData sGData) {
        return null;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            elementGroupSetInGraph.zoom(f);
        }
        this.setAllDrawingElementsLocation();
        return true;
    }

    public boolean removeData(SGData sGData) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        this.mDataList.remove(sGData);
        this.mGroupSetList.remove(sGElementGroupSet);
        return true;
    }

    public boolean setDataVisible(SGData sGData, boolean bl) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        sGElementGroupSet.setVisible(bl);
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        return this.setAllDrawingElementsLocation();
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGILegendElement) {
            SGILegendElement sGILegendElement = (SGILegendElement)sGIFigureElement;
            bl = this.synchronizeToLegendElement(sGILegendElement);
        } else if (sGIFigureElement instanceof SGIAxisElement) {
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
            bl = this.synchronizeToAxisElement(sGIAxisElement);
        } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement)) {
            bl = this.synchronizeArgument(sGIFigureElement);
        }
        return bl;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        return this.setAllDrawingElementsLocation();
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        ArrayList arrayList = sGILegendElement.getDataList();
        if (arrayList.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        ArrayList<SGElementGroupSet> arrayList3 = new ArrayList<SGElementGroupSet>();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            SGData sGData = (SGData)arrayList.get(i);
            for (int j = this.mDataList.size() - 1; j >= 0; --j) {
                SGData sGData2 = (SGData)this.mDataList.get(j);
                if (!sGData.equals(sGData2)) continue;
                SGData sGData3 = (SGData)this.mDataList.remove(j);
                arrayList2.add(sGData3);
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.remove(j);
                arrayList3.add(sGElementGroupSet);
                continue block0;
            }
        }
        this.mDataList = arrayList2;
        this.mGroupSetList = arrayList3;
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    protected boolean isInsideAxisRange(SGTuple2d sGTuple2d, SGAxis sGAxis, SGAxis sGAxis2) {
        return sGAxis.insideRange(sGTuple2d.x) && sGAxis2.insideRange(sGTuple2d.y);
    }

    protected boolean calcLocationOfSXYData(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray) {
        int n;
        int n2 = sGSXYData.getPointsNumber();
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n3 = sGAxis.getScaleType();
        int n4 = sGAxis2.getScaleType();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        if (n3 == 0) {
            d5 = d;
            d6 = d2;
            for (n = 0; n < n2; ++n) {
                dArray[n] = sGSXYData.getXValue(n);
            }
        } else if (n3 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
            for (n = 0; n < n2; ++n) {
                dArray[n] = Math.log(sGSXYData.getXValue(n));
            }
        }
        if (n4 == 0) {
            d7 = d3;
            d8 = d4;
            for (n = 0; n < n2; ++n) {
                dArray2[n] = sGSXYData.getYValue(n);
            }
        } else if (n4 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
            for (n = 0; n < n2; ++n) {
                dArray2[n] = Math.log(sGSXYData.getYValue(n));
            }
        }
        for (n = 0; n < n2; ++n) {
            float f = (float)((dArray[n] - d5) / (d6 - d5));
            float f2 = (float)(1.0 - (dArray2[n] - d7) / (d8 - d7));
            float f3 = this.mGraphRectX + f * this.mGraphRectWidth;
            float f4 = this.mGraphRectY + f2 * this.mGraphRectHeight;
            sGTuple2fArray[n].setValues(f3, f4);
        }
        return true;
    }

    protected boolean calcLocationOfVXYData(SGTuple2d[] sGTuple2dArray, SGTuple2d[] sGTuple2dArray2, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        int n;
        int n2;
        if (sGTuple2dArray == null || sGTuple2dArray2 == null || sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null || startLocationArray==null || endLocationArray==null");
        }
        if (sGTuple2dArray.length != sGTuple2dArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startLocationArray.length != endLocationArray.length");
        }
        int n3 = sGTuple2dArray.length;
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n4 = sGAxis.getScaleType();
        int n5 = sGAxis2.getScaleType();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        if (n4 == 0) {
            d5 = d;
            d6 = d2;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = sGTuple2dArray[n2].x;
                dArray3[n2] = sGTuple2dArray2[n2].x;
            }
        } else if (n4 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = Math.log(sGTuple2dArray[n2].x);
                dArray3[n2] = Math.log(sGTuple2dArray2[n2].x);
            }
        }
        if (n5 == 0) {
            d7 = d3;
            d8 = d4;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = sGTuple2dArray[n2].y;
                dArray4[n2] = sGTuple2dArray2[n2].y;
            }
        } else if (n5 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = Math.log(sGTuple2dArray[n2].y);
                dArray4[n2] = Math.log(sGTuple2dArray2[n2].y);
            }
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[i] = (float)((dArray[i] - d5) / (d6 - d5));
            fArray2[i] = (float)(1.0 - (dArray2[i] - d7) / (d8 - d7));
        }
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray3[i] = (float)((dArray3[i] - d5) / (d6 - d5));
            fArray4[i] = (float)(1.0 - (dArray4[i] - d7) / (d8 - d7));
        }
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        float f3 = this.mGraphRectWidth;
        float f4 = this.mGraphRectHeight;
        for (n = 0; n < n3; ++n) {
            sGTuple2fArray[n].setValues(f + fArray[n] * f3, f2 + fArray2[n] * f4);
        }
        for (n = 0; n < n3; ++n) {
            sGTuple2fArray2[n].setValues(f + fArray3[n] * f3, f2 + fArray4[n] * f4);
        }
        return true;
    }

    public int getSelectedDataNumber() {
        return this.getFocusedObjectsList().size();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)sGISelectable;
        elementGroupSetInGraph.setVisible(false);
        return true;
    }

    protected boolean clickElementGroupSet(MouseEvent mouseEvent, ElementGroupSetInGraph elementGroupSetInGraph) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (elementGroupSetInGraph.contains(n, n2)) {
            this.updateFocusedObjectsList(elementGroupSetInGraph, mouseEvent);
            if (!(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    this.setPropertyOfSelectedData();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    elementGroupSetInGraph.mPopupMenu.show(this, n, n2);
                }
            }
            this.focusedDataChanged();
            return true;
        }
        return false;
    }

    protected boolean pressElementGroupSet(MouseEvent mouseEvent, ElementGroupSetInGraph elementGroupSetInGraph) {
        boolean bl = elementGroupSetInGraph.contains(mouseEvent.getX(), mouseEvent.getY());
        return bl;
    }

    protected boolean dragElementGroupSet(MouseEvent mouseEvent, ElementGroupSetInGraph elementGroupSetInGraph) {
        return this.getFocusedObjectsList().size() != 0;
    }

    protected boolean hideGroupSet(SGElementGroupSet sGElementGroupSet) {
        sGElementGroupSet.setVisible(false);
        return true;
    }

    protected boolean moveGroupSetToFront(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(this.mGroupSetList.size(), sGElementGroupSet);
        this.mDataList.add(this.mDataList.size(), sGData);
        return true;
    }

    protected boolean moveGroupSetToBack(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(0, sGElementGroupSet);
        this.mDataList.add(0, sGData);
        return true;
    }

    protected boolean removeGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean hideSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            sGElementGroupSet.setVisible(false);
        }
        this.clearFocusedObjects();
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean isDataVisible(SGData sGData) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        return sGElementGroupSet.isVisible();
    }

    public boolean removeSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            this.removeGroupSet(sGElementGroupSet);
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean moveSelectedDataToFront() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            if (this.moveGroupSetToFront(sGElementGroupSet)) continue;
            return false;
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean moveSelectedDataToBack() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            if (this.moveGroupSetToBack(sGElementGroupSet)) continue;
            return false;
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    protected SGElementGroupSet getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            return sGElementGroupSet;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    private boolean addSelectedGroupSet(SGElementGroupSet sGElementGroupSet) {
        return true;
    }

    private boolean removeSelectedGroupSet(SGElementGroupSet sGElementGroupSet) {
        return true;
    }

    private boolean clearSelectedElementsGroupSet() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            this.removeSelectedGroupSet(sGElementGroupSet);
        }
        return true;
    }

    public ArrayList getPropertySettingListerListOfDataElements() {
        return this.getFocusedObjectsList();
    }

    public SGPropertyDialog getPropertyDialogForDataElements() {
        return mPropertyDialogForData;
    }

    protected boolean drawAnchorsForFocusedObjects(Point2D point2D, Graphics2D graphics2D) {
        SGUtilityForFigureElement.drawAnchorAsFocusedObject(point2D, graphics2D);
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!super.onMouseClicked(mouseEvent)) {
            return false;
        }
        if (this.clickDrawingElements(mouseEvent)) {
            return true;
        }
        this.clearFocusedObjects();
        this.focusedDataChanged();
        return false;
    }

    public boolean clickDrawingElements(MouseEvent mouseEvent) {
        for (int i = this.mGroupSetList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph.isVisible() || !this.clickElementGroupSet(mouseEvent, elementGroupSetInGraph)) continue;
            return true;
        }
        return false;
    }

    public boolean pressDrawingElements(MouseEvent mouseEvent) {
        for (int i = this.mGroupSetList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!this.pressElementGroupSet(mouseEvent, elementGroupSetInGraph)) continue;
            return true;
        }
        return false;
    }

    public boolean dragDrawingElements(MouseEvent mouseEvent) {
        for (int i = this.mGroupSetList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!this.dragElementGroupSet(mouseEvent, elementGroupSetInGraph)) continue;
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (!super.onMousePressed(mouseEvent)) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return this.pressDrawingElements(mouseEvent);
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!super.onMouseDragged(mouseEvent)) {
            return false;
        }
        return this.dragDrawingElements(mouseEvent);
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return super.onMouseReleased(mouseEvent);
    }

    public boolean onDrawingElement(int n, int n2) {
        if (!this.isInsideGraphArea(n, n2)) {
            return false;
        }
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    protected boolean drawRectangle(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(d, d3, d2, d3);
        Line2D.Double double_2 = new Line2D.Double(d, d4, d2, d4);
        Line2D.Double double_3 = new Line2D.Double(d, d3, d, d4);
        Line2D.Double double_4 = new Line2D.Double(d2, d3, d2, d4);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
        graphics2D.draw(double_4);
        return true;
    }

    public boolean changeXAxis(SGData sGData) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            this.changeXAxis(elementGroupSetInGraph);
            return true;
        }
        return false;
    }

    public boolean changeYAxis(SGData sGData) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            this.changeYAxis(elementGroupSetInGraph);
            return true;
        }
        return false;
    }

    public boolean changeZAxis(SGData sGData) {
        return true;
    }

    protected boolean changeXAxis(ElementGroupSetInGraph elementGroupSetInGraph) {
        SGAxis sGAxis = elementGroupSetInGraph.mXAxis;
        ArrayList arrayList = this.mAxisElement.getXAxisList();
        SGAxis sGAxis2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGAxis sGAxis3 = (SGAxis)arrayList.get(i);
            if (sGAxis != sGAxis3) continue;
            sGAxis2 = (SGAxis)arrayList.get((i + 1) % arrayList.size());
            break;
        }
        sGAxis = sGAxis2;
        elementGroupSetInGraph.mXAxis = sGAxis2;
        return true;
    }

    protected boolean changeYAxis(ElementGroupSetInGraph elementGroupSetInGraph) {
        SGAxis sGAxis = elementGroupSetInGraph.mYAxis;
        ArrayList arrayList = this.mAxisElement.getYAxisList();
        SGAxis sGAxis2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGAxis sGAxis3 = (SGAxis)arrayList.get(i);
            if (sGAxis != sGAxis3) continue;
            sGAxis2 = (SGAxis)arrayList.get((i + 1) % arrayList.size());
            break;
        }
        sGAxis = sGAxis2;
        elementGroupSetInGraph.mYAxis = sGAxis2;
        return true;
    }

    public String getTagName() {
        return "Graph";
    }

    public Element createElement(Document document) {
        return null;
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        return true;
    }

    public boolean createElementOfData(Document document, ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
            Element element = elementGroupSetInGraph.createElement(document);
            if (element == null) {
                return false;
            }
            element.setAttribute("Type", elementGroupSetInGraph.getDataClassName());
            arrayList.add(element);
        }
        return true;
    }

    public SGProperties getProperties() {
        GraphProperties graphProperties = new GraphProperties();
        if (!this.getProperties(graphProperties)) {
            return null;
        }
        return graphProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        graphProperties.visibleElementGroupList = this.getVisibleElementGroupSetList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        boolean bl = this.setVisibleElementGroupList(graphProperties.visibleElementGroupList);
        return bl;
    }

    protected ArrayList getVisibleElementGroupSetList() {
        ArrayList<SGElementGroupSet> arrayList = new ArrayList<SGElementGroupSet>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.isVisible()) continue;
            arrayList.add(sGElementGroupSet);
        }
        return arrayList;
    }

    protected boolean setVisibleElementGroupList(ArrayList arrayList) {
        SGElementGroupSet sGElementGroupSet;
        int n;
        ArrayList arrayList2 = new ArrayList(arrayList);
        ArrayList<SGElementGroupSet> arrayList3 = new ArrayList<SGElementGroupSet>();
        ArrayList<SGData> arrayList4 = new ArrayList<SGData>();
        ArrayList<SGData> arrayList5 = new ArrayList<SGData>();
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(n);
            boolean bl = arrayList.contains(sGElementGroupSet);
            sGElementGroupSet.setVisible(bl);
            if (bl) continue;
            arrayList3.add(sGElementGroupSet);
            arrayList5.add(this.getData(sGElementGroupSet));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)arrayList2.get(n);
            SGData sGData = this.getData(sGElementGroupSet);
            arrayList4.add(sGData);
        }
        this.mGroupSetList.clear();
        this.mDataList.clear();
        for (n = 0; n < arrayList2.size(); ++n) {
            this.mGroupSetList.add(arrayList2.get(n));
            this.mDataList.add(arrayList4.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.mGroupSetList.add(arrayList3.get(n));
            this.mDataList.add(arrayList5.get(n));
        }
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.setAllDrawingElementsLocation();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.setAllDrawingElementsLocation();
        this.notifyChange();
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleElementGroupSetList());
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public static class GraphProperties
    extends SGProperties {
        ArrayList visibleElementGroupList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof GraphProperties)) {
                return false;
            }
            GraphProperties graphProperties = (GraphProperties)object;
            return graphProperties.visibleElementGroupList.equals(this.visibleElementGroupList);
        }
    }

    public static interface IElementGroupInGraph {
        public void setFocused(boolean var1);

        public boolean isFocused();
    }

    abstract class ElementGroupSetForMultipleData
    extends ElementGroupSetInGraph
    implements ActionListener {
        protected ArrayList mElementGroupSetList = new ArrayList();

        protected ElementGroupSetForMultipleData() {
        }

        public ArrayList getVisibleFlagList() {
            if (this.mElementGroupSetList.size() == 0) {
                return new ArrayList();
            }
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
            return arrayList;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGISelectable sGISelectable = (SGISelectable)this.mElementGroupSetList.get(i);
                sGISelectable.setSelected(bl);
            }
        }

        public boolean contains(int n, int n2) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                if (!sGElementGroupSet.contains(n, n2)) continue;
                return true;
            }
            return false;
        }

        public boolean setMagnification(float f) {
            super.setMagnification(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.setMagnification(f);
            }
            return true;
        }

        public boolean zoom(float f) {
            super.zoom(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.zoom(f);
            }
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(n);
            }
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(sGDrawingElement);
            }
            return true;
        }

        public boolean onDrawingElement(int n, int n2) {
            for (int i = this.mElementGroupSetList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                boolean bl = elementGroupSetInGraph.onDrawingElement(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            for (int i = this.mElementGroupSetList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.paintGraphics2D(graphics2D);
            }
        }

        public ArrayList getDrawingElementList() {
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            if (this.mElementGroupSetList.size() == 0) {
                return arrayList;
            }
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(0);
            for (int i = 0; i < sGElementGroupSet.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)sGElementGroupSet.mDrawingElementGroupList.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                arrayList.add(sGDrawingElement);
            }
            return arrayList;
        }

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
                elementGroupSetInGraph.setDrawingElementProperties(arrayList);
            }
            return true;
        }
    }

    protected abstract class ElementGroupSetInGraph
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    WindowListener,
    SGIUndoable,
    SGIPropertySettingListener,
    SGISelectable {
        protected boolean mSelectedFlag = false;
        protected SGAxis mXAxis = null;
        protected SGAxis mYAxis = null;
        protected SGAxis mZAxis = null;
        protected SGProperties mTemporaryProperties = null;
        protected JPopupMenu mPopupMenu = new JPopupMenu();
        protected boolean mChangedFlag = false;
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                IElementGroupInGraph iElementGroupInGraph = (IElementGroupInGraph)this.mDrawingElementGroupList.get(i);
                iElementGroupInGraph.setFocused(bl);
            }
        }

        protected ElementGroupSetInGraph() {
        }

        protected boolean setXAxis(SGAxis sGAxis) {
            this.mXAxis = sGAxis;
            return true;
        }

        protected boolean setYAxis(SGAxis sGAxis) {
            this.mYAxis = sGAxis;
            return true;
        }

        protected boolean setZAxis(SGAxis sGAxis) {
            this.mZAxis = sGAxis;
            return true;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public SGAxis getZAxis() {
            return this.mZAxis;
        }

        public ArrayList getVisibleFlagList() {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            ArrayList arrayList2 = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                boolean bl = sGElementGroup.isVisible();
                arrayList.add(new Boolean(bl));
            }
            return arrayList;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object.equals(mPropertyDialogForData)) {
                this.cancel();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGGraphElement.this.setPropertyOfSelectedData();
            } else if (string.equals(SGGraphElement.MENUCMD_MOVE_DATA_TO_FRONT)) {
                this.moveSelectedDataToFront();
            } else if (string.equals(SGGraphElement.MENUCMD_MOVE_DATA_TO_BACK)) {
                this.moveSelectedDataToBack();
            } else if (string.equals(SGGraphElement.MENUCMD_REMOVE_DATA)) {
                this.hideSelectedData();
            }
        }

        public boolean moveSelectedDataToFront() {
            ArrayList arrayList = SGGraphElement.this.getFocusedObjectsList();
            if (arrayList.size() == 0) {
                return true;
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
                if (SGGraphElement.this.moveGroupSetToFront(sGElementGroupSet)) continue;
                return false;
            }
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.setParentChanged(true);
            this.notifyToRoot();
            return true;
        }

        public boolean moveSelectedDataToBack() {
            ArrayList arrayList = SGGraphElement.this.getFocusedObjectsList();
            if (arrayList.size() == 0) {
                return true;
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
                if (SGGraphElement.this.moveGroupSetToBack(sGElementGroupSet)) continue;
                return false;
            }
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.setParentChanged(true);
            this.notifyToRoot();
            return true;
        }

        public boolean hideSelectedData() {
            ArrayList arrayList = SGGraphElement.this.getFocusedObjectsList();
            if (arrayList.size() == 0) {
                return true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
                sGElementGroupSet.setVisible(false);
            }
            SGGraphElement.this.clearFocusedObjects();
            SGGraphElement.this.notifyChange();
            SGGraphElement.this.setParentChanged(true);
            this.notifyToRoot();
            return true;
        }

        protected abstract boolean createDrawingElements();

        public boolean onDrawingElement(int n, int n2) {
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                SGDrawingElement[] sGDrawingElementArray = sGElementGroup.mDrawingElementArray;
                for (int j = 0; j < sGDrawingElementArray.length; ++j) {
                    if (!sGDrawingElementArray[j].contains(n, n2)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean showPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = mPropertyDialogForData;
            sGPropertyDialog.addPropertySettingListener(this);
            sGPropertyDialog.setLocation(SGGraphElement.this.mDialogOwner.getLocation());
            return true;
        }

        public boolean commit() {
            boolean bl = this.setPropertiesFromDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mChangedFlag = true;
            }
            this.mTemporaryProperties = null;
            mPropertyDialogForData.setVisible(false);
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.recover()) {
                throw new Error();
            }
            this.mTemporaryProperties = null;
            SGPropertyDialog sGPropertyDialog = mPropertyDialogForData;
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            boolean bl = this.setPropertiesFromDialog();
            if (!bl) {
                return false;
            }
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.notifyChange();
            return true;
        }

        public boolean setPropertiesFromDialog() {
            return true;
        }

        protected boolean recover() {
            return this.setWholeProperties(this.mTemporaryProperties);
        }

        public SGProperties getProperties() {
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = new ElementGroupSetInGraphProperties();
            if (!this.getProperties(elementGroupSetInGraphProperties)) {
                return null;
            }
            return elementGroupSetInGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            super.getProperties(sGProperties);
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            elementGroupSetInGraphProperties.xAxis = this.mXAxis;
            elementGroupSetInGraphProperties.yAxis = this.mYAxis;
            elementGroupSetInGraphProperties.zAxis = this.mZAxis;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            this.mXAxis = elementGroupSetInGraphProperties.xAxis;
            this.mYAxis = elementGroupSetInGraphProperties.yAxis;
            this.mZAxis = elementGroupSetInGraphProperties.zAxis;
            return true;
        }

        public abstract String getDataClassName();

        public Element createElement(Document document) {
            Element element = super.createElement(document);
            element.setAttribute("Type", this.getDataClassName());
            return element;
        }

        public String getTagName() {
            return "Data";
        }

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mDrawingElementGroupList;
            if (arrayList.size() != arrayList2.size()) {
                throw new IllegalArgumentException("dElementList.size() != groupList.size()");
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                sGElementGroup.setProperty(sGDrawingElement);
            }
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGElementGroupSet.WholeProperties wholeProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(wholeProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.setAllDrawingElementsLocation();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGGraphElement.this.setAllDrawingElementsLocation();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.mChangedFlag) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mElementGroupSetStateCounter;
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        public void notifyToRoot() {
            SGGraphElement.this.notifyToRootFromFigureElement();
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        class ElementGroupSetInGraphProperties
        extends SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement {
            SGAxis xAxis;
            SGAxis yAxis;
            SGAxis zAxis;

            ElementGroupSetInGraphProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInGraphProperties)) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)object;
                if (!elementGroupSetInGraphProperties.xAxis.equals(this.xAxis)) {
                    return false;
                }
                if (!elementGroupSetInGraphProperties.yAxis.equals(this.yAxis)) {
                    return false;
                }
                return elementGroupSetInGraphProperties.zAxis == null && this.zAxis == null || elementGroupSetInGraphProperties.zAxis.equals(this.zAxis);
            }

            public String toString() {
                String string = new String("[");
                string = string + super.toString();
                string = string + new String("xAxis=" + this.xAxis + ", ");
                string = string + new String("yAxis=" + this.yAxis + ", ");
                string = string + new String("zAxis=" + this.zAxis + ", ");
                string = string + new String("]");
                return string;
            }
        }
    }
}

