;Samurai Graph installer script for Win32

!define SG_PRODUCT       "Samurai Graph"
!define SG_VER_MAJOR     "0"
!define SG_VER_MINOR     "3"
!define SG_VER_MICRO     "1"
!define SG_URL           "http://samurai-graph.sourceforge.jp/"
!define SG_PUBLISHER     "RIKEN BSI Neuroinformatics Laboratory"
!define SG_PUBLISHER_URL "http://www.ni.brain.riken.jp/"

!define SG_NAME    "${SG_PRODUCT} ${SG_VERSION}"
!define SG_VERSION "${SG_VER_MAJOR}.${SG_VER_MINOR}.${SG_VER_MICRO}"
!define SG_REGKEY  "Software\${SG_NAME}"
!define SG_UNINST_REGKEY  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_NAME}"

;!define SG_SELECT_COMPONENTS  "YES"

!include "MUI.nsh"

;--------------------------------
;General

  ;Name and file
  Name "${SG_NAME}"
  OutFile "samurai-graph-win32-${SG_VERSION}.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\${SG_NAME}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "${SG_REGKEY}" ""

  ;------------------------------
  ;Interface Configuration

  ; Installer and uninstaller icon file
  !define MUI_ICON   "resources\setup.ico"
  !define MUI_UNICON "resources\remove.ico"
  ; welcome page bitmap
  !define MUI_WELCOMEFINISHPAGE_BITMAP "resources\welcome.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "resources\unwelcome.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
!ifdef SG_SELECT_COMPONENTS
  !insertmacro MUI_PAGE_COMPONENTS
!endif
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  !include "languages\english.nsh"
  !include "languages\japanese.nsh"

;-------------------------
;Installer Sections
Section "Samura Graph" SecCopyUI

  ;Check an old installaion
  ;DetailPrint " - Check an old installation"
IfFileExists $INSTDIR\samurai-graph.jar exexist
  goto noexe
exexist:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_Overwrite) IDYES noexe
  ;DetailPrint "The installation was canceled.."
  Abort

noexe:
  ;DetailPrint " - Installation of the ${SG_NAME}"
  ;Store installation folder
  WriteRegStr HKCU "${SG_REGKEY}" "" $INSTDIR

  ;Install Files
  SetOutPath "$INSTDIR"
  File ..\..\dist\COPYING.txt
  File ..\..\dist\LICENSE.txt
  File ..\..\dist\samurai-graph.ico
  File ..\..\dist\samurai-graph.jar
;  File ..\..\dist\samurai-graph-client.jar

  SetOutPath "$INSTDIR\lib"
  File ..\..\helper\lib\upgrade-helper.jar

  SetOutPath "$INSTDIR\lib\vectorgraphics"
  File ..\..\dist\lib\vectorgraphics\freehep-base.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphics2d.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-cgm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-emf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-gif.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-java.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-pdf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ppm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ps.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-svg.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-swf.jar

  SetOutPath "$INSTDIR\doc\vectorgraphics"
  File ..\..\dist\doc\vectorgraphics\LGPL.txt
  File ..\..\dist\doc\vectorgraphics\LICENSE.txt
  File ..\..\dist\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt
  File ..\..\dist\doc\vectorgraphics\ReleaseNotes-1.2.2.html

  SetOutPath "$INSTDIR\examples"
  File ..\..\examples\data\ReadMe.txt
  File ..\..\examples\data\Example1.txt
  File ..\..\examples\data\Example2.txt
  File ..\..\examples\data\Example3.txt
  File ..\..\examples\data\Example4.txt
  File ..\..\examples\data\Example5.txt
  File ..\..\examples\data\Example6.txt
  File ..\..\examples\data\Example7.txt
  File ..\..\examples\data\Property1.sgp

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
; Section for Create shortcut on Desktop

Section "Desktop Shortcut" DesktopIcon
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateShortCut  "$DESKTOP\${SG_NAME}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
SectionEnd

;--------------------------------
; Section for Create shortcut on Start Menu

Section "Start Menu Shortcuts" StartMenu
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateDirectory "$SMPROGRAMS\${SG_NAME}"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Examples Directory.lnk" "$INSTDIR\examples"
  WriteINIStr "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Site.url" "InternetShortcut" "URL" "${SG_URL}"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\Uninstall.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0
SectionEnd

;--------------------------------
; Section for Regist Uninstall information

Section -post
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayName" "${SG_NAME}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayIcon" "$INSTDIR\samurai-graph.ico,0"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayVersion" "${SG_VERSION}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMajor"   "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMinor"   "${SG_VER_MINOR}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "Publisher"      "${SG_PUBLISHER}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLInfoAbout"   "${SG_PUBLISHER_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "HelpLink"       "${SG_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLUpdateInfo"  "${SG_URL}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoModify" "1"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoRepair" "1"
SectionEnd

!ifdef SG_SELECT_COMPONENTS
;--------------------------------
;Descriptions

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
    !insertmacro MUI_DESCRIPTION_TEXT ${DesktopIcon} $(DESC_DesktopIcon)
    !insertmacro MUI_DESCRIPTION_TEXT ${StartMenu} $(DESC_StartMenu)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

;-------------------------
;Uninstaller Section

!include "WinMessages.nsh"

Function un.CloseProgram
  Push $0
  loop:
    FindWindow $0 "jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow"
    IntCmp $0 0 done
    SendMessage $0 ${WM_CLOSE} 0 0
    Sleep 300
    Goto loop
  done:
  Pop $0
FunctionEnd

Section "Uninstall"
  ;If Samurai Graph windows exist, close them.
  Call un.CloseProgram

  ;Uninstall Files
  Delete /REBOOTOK "$INSTDIR\COPYING.txt"
  Delete /REBOOTOK "$INSTDIR\LICENSE.txt"
  Delete /REBOOTOK "$INSTDIR\samurai-graph.ico"
  Delete /REBOOTOK "$INSTDIR\samurai-graph.jar"
;  Delete /REBOOTOK "$INSTDIR\samurai-graph-client.jar"

  Delete /REBOOTOK "$INSTDIR\lib\upgrade-helper.jar"

  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-base.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphics2d.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-cgm.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-emf.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-gif.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-java.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-pdf.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ppm.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ps.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-svg.jar"
  Delete /REBOOTOK "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-swf.jar"

  Delete /REBOOTOK "$INSTDIR\doc\vectorgraphics\LGPL.txt"
  Delete /REBOOTOK "$INSTDIR\doc\vectorgraphics\LICENSE.txt"
  Delete /REBOOTOK "$INSTDIR\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt"
  Delete /REBOOTOK "$INSTDIR\doc\vectorgraphics\ReleaseNotes-1.2.2.html"

  Delete /REBOOTOK "$INSTDIR\examples\ReadMe.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example1.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example2.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example3.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example4.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example5.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example6.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Example7.txt"
  Delete /REBOOTOK "$INSTDIR\examples\Property1.sgp"

  Delete /REBOOTOK "$INSTDIR\Uninstall.exe"

  ; desktop
  Delete /REBOOTOK "$DESKTOP\${SG_PRODUCT} ${SG_VERSION}.lnk"

  ; start menu
  Delete /REBOOTOK "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT}.lnk"
  Delete /REBOOTOK "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Examples Directory.lnk"
  Delete /REBOOTOK "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Site.url"
  Delete /REBOOTOK "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\Uninstall.lnk"
  RMDir  /REBOOTOK "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}"

  RMDir "$INSTDIR\lib\vectorgraphics"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\doc\vectorgraphics"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\examples\data"
  RMDir "$INSTDIR\examples"
  RMDir /r /REBOOTOK "$INSTDIR"

  ; delete regkeys
  DeleteRegKey /ifempty HKCU "${SG_REGKEY}"
  DeleteRegKey HKLM "${SG_UNINST_REGKEY}"


SectionEnd

;  Find JRE (javaw.exe)
Function GetJRE
;  1 - in .\jre directory (JRE Installed with application)
;  2 - in JAVA_HOME environment variable
;  3 - in the registry
;  4 - assume java.exe in current dir or PATH

  Push $R0
  Push $R1

  ClearErrors
  StrCpy $R0 "$EXEDIR\jre\bin\javaw.exe"
  IfFileExists $R0 JreFound
  StrCpy $R0 ""

  ClearErrors
  ReadEnvStr $R0 "JAVA_HOME"
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfErrors 0 JreFound

  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
  ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R1" "JavaHome"
  StrCpy $R0 "$R0\jre\bin\javaw.exe"
  IfErrors 0 JreFound

  StrCpy $R0 "javaw.exe"
        
 JreFound:
  Pop $R1
  Exch $R0
FunctionEnd
