/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;

public class SGVXYData
extends SGData
implements SGITwoDimensionalData {
    private SGTuple2d[] mStartArray = null;
    private double[] mMagnitudeArray = null;
    private double[] mAngleArray = null;

    public SGVXYData() {
    }

    public SGVXYData(SGTuple2d[] sGTuple2dArray, double[] dArray, double[] dArray2) {
        this.mStartArray = sGTuple2dArray;
        this.setMagnitudeArray(dArray);
        this.setAngleArray(dArray2);
    }

    public SGVXYData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray3.length;
        this.setStartArray(dArray, dArray2);
        this.setMagnitudeArray(dArray3);
        this.setAngleArray(dArray4);
    }

    public SGVXYData(SGData sGData) {
        this.setData(sGData);
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGVXYData)) {
            return false;
        }
        SGVXYData sGVXYData = (SGVXYData)sGData;
        this.setStartArray(sGVXYData.getStartArray());
        this.setMagnitudeArray(sGVXYData.getMagnitudeArray());
        this.setAngleArray(sGVXYData.getAngleArray());
        return true;
    }

    public int getPointsNumber() {
        return this.mStartArray.length;
    }

    private boolean setStartArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        this.mStartArray = new SGTuple2d[n];
        for (int i = 0; i < n; ++i) {
            this.mStartArray[i] = new SGTuple2d();
            this.mStartArray[i].x = dArray[i];
            this.mStartArray[i].y = dArray2[i];
        }
        return true;
    }

    private boolean setMagnitudeArray(double[] dArray) {
        int n = dArray.length;
        this.mMagnitudeArray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.mMagnitudeArray[i] = dArray[i];
        }
        return true;
    }

    private boolean setAngleArray(double[] dArray) {
        int n = dArray.length;
        this.mAngleArray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.mAngleArray[i] = dArray[i];
        }
        return true;
    }

    private boolean setStartArray(SGTuple2d[] sGTuple2dArray) {
        this.mStartArray = sGTuple2dArray;
        return true;
    }

    public double getMinValueX() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.mStartArray.length; ++i) {
            double d2;
            double d3 = this.mStartArray[i].x;
            if (d3 < d) {
                d = d3;
            }
            if (!((d2 = this.mStartArray[i].x + this.mMagnitudeArray[i] * Math.cos(this.mAngleArray[i])) < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueX() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.mStartArray.length; ++i) {
            double d2;
            double d3 = this.mStartArray[i].x;
            if (d3 > d) {
                d = d3;
            }
            if (!((d2 = this.mStartArray[i].x + this.mMagnitudeArray[i] * Math.cos(this.mAngleArray[i])) > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinValueY() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.mStartArray.length; ++i) {
            double d2;
            double d3 = this.mStartArray[i].y;
            if (d3 < d) {
                d = d3;
            }
            if (!((d2 = this.mStartArray[i].y + this.mMagnitudeArray[i] * Math.sin(this.mAngleArray[i])) < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueY() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.mStartArray.length; ++i) {
            double d2;
            double d3 = this.mStartArray[i].y;
            if (d3 > d) {
                d = d3;
            }
            if (!((d2 = this.mStartArray[i].y + this.mMagnitudeArray[i] * Math.sin(this.mAngleArray[i])) > d)) continue;
            d = d2;
        }
        return d;
    }

    public SGTuple2d[] getStartArray() {
        return this.mStartArray;
    }

    public double[] getMagnitudeArray() {
        return this.mMagnitudeArray;
    }

    public double[] getAngleArray() {
        return this.mAngleArray;
    }

    public SGTuple2d[] getEndArray() {
        SGTuple2d[] sGTuple2dArray = new SGTuple2d[this.mStartArray.length];
        for (int i = 0; i < sGTuple2dArray.length; ++i) {
            sGTuple2dArray[i] = new SGTuple2d();
            sGTuple2dArray[i].x = this.mStartArray[i].x + this.mMagnitudeArray[i] * Math.cos(this.mAngleArray[i]);
            sGTuple2dArray[i].y = this.mStartArray[i].y + this.mMagnitudeArray[i] * Math.sin(this.mAngleArray[i]);
        }
        return sGTuple2dArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }
}

