/*
 * SGLegendDialog.java
 *
 * Created on 2004/06/09, 14:49
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;


/**
 *
 * @author  kuromaru
 */
public class SGLegendDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Legend Dialog";


    /** Creates new form SGLegendDialog */
    public SGLegendDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mLabelSpace1 = new javax.swing.JLabel();
        mLegendPanel = new javax.swing.JPanel();
        mLegendVisibleCheckBox = new javax.swing.JCheckBox();
        mFrameVisibleCheckBox = new javax.swing.JCheckBox();
        mFrameLabel = new javax.swing.JLabel();
        mFrameLineWidthLabel = new javax.swing.JLabel();
        mFrameLineColorLabel = new javax.swing.JLabel();
        mBackgroundColorLabel = new javax.swing.JLabel();
        mFrameLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFrameLineColorButton = new javax.swing.JButton();
        mFrameSeparator = new javax.swing.JSeparator();
        mBackgroundColorButton = new javax.swing.JButton();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontSizeLabel = new javax.swing.JLabel();
        mStringColorLabel = new javax.swing.JLabel();
        mFontNameComboBox = new javax.swing.JComboBox();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mStringColorButton = new javax.swing.JButton();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBackgroundLabel = new javax.swing.JLabel();
        mBackgroundTransparentCheckBox = new javax.swing.JCheckBox();
        mLocationLabel = new javax.swing.JLabel();
        mBackgroundSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new javax.swing.JTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new javax.swing.JTextField();
        mFontStyleLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mlButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();

        mLabelSpace1.setText("  ");

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mLegendPanel.setLayout(new java.awt.GridBagLayout());

        mLegendPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mLegendPanel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 70, 5, 5);
        mLegendPanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mFrameVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        mLegendPanel.add(mFrameVisibleCheckBox, gridBagConstraints);

        mFrameLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFrameLabel.setText("Frame");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFrameLabel, gridBagConstraints);

        mFrameLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mLegendPanel.add(mFrameLineWidthLabel, gridBagConstraints);

        mFrameLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mFrameLineColorLabel, gridBagConstraints);

        mBackgroundColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mBackgroundColorLabel, gridBagConstraints);

        mFrameLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineWidthSpinner, gridBagConstraints);

        mFrameLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineColorButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mLegendPanel.add(mFrameSeparator, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mBackgroundColorButton, gridBagConstraints);

        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontSizeLabel, gridBagConstraints);

        mStringColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStringColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mLegendPanel.add(mStringColorLabel, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontNameComboBox, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        mFontSizeSpinner.setMinimumSize(new java.awt.Dimension(25, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontStyleComboBox, gridBagConstraints);

        mStringColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringColorButton, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 5, 5);
        mLegendPanel.add(mStringSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mRightSpaceLabel, gridBagConstraints);

        mBackgroundLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBackgroundLabel.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mBackgroundLabel, gridBagConstraints);

        mBackgroundTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mLegendPanel.add(mBackgroundTransparentCheckBox, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mLegendPanel.add(mBackgroundSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mYValueTextField, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        mLegendPanel.add(mLocationSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mLegendPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mlButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mlButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mlButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mlButtonPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel;
    private javax.swing.JLabel mBackgroundLabel;
    private javax.swing.JSeparator mBackgroundSeparator;
    private javax.swing.JCheckBox mBackgroundTransparentCheckBox;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JLabel mFrameLabel;
    private javax.swing.JButton mFrameLineColorButton;
    private javax.swing.JLabel mFrameLineColorLabel;
    private javax.swing.JLabel mFrameLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFrameLineWidthSpinner;
    private javax.swing.JSeparator mFrameSeparator;
    private javax.swing.JCheckBox mFrameVisibleCheckBox;
    private javax.swing.JLabel mLabelSpace1;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JPanel mLegendPanel;
    private javax.swing.JCheckBox mLegendVisibleCheckBox;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JButton mStringColorButton;
    private javax.swing.JLabel mStringColorLabel;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JLabel mXValueLabel;
    private javax.swing.JTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private javax.swing.JTextField mYValueTextField;
    private javax.swing.JPanel mlButtonPanel;
    // ϐ錾̏I//GEN-END:variables
    

    /**
     * 
     */
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    
    
	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGLegendDialog.TITLE );


		// font name
		String fontArray[] = SGUtility.getAvailableFontNames();
		for(int ii=0 ; ii<fontArray.length ; ii++)
		{
			this.mFontNameComboBox.addItem( fontArray[ii] );
		}


		// font style
		String[] styleNameArray = {
			SGIConstants.FONT_PLAIN,
			SGIConstants.FONT_ITALIC,
			SGIConstants.FONT_BOLD,
			SGIConstants.FONT_BOLD_ITALIC
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mFontStyleComboBox.addItem( styleNameArray[ii] );
		}


		this.pack();


		//
		// create a radio-button-group
		//
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mLeftBottomRadioButton );
			group.add( this.mLeftTopRadioButton );
			group.add( this.mRightBottomRadioButton );
			group.add( this.mRightTopRadioButton );
			group.add( this.mNoAxisSelectionRadioButton );
		}


		//
		// Xsi[f̐ݒ
		//

		// axis line width
		this.mFrameLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		//
		// add an action-listener
		//

		this.mStringColorButton.addActionListener(this);
		this.mFrameLineColorButton.addActionListener(this);
		this.mBackgroundColorButton.addActionListener(this);

		this.mLegendVisibleCheckBox.addActionListener(this);
		this.mFrameVisibleCheckBox.addActionListener(this);
		this.mBackgroundTransparentCheckBox.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mFrameLineColorButton;


		return true;

	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);
		Object source = e.getSource();

		if( source.equals( this.mLegendVisibleCheckBox ) )
		{
			this.setLegendVisible( this.mLegendVisibleCheckBox.isSelected() );
//			this.setAllLegendComponentsEnabled( this.mLegendVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mFrameVisibleCheckBox ) )
		{
			this.setFrameComponentsEnabled( this.mFrameVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mBackgroundTransparentCheckBox ) )
		{
			this.setBackgroundComponentsEnabled(
				!this.mBackgroundTransparentCheckBox.isSelected() );
		}
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setAllLegendComponentsEnabled( final boolean b )
	{
		// String
		this.mStringLabel.setEnabled(b);
		this.setStringComponentsEnabled(b);

		// Frame
		this.mFrameLabel.setEnabled(b);
		this.mFrameVisibleCheckBox.setEnabled(b);
		final boolean bf = this.mFrameVisibleCheckBox.isSelected();
		this.setFrameComponentsEnabled( b & bf );

		// Background
		this.mBackgroundLabel.setEnabled(b);
		this.mBackgroundTransparentCheckBox.setEnabled(b);
		final boolean bb = !this.mBackgroundTransparentCheckBox.isSelected();
		this.setBackgroundComponentsEnabled( b & bb );

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setStringComponentsEnabled( final boolean b )
	{
                this.mFontFamilyLabel.setEnabled(b);
		this.mFontStyleLabel.setEnabled(b);
		this.mFontNameComboBox.setEnabled(b);
		this.mFontStyleComboBox.setEnabled(b);
		this.mFontSizeLabel.setEnabled(b);
		this.mFontSizeSpinner.setEnabled(b);
		this.mStringColorLabel.setEnabled(b);
		this.mStringColorButton.setEnabled(b);

		return true;
	}




	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setFrameComponentsEnabled( final boolean b )
	{
		this.mFrameLineWidthLabel.setEnabled(b);
		this.mFrameLineWidthSpinner.setEnabled(b);
		this.mFrameLineColorLabel.setEnabled(b);
		this.mFrameLineColorButton.setEnabled(b);
		return true;
	}


	/**
	 * 
	 */
	private boolean setBackgroundComponentsEnabled( final boolean b )
	{
		this.mBackgroundColorLabel.setEnabled(b);
		this.mBackgroundColorButton.setEnabled(b);
		return true;
	}



	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		this.mXValueTextField.addActionListener(listener);
		this.mYValueTextField.addActionListener(listener);
		
		return true;
	}


	
	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}




	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}


	/**
	 * 
	 */
	public boolean getLegendVisible()
	{
		return this.mLegendVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getFrameVisible()
	{
		return this.mFrameVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getFrameLineWidth()
	{
		return this.mFrameLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Color getFrameLineColor()
	{
		return this.mFrameLineColorButton.getBackground();
	}


	/**
	 * 
	 */
	public Color getBackgroundColor()
	{
		return this.mBackgroundColorButton.getBackground();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public Color getTextColor()
	{
		return this.mStringColorButton.getBackground();
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean isLegendTransparent()
	{
		return this.mBackgroundTransparentCheckBox.isSelected();
	}



	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Double d = SGUtilityText.getDouble(str);
		if( d==null )
		{
			return false;
		}
		this.mXValueTextField.setText( str );
		return true;
	}

	
	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getDouble(str);
		if( num==null )
		{
			return false;
		}
		this.mYValueTextField.setText( str );
		return true;
	}
	

	
	/**
	 * 
	 */
	public boolean setLegendVisible( final boolean flag )
	{
		this.mLegendVisibleCheckBox.setSelected( flag );
		this.setAllLegendComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameVisible( final boolean flag )
	{
		this.mFrameVisibleCheckBox.setSelected( flag );
		this.setFrameComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineWidth( final float width )
	{
		this.mFrameLineWidthSpinner.setValue( new Float(width) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineColor( final Color cl )
	{
		this.mFrameLineColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 */
	public boolean setBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double(size) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTextColor( final Color cl )
	{
		this.mStringColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean setLegendTransparent( final boolean flag )
	{
		this.mBackgroundTransparentCheckBox.setSelected(flag);
		this.setBackgroundComponentsEnabled( !flag );
		return true;
	}


	
	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}


	
	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mBackgroundColorButton );
		list.add( this.mFrameLineColorButton );
		list.add( this.mStringColorButton );

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mFrameLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGLegendElement.LegendCommonProperties getCommonProperties()
	{

		SGLegendElement.LegendCommonProperties p
			= new SGLegendElement.LegendCommonProperties();


		// visible
		p.visible = this.getLegendVisible();


		// frame
		p.frameLineVisible = this.getFrameVisible();

		Number frameLineWidth = this.getFrameLineWidth();
		if( frameLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.frameLineWidth = frameLineWidth.floatValue();
		}

		p.frameLineColor = this.getFrameLineColor();
		p.backgroundColor = this.getBackgroundColor();
		p.transparent = this.isLegendTransparent();


		// font
		p.fontName = this.getFontName();

		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize	= fontSize.floatValue();
		}

		p.fontStyle = this.getFontStyle();
		p.stringColor = this.getTextColor();


		return p;

	}

    
}
