/*
 * Created on 2004/09/29
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbol;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SGAxisBreakSymbol2D extends SGAxisBreakSymbol
	implements SGIDrawingElementJava2D
{


	/**
	 * 
	 */
	protected Shape mCurve1 = null;
	

	/**
	 * 
	 */	
	protected Shape mCurve2 = null;


	/**
	 * 
	 */
	public SGAxisBreakSymbol2D()
	{
		super();
	}


	/**
	 * 
	 */
	public SGAxisBreakSymbol2D(
		final float length,
		final float interval,
		final float dist,
		final float angle,
		final boolean horizontal )
	{
		super(length,interval,dist,angle,horizontal);
	}


	/**
	 * 
	 */
	public boolean contains( final int x, final int y )
	{
		return this.getElementBounds().contains(x,y);
	}



	/**
	 * 
	 */
	public Rectangle2D getElementBounds()
	{
		if( this.mCurve1==null || this.mCurve2==null )
		{
			return new Rectangle2D.Float();
		}
		return this.getArea().getBounds2D();
	}

	

	/**
	 * 
	 * @return
	 */
	public Area getArea()
	{
		Shape[] array = this.getShapeArray();
		Area area = new Area();
		for( int ii=0; ii<array.length; ii++ )
		{
			Area a = new Area( array[ii] );
			area.add( a );
		}
		return area;
	}
	


	/**
	 * 
	 * @return
	 */
	protected CubicCurve2D getBaseCurve()
	{
		final float length = this.getLength();
		final float dist = this.getDistortion()*this.getLength();

		CubicCurve2D cv = new CubicCurve2D.Float(
			0.0f, 0.0f,
			- dist, 0.25f*length,
			dist, 0.75f*length,
			0.0f, length
		);

		return cv;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean create()
	{
		this.createCurve1();
		this.createCurve2();
		return true;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean createCurve1()
	{
		final float x = this.getX();
		final float y = this.getY();
		final float length = this.getLength();
		final float interval = this.getInterval();

		float sn = (float)Math.sin( this.mAngle );
		float cs = (float)Math.cos( this.mAngle );

		Shape[] array = new Shape[4];
		AffineTransform af = new AffineTransform();
		float startX1;
		float startY1;
		float angle = this.mAngle;
		if( this.isForHorizontalAxis() )
		{
			startX1 = x - interval/2.0f - (length/2.0f)*sn;
			startY1 = y - (length/2.0f)*cs;
		}
		else
		{
			startX1 = x - (length/2.0f)*cs;
			startY1 = y - interval/2.0f + (length/2.0f)*sn;
			angle += Math.PI/2.0;
		}
		af.translate(startX1,startY1);
		af.rotate(-angle);

		this.mCurve1 = af.createTransformedShape( this.getBaseCurve() );

		return true;		
	}



	/**
	 * 
	 * @return
	 */
	protected boolean createCurve2()
	{
		SGTuple2f pos = this.getLocation();

		AffineTransform af = new AffineTransform();
		af.rotate( Math.PI, pos.x, pos.y );
		this.mCurve2 = af.createTransformedShape( this.mCurve1 );

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public Shape[] getShapeArray()
	{
		if( this.mCurve1==null || this.mCurve2==null )
		{
			return new Shape[0];
		}

		Shape[] array = new Shape[4];

		Shape curve1 = this.mCurve1;
		Shape curve2 = this.mCurve2;

		PathIterator itr1 = curve1.getPathIterator(null);
		ArrayList list1 = SGUtilityJava2D.getSegmentList( itr1 );
		Point2D pStart1 = (Point2D)list1.get(0);
		Point2D pEnd1 = (Point2D)list1.get( list1.size() -1 );

		PathIterator itr2 = curve2.getPathIterator(null);
		ArrayList list2 = SGUtilityJava2D.getSegmentList( itr2 );
		Point2D pStart2 = (Point2D)list2.get(0);
		Point2D pEnd2 = (Point2D)list2.get( list2.size() -1 );

		array[0] = curve1;

		array[1] = new Line2D.Float(
			(float)pEnd1.getX(), (float)pEnd1.getY(),
			(float)pStart2.getX(), (float)pStart2.getY() );

		array[2] = curve2;

		array[3] = new Line2D.Float(
			(float)pEnd2.getX(), (float)pEnd2.getY(),
			(float)pStart1.getX(), (float)pStart1.getY() );

		return array;

	}



	/**
	 * 
	 * @return
	 */
	public GeneralPath getConnectedPath()
	{
		GeneralPath gp = new GeneralPath();
		Shape[] array = this.getShapeArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			gp.append( array[ii], true );
		}
		return gp;
	}


	/**
	 * 
	 */
	public void setLocation( final float x, final float y )
	{
		super.setLocation(x,y);
		this.create();
	}



	/**
	 * 
	 * @param length
	 * @param interval
	 * @param dist
	 * @param angle
	 * @param horizontal
	 */
	public void setForm(
		final float length,
		final float interval,
		final float dist,
		final float angle,
		final boolean horizontal )
	{
		super.setForm(length,interval,dist,angle,horizontal);
		this.create();
	}



	/**
	 * 
	 */
	public boolean zoom( final float mag )
	{
		super.zoom( mag );
		this.create();
		return true;
	}



	/**
	 * 
	 * @param g2d
	 */
	public void drawSymbol( final Graphics2D g2d )
	{
		if( this.mCurve1==null || this.mCurve2==null )
		{
			return;
		}

		g2d.setPaint( this.getColor(0) );
		g2d.fill( this.getConnectedPath() );

		g2d.setPaint( this.getLineColor() );
		g2d.setStroke(
			new BasicStroke( this.getLineWidth()*this.getMagnification() )
		);

		g2d.draw( this.mCurve1 );
		g2d.draw( this.mCurve2 );
	}



	/**
	 * 
	 */
	public Object copy()
	{
		SGAxisBreakSymbol2D el = new SGAxisBreakSymbol2D();
		this.setPropertiesForCopy(el);
		return el;
	}


	protected boolean setPropertiesForCopy( SGAxisBreakSymbol2D el )
	{
		el.setProperties( this.getProperties() );
		el.setLocation( this.getX(), this.getY() );
		el.setMagnification( this.mMagnification );
		return true;
	}

}

