
package jp.riken.brain.ni.samuraigraph.base;


/**
 * 
 */
public interface SGIConstants
{

	/**
	 * The ratio of cm to inch.
	 */
	public static final float CM_INCH_RATIO = 2.54f;


	/**
	 * The ratio of inch to point.
	 */
	public static final float INCH_POINT_RATIO = 72.0f;


	/**
	 * The ratio of cm to point.
	 */
	public static final float CM_POINT_RATIO = CM_INCH_RATIO/INCH_POINT_RATIO;


	/**
	 * The ratio of radian to degree.
	 */
	public static final float RADIAN_DEGREE_RATIO = (float)(Math.PI/180.0);


	/**
	 * The golden ratio.
	 */
	public static final float GOLDEN_RATIO = (float)( ( 1.0 + Math.sqrt(5.0) )/2.0 );


	/**
	 * Delimiter set of lines.
	 */
	public static char[] DELIMITER_SET = { ' ', '\t', '\n', '\r', '\f', ',' };


	/**
	 * The units of length.
	 */
	public static final String cm = "cm";
	public static final String mm = "mm";
	public static final String pt = "pt";
	public static final String inch = "inch";


	/**
	 * The unit of angle.
	 */
	public static final String degree = "";



	/**
	 * Directory name of resources.
	 */
	public static final String RESOURCES_DIRNAME = "/resources/";



	/**
	 * Font Style
	 */
	public static final String FONT_PLAIN = "Plain";
	public static final String FONT_ITALIC = "Italic";
	public static final String FONT_BOLD = "Bold";
	public static final String FONT_BOLD_ITALIC = "Bold Italic";



	/**
	 * Scale Type
	 */
	public static final String SCALE_TYPE_LINEAR = "Linear";
	public static final String SCALE_TYPE_LOG = "Log";




	/**
	 * Return values from class method
	 */
	public static final int SUCCESSFUL_COMPLETION = 0;
	public static final int PROPERTY_FILE_INCORRECT = 1;
	public static final int DATA_TYPE_INCORRECT = 2;
	public static final int DATA_NUMBER_SHORTAGE = 3;
	public static final int DATA_NUMBER_EXCESS = 4;
	public static final int FILE_OPEN_FAILURE = 5;


	/**
	 * Menu commands
	 */
	public static final String MENUCMD_DELETE = "Delete";
	public static final String MENUCMD_MOVE_TO_FRONT = "Move to Front";
	public static final String MENUCMD_MOVE_TO_BACK = "Move to Back";
	public static final String MENUCMD_PROPERTY = "Property";


}
