/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public class SGAxisBreakSymbol2D
extends SGAxisBreakSymbol
implements SGIDrawingElementJava2D {
    protected Shape mCurve1 = null;
    protected Shape mCurve2 = null;

    public SGAxisBreakSymbol2D() {
    }

    public SGAxisBreakSymbol2D(float f, float f2, float f3, float f4, boolean bl) {
        super(f, f2, f3, f4, bl);
    }

    public boolean contains(int n, int n2) {
        return this.getElementBounds().contains(n, n2);
    }

    public Rectangle2D getElementBounds() {
        if (this.mCurve1 == null || this.mCurve2 == null) {
            return new Rectangle2D.Float();
        }
        return this.getArea().getBounds2D();
    }

    public Area getArea() {
        Shape[] shapeArray = this.getShapeArray();
        Area area = new Area();
        for (int i = 0; i < shapeArray.length; ++i) {
            Area area2 = new Area(shapeArray[i]);
            area.add(area2);
        }
        return area;
    }

    protected CubicCurve2D getBaseCurve() {
        float f = this.getLength();
        float f2 = this.getDistortion() * this.getLength();
        CubicCurve2D.Float float_ = new CubicCurve2D.Float(0.0f, 0.0f, -f2, 0.25f * f, f2, 0.75f * f, 0.0f, f);
        return float_;
    }

    protected boolean create() {
        this.createCurve1();
        this.createCurve2();
        return true;
    }

    protected boolean createCurve1() {
        float f;
        float f2;
        float f3 = this.getX();
        float f4 = this.getY();
        float f5 = this.getLength();
        float f6 = this.getInterval();
        float f7 = (float)Math.sin(this.mAngle);
        float f8 = (float)Math.cos(this.mAngle);
        Shape[] shapeArray = new Shape[4];
        AffineTransform affineTransform = new AffineTransform();
        float f9 = this.mAngle;
        if (this.isForHorizontalAxis()) {
            f2 = f3 - f6 / 2.0f - f5 / 2.0f * f7;
            f = f4 - f5 / 2.0f * f8;
        } else {
            f2 = f3 - f5 / 2.0f * f8;
            f = f4 - f6 / 2.0f + f5 / 2.0f * f7;
            f9 = (float)((double)f9 + 1.5707963267948966);
        }
        affineTransform.translate(f2, f);
        affineTransform.rotate(-f9);
        this.mCurve1 = affineTransform.createTransformedShape(this.getBaseCurve());
        return true;
    }

    protected boolean createCurve2() {
        SGTuple2f sGTuple2f = this.getLocation();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.PI, sGTuple2f.x, sGTuple2f.y);
        this.mCurve2 = affineTransform.createTransformedShape(this.mCurve1);
        return true;
    }

    public Shape[] getShapeArray() {
        if (this.mCurve1 == null || this.mCurve2 == null) {
            return new Shape[0];
        }
        Shape[] shapeArray = new Shape[4];
        Shape shape = this.mCurve1;
        Shape shape2 = this.mCurve2;
        PathIterator pathIterator = shape.getPathIterator(null);
        ArrayList arrayList = SGUtilityJava2D.getSegmentList(pathIterator);
        Point2D point2D = (Point2D)arrayList.get(0);
        Point2D point2D2 = (Point2D)arrayList.get(arrayList.size() - 1);
        PathIterator pathIterator2 = shape2.getPathIterator(null);
        ArrayList arrayList2 = SGUtilityJava2D.getSegmentList(pathIterator2);
        Point2D point2D3 = (Point2D)arrayList2.get(0);
        Point2D point2D4 = (Point2D)arrayList2.get(arrayList2.size() - 1);
        shapeArray[0] = shape;
        shapeArray[1] = new Line2D.Float((float)point2D2.getX(), (float)point2D2.getY(), (float)point2D3.getX(), (float)point2D3.getY());
        shapeArray[2] = shape2;
        shapeArray[3] = new Line2D.Float((float)point2D4.getX(), (float)point2D4.getY(), (float)point2D.getX(), (float)point2D.getY());
        return shapeArray;
    }

    public GeneralPath getConnectedPath() {
        GeneralPath generalPath = new GeneralPath();
        Shape[] shapeArray = this.getShapeArray();
        for (int i = 0; i < shapeArray.length; ++i) {
            generalPath.append(shapeArray[i], true);
        }
        return generalPath;
    }

    public void setLocation(float f, float f2) {
        super.setLocation(f, f2);
        this.create();
    }

    public void setForm(float f, float f2, float f3, float f4, boolean bl) {
        super.setForm(f, f2, f3, f4, bl);
        this.create();
    }

    public boolean zoom(float f) {
        super.zoom(f);
        this.create();
        return true;
    }

    public void drawSymbol(Graphics2D graphics2D) {
        if (this.mCurve1 == null || this.mCurve2 == null) {
            return;
        }
        graphics2D.setPaint(this.getColor(0));
        graphics2D.fill(this.getConnectedPath());
        graphics2D.setPaint(this.getLineColor());
        graphics2D.setStroke(new BasicStroke(this.getLineWidth() * this.getMagnification()));
        graphics2D.draw(this.mCurve1);
        graphics2D.draw(this.mCurve2);
    }

    public Object copy() {
        SGAxisBreakSymbol2D sGAxisBreakSymbol2D = new SGAxisBreakSymbol2D();
        this.setPropertiesForCopy(sGAxisBreakSymbol2D);
        return sGAxisBreakSymbol2D;
    }

    protected boolean setPropertiesForCopy(SGAxisBreakSymbol2D sGAxisBreakSymbol2D) {
        sGAxisBreakSymbol2D.setProperties(this.getProperties());
        sGAxisBreakSymbol2D.setLocation(this.getX(), this.getY());
        sGAxisBreakSymbol2D.setMagnification(this.mMagnification);
        return true;
    }
}

