/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;

public class SGSXYData
extends SGData
implements SGITwoDimensionalData {
    private double[] mXValueArray = null;
    private double[] mYValueArray = null;
    private double[] mLowerErrorArray = null;
    private double[] mUpperErrorArray = null;
    private String[] mStringArray = null;

    public SGSXYData() {
    }

    public SGSXYData(double[] dArray, double[] dArray2, String[] stringArray) {
        this(dArray, dArray2, null, null, stringArray);
    }

    public SGSXYData(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, null, null, null);
    }

    public SGSXYData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String[] stringArray) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("xValueArray==null || yValueArray==null");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("xValueArray.length!=yValueArray.length");
        }
        this.mXValueArray = (double[])dArray.clone();
        this.mYValueArray = (double[])dArray2.clone();
        if (dArray3 != null && dArray4 != null) {
            if (dArray3.length != dArray.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=xValueArray.length");
            }
            if (dArray4.length != dArray.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=xValueArray.length");
            }
            this.mLowerErrorArray = (double[])dArray3.clone();
            this.mUpperErrorArray = (double[])dArray4.clone();
        }
        if (stringArray != null) {
            if (stringArray.length != dArray.length) {
                throw new IllegalArgumentException("stringArray.length!=xValueArray.length");
            }
            this.mStringArray = (String[])stringArray.clone();
        }
    }

    public SGSXYData(SGData sGData) {
        this.setData(sGData);
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYData)) {
            return false;
        }
        SGSXYData sGSXYData = (SGSXYData)sGData;
        this.mXValueArray = sGSXYData.mXValueArray;
        this.mYValueArray = sGSXYData.mYValueArray;
        this.mLowerErrorArray = sGSXYData.mLowerErrorArray;
        this.mUpperErrorArray = sGSXYData.mUpperErrorArray;
        this.mStringArray = sGSXYData.mStringArray;
        return true;
    }

    public int getPointsNumber() {
        return this.mXValueArray.length;
    }

    public double getMinValueX() {
        double d = Double.MAX_VALUE;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.mXValueArray[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueX() {
        double d = -1.7976931348623157E308;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.mXValueArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinValueY() {
        double d = Double.MAX_VALUE;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.mYValueArray[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueY() {
        double d = -1.7976931348623157E308;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.mYValueArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public Double getXValue(int n) {
        return new Double(this.mXValueArray[n]);
    }

    public Double getYValue(int n) {
        return new Double(this.mYValueArray[n]);
    }

    public Double getLowerErrorValue(int n) {
        if (this.isErrorValueHolding()) {
            return new Double(this.mLowerErrorArray[n]);
        }
        return null;
    }

    public Double getUpperErrorValue(int n) {
        if (this.isErrorValueHolding()) {
            return new Double(this.mUpperErrorArray[n]);
        }
        return null;
    }

    public boolean isErrorValueHolding() {
        return this.mLowerErrorArray != null;
    }

    public boolean isStringArrayHolding() {
        return this.mStringArray != null;
    }

    public String getString(int n) {
        if (this.isStringArrayHolding()) {
            return this.mStringArray[n];
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }
}

