/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public class SGPropertyFileChooserWizardDialog
extends SGFileChooserWizardDialog
implements CaretListener {
    public static final String TITLE = "Choose a property file.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JTextField mDataFileNameTextField;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;
    private JButton mShowFileChooserButton;

    public SGPropertyFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGPropertyFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mDataFileNameTextField = new JTextField();
        this.mShowFileChooserButton = new JButton();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new EtchedBorder());
        this.mDataFileNameTextField.setFont(new Font("Dialog", 0, 12));
        this.mDataFileNameTextField.setPreferredSize(new Dimension(250, 21));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mDataFileNameTextField, gridBagConstraints);
        this.mShowFileChooserButton.setFont(new Font("Dialog", 1, 12));
        this.mShowFileChooserButton.setText("Choose");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mShowFileChooserButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mNextButton.setEnabled(false);
        this.mShowFileChooserButton.addActionListener(this);
        this.mDataFileNameTextField.addCaretListener(this);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public String getFileName() {
        return this.mDataFileNameTextField.getText();
    }

    public boolean setFileName(String string) {
        this.mDataFileNameTextField.setText(string);
        return true;
    }

    public File getSelectedFile() {
        File file = new File(this.getFileName());
        return file;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mShowFileChooserButton)) {
            this.showFileChooser();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)object;
            String string = jTextComponent.getText();
            if (string.length() == 0) {
                this.mNextButton.setEnabled(false);
            } else {
                this.mNextButton.setEnabled(true);
            }
        }
    }

    private boolean showFileChooser() {
        ArrayList arrayList = this.openFileChooser();
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() != 1) {
            return true;
        }
        File file = (File)arrayList.get(0);
        boolean bl = this.setFileName(file.getPath());
        this.mNextButton.setEnabled(true);
        PATH_NAME = file.getAbsolutePath();
        return bl;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

