
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.geom.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */

public abstract class SGDrawingElementLine extends SGDrawingElement
{

	/**
	 * 
	 */
	public static final int LINE_TYPE_SOLID = 1;


	/**
	 * 
	 */
	public static final int LINE_TYPE_BROKEN = 2;


	/**
	 * 
	 */
	public static final int LINE_TYPE_DOT = 3;


	/**
	 * 
	 */
	public static final String LINE_NAME_SOLID = "Solid";


	/**
	 * 
	 */
	public static final String LINE_NAME_BROKEN = "Broken";


	/**
	 * 
	 */
	public static final String LINE_NAME_DOT = "Dotted";



	/**
	 *
	 */
	protected SGTuple2f mStart = new SGTuple2f();


	/**
	 *
	 */
	protected SGTuple2f mEnd = new SGTuple2f();


	/**
	 *
	 */
	protected int mLineType;


	/**
	 *
	 */
	protected float mLineWidth;



	/**
	 *
	 */
	public SGDrawingElementLine()
	{
		super();
	}


	/**
	 *
	 */
	public SGDrawingElementLine(
		final SGTuple2f start,
		final SGTuple2f end )
	{
		super();
		this.mStart.setValues( start );
		this.mEnd.setValues( end );
	}


	/**
	 *
	 */
	public SGDrawingElementLine(
		final SGTuple2f start,
		final SGTuple2f end,
		final float lineWidth )
	{
		super();
		this.mStart.setValues( start );
		this.mEnd.setValues( end );
		this.mLineWidth = lineWidth;
	}


	/**
	 * 
	 * @param el
	 */
	public SGDrawingElementLine( final SGDrawingElementLine el )
	{
		super();
		this.mStart.setValues( el.getStart() );
		this.mEnd.setValues( el.getEnd() );
		this.mLineWidth = el.getLineWidth();
		this.mLineType = el.getLineType();
	}



	/**
	 *
	 */
	public boolean setType( final int type )
	{
		this.mLineType = type;
		return true;
	}



	/**
	 *
	 */
	public boolean setTermPoints(
		final float x1, final float y1,
		final float x2, final float y2 )
	{
		this.mStart.setValues( x1, y1 );
		this.mEnd.setValues( x2, y2 );
		return true;
	}


	/**
	 *
	 */
	public boolean setTermPoints(
		final SGTuple2f start, final SGTuple2f end )
	{
		this.mStart = start;
		this.mEnd = end;
		return true;
	}


	/**
	 *
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidth = width;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		this.mLineType = type;
		return true;
	}



	/**
	 * 
	 */
	public SGTuple2f getStart()
	{
		return new SGTuple2f( mStart.x, mStart.y );
	}


	/**
	 * 
	 */
	public SGTuple2f getEnd()
	{
		return new SGTuple2f( mEnd.x, mEnd.y );
	}


	/**
	 *
	 */
	public int getLineType()
	{
		return this.mLineType;
	}


	/**
	 *
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}



	/**
	 * 
	 */
	public static Integer getLineTypeFromName( final String name )
	{

		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGDrawingElementLine.LINE_NAME_SOLID ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_SOLID;
		}
		else if( name.equals( SGDrawingElementLine.LINE_NAME_BROKEN ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_BROKEN;
		}
		else if( name.equals( SGDrawingElementLine.LINE_NAME_DOT ) )
		{
			type = SGDrawingElementLine.LINE_TYPE_DOT;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getLineTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementLine.LINE_TYPE_SOLID :
			{
				name = SGDrawingElementLine.LINE_NAME_SOLID;
				break;
			}

			case SGDrawingElementLine.LINE_TYPE_BROKEN :
			{
				name = SGDrawingElementLine.LINE_NAME_BROKEN;
				break;
			}

			case SGDrawingElementLine.LINE_TYPE_DOT :
			{
				name = SGDrawingElementLine.LINE_NAME_DOT;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementLine) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementLine line = (SGDrawingElementLine)element;

		this.setLineType( line.getLineType() );
		this.setLineWidth( line.getLineWidth() );
	
		return true;
	}




	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		LineProperties p = new LineProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof LineProperties ) == false ) return false;

		super.getProperties(p);

		LineProperties lp = (LineProperties)p;
		lp.setLineWidth( this.getLineWidth() );
		lp.setLineType( this.getLineType() );

		return true;
	}



	public static final String KEY_LINE_WIDTH = "Width";
	public static final String KEY_LINE_TYPE = "Type";
	public static final String PF_LINE_COLOR_LIST = "Color List";


	/**
	 * 
	 */
	public static class LineProperties extends DrawingElementProperties
	{

		public static final String[] keys = {
			KEY_LINE_WIDTH, KEY_LINE_TYPE
		};


		/**
		 *
		 */
		public LineProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof LineProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			LineProperties p = (LineProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Float getLineWidth()
		{
			final String value = this.getProperty(KEY_LINE_WIDTH);
			return SGUtilityText.getFloat(value);
		}


		public Integer getLineType()
		{
			final String value = this.getProperty(KEY_LINE_TYPE);
			return SGUtilityText.getInteger(value);
		}


		public boolean setLineWidth( final float w )
		{
			if( w<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_LINE_WIDTH, new Float(w).toString() );
			return true;
		}

		public boolean setLineType( final int num )
		{
			this.setProperty( KEY_LINE_TYPE, new Integer(num).toString() );
			return true;
		}


	}



}
