/*
 * Created on 2004/06/18
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGWizardDialog extends SGDialog
{

	/**
	 * 
	 */
	public static final String FROM_WIZARD_DIALOG = "from wizard dialog";


	/**
	 * 
	 */
	public static final String PREVIOUS_BUTTON_TEXT = "<Prev";


	/**
	 * 
	 */
	public static final String NEXT_BUTTON_TEXT = "Next>";


	/**
	 * 
	 */
//	protected JButton mOKButton = new JButton(OK_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mPreviousButton = new JButton(PREVIOUS_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mNextButton = new JButton(NEXT_BUTTON_TEXT);

        
	/**
	 * 
	 */
//	protected JButton mCancelButton = new JButton(CANCEL_BUTTON_TEXT);



	/**
	 * 
	 */
	public static String PATH_NAME = "./";






	/**
	 * 
	 */
	private SGWizardDialog mPreviousWizardDialog = null;


	/**
	 * 
	 */
	private SGWizardDialog mNextWizardDialog = null;



	/**
	 * 
	 */
	public SGWizardDialog()
	{
		super();
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner )
	{
		super(owner);
		this.init();
	}



	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title )
	{
		super(owner,title);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final boolean modal )
	{
		super(owner,modal);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title, final boolean modal )
	{
		super(owner,title,modal);
		this.init();
	}



	/**
	 * 
	 * @return
	 */
	private boolean init()
	{
		this.setVisible(false);
		return true;
	}


	/**
	 * 
	 */
	public SGDrawingWindow getOwnerWindow()
	{
		Window owner = this.getOwner();
		SGDrawingWindow wnd = null;
		if( owner instanceof SGDrawingWindow )
		{
			 wnd = (SGDrawingWindow)owner;
		}

//System.out.println("@@@@@@@@@@@@@@@ "+owner);

		return wnd;
	}



	/**
	 * 
	 */
	public SGWizardDialog getPrevious()
	{
		return this.mPreviousWizardDialog;
	}


	/**
	 * 
	 */
	public SGWizardDialog getNext()
	{
		return this.mNextWizardDialog;
	}


	/**
	 * 
	 */
	public boolean setPrevious( final SGWizardDialog dg )
	{
		this.mPreviousWizardDialog = dg;
		return true;
	}


	/**
	 * 
	 */
	public boolean setNext( final SGWizardDialog dg )
	{
		this.mNextWizardDialog = dg;
		return true;
	}



	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
		super.windowClosing(e);

		Object obj = e.getSource();
		if( obj.equals( this ) )
		{
			this.onCanceled();
		}
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();

		AbstractButton btn = (AbstractButton)source;
		if( source.equals( this.getOKButton() ) )
		{
			this.onOK();
		}
		else if( source.equals( this.getCancelButton() ) )
		{
			this.onCanceled();
		}
		else if( source.equals( this.getPreviousButton() ) )
		{
			this.onPrevious();
		}
		else if( source.equals( this.getNextButton() ) )
		{
			this.onNext();
		}

	}




	/**
	 * 
	 */
	protected boolean onOK()
	{
		this.setVisible(false);
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.setVisible(false);
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onPrevious()
	{
		this.setVisible(false);
		this.notifyToListener( PREVIOUS_BUTTON_TEXT );
		SGWizardDialog prev = this.getPrevious();
		prev.setCenter(this);
		prev.setVisible(true);
		return true;
	}


	/**
	 * 
	 */
	protected boolean onNext()
	{
		this.setVisible(false);
		this.notifyToListener( NEXT_BUTTON_TEXT );
		SGWizardDialog next = this.getNext();
		next.setCenter(this);
		next.setVisible(true);
		return true;
	}


	/**
	 * 
	 */
	public void setVisible( final boolean b )
	{

		if( b )
		{
			Object owner = this.getOwner();
			if( owner instanceof Window )
			{
/*				Window wnd = (Window)owner;
//				this.setLocation( wnd.getX(), wnd.getY() );
				Dimension dim = wnd.getSize();
				final int width = this.getWidth();
				final int height = this.getHeight();
				final int x = wnd.getX() + ( dim.width - width )/2;
				final int y = wnd.getY() + ( dim.height - height )/2;
				this.setLocation(x,y);
*/			}
			else
			{
				Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
				final int width = this.getWidth();
				final int height = this.getHeight();
				final int x = ( dim.width - width )/2;
				final int y = ( dim.height - height )/2;
				this.setLocation(x,y);
			}
		}

		super.setVisible(b);
	}



	protected abstract JButton getPreviousButton();


	protected abstract JButton getNextButton();


	protected abstract JButton getOKButton();
	
	
	protected abstract JButton getCancelButton();


}

