/*
 * SGStartupWelcomeDialog.java
 *
 * Created on 2004/10/15, 13:34
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGStartupWelcomeDialog extends SGWizardDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Welcome!";


	/**
	 * 
	 *
	 */
	public SGStartupWelcomeDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}


    /** Creates new form SGStartupWelcomeDialog */
    public SGStartupWelcomeDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mBottomSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mEditorPane = new javax.swing.JEditorPane();
        mMiddleSpaceLabel2 = new javax.swing.JLabel();
        mImagePanel = new jp.riken.brain.ni.samuraigraph.base.SGImagePanel();
        mMiddleSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mTopSpaceLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setModal(true);
        setResizable(false);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.EtchedBorder());
        mBottomSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        mPanel.add(mBottomSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mEditorPane.setEditable(false);
        mEditorPane.setPreferredSize(new java.awt.Dimension(300, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        mPanel.add(mEditorPane, gridBagConstraints);

        mMiddleSpaceLabel2.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        mPanel.add(mMiddleSpaceLabel2, gridBagConstraints);

        mImagePanel.setPreferredSize(new java.awt.Dimension(50, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        mPanel.add(mImagePanel, gridBagConstraints);

        mMiddleSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        mPanel.add(mMiddleSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mTopSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        mPanel.add(mTopSpaceLabel, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mPreviousButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mBottomSpaceLabel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JEditorPane mEditorPane;
    private jp.riken.brain.ni.samuraigraph.base.SGImagePanel mImagePanel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel2;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mTopSpaceLabel;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	private boolean initProperty()
	{

		this.setTitle(TITLE);
		this.mEditorPane.setBackground( this.getContentPane().getBackground() );

		// set the image and the text
		Class inClass = getClass();
		String name = null;
		URL url = null;

		name = SGIConstants.RESOURCES_DIRNAME+"Samurai.gif";
		url = inClass.getResource(name);
		Image image = Toolkit.getDefaultToolkit().getImage( url );
		this.mImagePanel.setImage( image );

		name = SGIConstants.RESOURCES_DIRNAME+"Welcome.html";
		url = inClass.getResource(name);
		try
		{
			this.mEditorPane.setPage( url );
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
		}

		this.pack();

this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}

}
