<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://exslt.org/dates-and-times"
		exclude-result-prefixes="date"
		version="1.0">

<xsl:import href="../../docbook/xsl/html/chunk.xsl"/>

<!-- body attributes -->
<!-- clear default body attributes. it may be defined by css -->
<xsl:template name="body.attributes"></xsl:template>

<!-- Page header -->
<xsl:param name="navig.showtitles" select="0"/>
<xsl:param name="header.rule" select="0"/>
<xsl:template name="user.header.content">
  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="up" select="parent::*"/>
    <h1 id="title">
      <xsl:apply-templates select="." mode="object.title.markup"/>
    </h1>
    <xsl:if test="count($up) > 0 and generate-id($up) != generate-id($home)">
      <span id="subtitle">
        <xsl:apply-templates select="$up" mode="object.title.markup"/>
      </span>
    </xsl:if>
    <hr id="header"/>
</xsl:template>

<!-- Page footer -->
<xsl:template name="footer.navigation">
  <xsl:param name="prev" select="/foo"/>
  <xsl:param name="next" select="/foo"/>
  <xsl:param name="nav.context"/>

  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="up" select="parent::*"/>

  <xsl:variable name="row1" select="count($prev) &gt; 0
                                    or count($up) &gt; 0
                                    or count($next) &gt; 0"/>

  <xsl:variable name="row2" select="($prev and 1 != 0)
                                    or (generate-id($home) != generate-id(.)
                                        or $nav.context = 'toc')
                                    or ($chunk.tocs.and.lots != 0
                                        and $nav.context != 'toc')
                                    or ($next and 1 != 0)"/>

  <xsl:if test="$suppress.navigation = '0' and $suppress.footer.navigation = '0'">
    <div class="navfooter">
      <xsl:if test="$footer.rule != 0">
        <hr/>
      </xsl:if>

      <xsl:if test="$row1 or $row2">
        <table width="100%" summary="Navigation footer">
          <xsl:if test="$row1">
            <tr>
              <td width="40%" align="left">
                <xsl:if test="count($prev)>0">
                  <a accesskey="p">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$prev"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'prev'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
                <xsl:text>&#160;</xsl:text>
              </td>
              <td width="20%" align="center">
                <xsl:choose>
                  <xsl:when test="count($up)>0">
                    <a accesskey="u">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$up"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'up'"/>
                      </xsl:call-template>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>&#160;</xsl:otherwise>
                </xsl:choose>
              </td>
              <td width="40%" align="right">
                <xsl:text>&#160;</xsl:text>
                <xsl:if test="count($next)>0">
                  <a accesskey="n">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$next"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'next'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
              </td>
            </tr>
          </xsl:if>

          <xsl:if test="$row2">
            <tr>
              <td width="40%" align="left" valign="top">
		<div id="navi">
                <xsl:apply-templates select="$prev" mode="object.title.markup"/>
		</div>
                <xsl:text>&#160;</xsl:text>
              </td>
              <td width="20%" align="center">
                <xsl:choose>
                  <xsl:when test="$home != . or $nav.context = 'toc'">
                    <a accesskey="h">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$home"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'home'"/>
                      </xsl:call-template>
                    </a>
                    <xsl:if test="$chunk.tocs.and.lots != 0 and $nav.context !=
'toc'">
                      <xsl:text>&#160;|&#160;</xsl:text>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>&#160;</xsl:otherwise>
                </xsl:choose>

                <xsl:if test="$chunk.tocs.and.lots != 0 and $nav.context != 'toc'">
                  <a accesskey="t">
                    <xsl:attribute name="href">
                      <xsl:apply-templates select="/*[1]"
                                           mode="recursive-chunk-filename"/>
                      <xsl:text>-toc</xsl:text>
                      <xsl:value-of select="$html.ext"/>
                    </xsl:attribute>
                    <xsl:call-template name="gentext">
                      <xsl:with-param name="key" select="'nav-toc'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
              </td>
              <td width="40%" align="right" valign="top">
		<div id="navi">
                <xsl:text>&#160;</xsl:text>
                <xsl:apply-templates select="$next" mode="object.title.markup"/>
		</div>
              </td>
            </tr>
          </xsl:if>
        </table>
      </xsl:if>
    </div>
  </xsl:if>
</xsl:template>

<xsl:template name="user.footer.navigation">
  <div id="copyright">
   <xsl:text>
   Copyright  2004 RIKEN (The Institute of Physical and Chemical Research)
   </xsl:text>
   <br/><xsl:text>All rights reserved.</xsl:text>
   <br/><a href="http://samurai-graph.sourceforge.jp/" target="_blank">http://samurai-graph.sourceforge.jp/</a>
  </div>
  <div id="lastmodified">
    <xsl:text>Last modified: </xsl:text>
    <xsl:call-template name="datetime.format">
      <xsl:with-param name="date" select="date:date-time()"/>
      <xsl:with-param name="format" select="'Y/m/d'"/>
    </xsl:call-template>
  </div>
</xsl:template>

<!-- function explanation -->
<xsl:template match="refname"></xsl:template>
<xsl:template match="refpurpose"><xsl:apply-templates/></xsl:template>

<!-- TopPage Title -->
<xsl:template match="title" mode="titlepage.mode">
  <xsl:variable name="id">
    <xsl:choose>
      <!-- if title is in an *info wrapper, get the grandparent -->
      <xsl:when test="contains(local-name(..), 'info')">
        <xsl:call-template name="object.id">
          <xsl:with-param name="object" select="../.."/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="object.id">
          <xsl:with-param name="object" select=".."/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

<!--  <h1 class="{name(.)}">
    <a name="{$id}"/>
    <xsl:choose>
      <xsl:when test="$show.revisionflag != 0 and @revisionflag">
	<span class="{@revisionflag}">
	  <xsl:apply-templates mode="titlepage.mode"/>
	</span>
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates mode="titlepage.mode"/>
      </xsl:otherwise>
    </xsl:choose>
  </h1> -->
</xsl:template>

<!-- Form of Toc -->
<xsl:template match="refentry" mode="toc">
  <xsl:param name="toc-context" select="."/>

  <xsl:variable name="refmeta" select=".//refmeta"/>
  <xsl:variable name="refentrytitle" select="$refmeta//refentrytitle"/>
  <xsl:variable name="refnamediv" select=".//refnamediv"/>
  <xsl:variable name="refname" select="$refnamediv//refname"/>
  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="$refentrytitle">
        <xsl:apply-templates select="$refentrytitle[1]" mode="titleabbrev.markup"/>
      </xsl:when>
      <xsl:when test="$refname">
        <xsl:apply-templates select="$refname[1]" mode="titleabbrev.markup"/>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:element name="{$toc.listitem.type}">
    <table>
      <tr>
        <th width="140" align="left">
          <a>
            <xsl:attribute name="href">
              <xsl:call-template name="href.target"/>
            </xsl:attribute>
            <xsl:copy-of select="$title"/>
          </a>
        </th>
        <td>
          <xsl:if test="$annotate.toc != 0">
            <xsl:text> - </xsl:text>
            <span class="comment">
              <xsl:value-of select="refnamediv/refpurpose"/>
            </span>
          </xsl:if>
        </td>
      </tr>
    </table>
  </xsl:element>
</xsl:template>

<!-- Text -->
<xsl:param name="local.l10n.xml" select="document('')"/>
<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
  <l:l10n language="ja" english-language-name="Japanese">
    <l:gentext key="Copyright" text="Copyright" lang="en"/>
    <l:gentext key="copyright" text="Copyright" lang="en"/>
    <l:gentext key="RefName" text="&#27231;&#33021;"/>
    <l:gentext key="refname" text="&#27231;&#33021;"/>
    <l:gentext key="RefSynopsisDiv" text="&#24418;&#24335;"/>
    <l:gentext key="refsynopsisdiv" text="&#24418;&#24335;"/>
  </l:l10n>
</l:i18n>

<!-- StyleSheet -->
<xsl:param name="html.stylesheet" select="'../css/style.css'"/>

<xsl:param name="saxon.character.representation" select="'native'"/>
<xsl:param name="root.filename" select="'index'"/>

<!-- HTML -->
<xsl:param name="use.id.as.filename" select="1"/>
<xsl:param name="generate.id.attributes" select="1"/>

<!-- <xsl:param name="suppress.navigation" select="1"/> -->
<xsl:param name="navig.graphics" select="1"/>
<xsl:param name="navig.graphics.path" select="'../images/'"/>
<xsl:param name="navig.graphics.extension" select="'.gif'"/>

<!-- Toc -->
<xsl:param name="generate.section.toc.level" select="0"/>
<xsl:param name="toc.max.depth">0</xsl:param>
<xsl:param name="toc.section.depth" select="0"/>
<xsl:param name="generate.toc">
appendix  toc,title
article/appendix  nop
article   toc,title
book      toc,title,figure,table,example,equation
chapter   toc,title
part      toc,title
preface   toc,title
qandadiv  toc
qandaset  toc
reference toc,title
sect1     toc
sect2     toc
sect3     toc
sect4     toc
sect5     toc
section   toc,title
set       toc,title
</xsl:param>

<!-- Encode -->
<xsl:param name="default.encoding" select="'UTF-8'"/>

<!-- Tables -->
<xsl:param name="html.cellspacing" select="0"/>
<xsl:param name="html.cellpadding" select="3"/>

<!-- Chunking -->
<xsl:param name="chunker.output.encoding" select="'UTF-8'"/>
<xsl:param name="chunk.first.sections" select="1"/>

<!-- Localization -->
<xsl:param name="l10n.gentext.language" select="'ja'"/>
<xsl:param name="l10n.gentext.default.language" select="'ja'"/>

<!-- TeX -->
<xsl:param name="tex.math.in.alt" select="'latex'"/>
<xsl:param name="passivetex.extensions" select="1"/>

</xsl:stylesheet>
