
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */
public abstract class SGDrawingElementSymbol extends SGDrawingElement
{

	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();
	
	
	/**
	 * 
	 */
	protected float mSize;


	/**
	 * 
	 */
	protected int mType;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	protected Color mLineColor;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_VOID = -1;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_CIRCLE = 0;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_SQUARE = 1;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_TRIANGLE = 2;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_INVERTEDTRIANGLE = 3;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_CROSS = 4;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_PLUS = 5;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_TRANSVERSELINE = 6;


	/**
	 * 
	 */
	public static final String SYMBOL_VOID = "No Symbol";

	/**
	 * 
	 */
	public static final String SYMBOL_CIRCLE = "Circle";

	/**
	 * 
	 */
	public static final String SYMBOL_SQUARE = "Square";

	/**
	 * 
	 */
	public static final String SYMBOL_TRIANGLE = "Triangle";

	/**
	 * 
	 */
	public static final String SYMBOL_INVERTED_TRIANGLE = "I-Triangle";

	/**
	 * 
	 */
	public static final String SYMBOL_CROSS = "Cross";

	/**
	 * 
	 */
	public static final String SYMBOL_PLUS = "Plus";

	/**
	 * 
	 */
	public static final String SYMBOL_TRANSVERSELINE = "Transverse Line";



	/**
	 * 
	 */
	public SGDrawingElementSymbol()
	{
		super();
	}



	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mLocation.setValues(x,y);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLocation( final SGTuple2f point )
	{
		this.mLocation = point;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSize( final float size )
	{
		this.mSize = size;
		return true;
	}


	/**
	 * 
	 */
	public boolean setType( final int type )
	{
		this.mType = type;
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		this.mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color color )
	{
		this.mLineColor = color;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		this.mLineWidth = lineWidth;
		return true;
	}


	/**
	 * 
	 */
	public SGTuple2f getLocation()
	{
		return new SGTuple2f( this.mLocation );
	}

	/**
	 * 
	 */
	public float getX()
	{
		return this.mLocation.x;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mLocation.y;
	}



	/**
	 * 
	 */
	public float getSize()
	{
		return this.mSize;
	}


	/**
	 * 
	 */
	public int getType()
	{
		return this.mType;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return this.mAngle;
	}


	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColor;
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}



	/**
	 * 
	 */
	public static Integer getSymbolTypeFromName( final String name )
	{

		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGDrawingElementSymbol.SYMBOL_VOID ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_CIRCLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_SQUARE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_TRIANGLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_INVERTED_TRIANGLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_CROSS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CROSS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_PLUS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_PLUS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_TRANSVERSELINE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getSymbolTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				name = SGDrawingElementSymbol.SYMBOL_VOID;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE :
			{
				name = SGDrawingElementSymbol.SYMBOL_SQUARE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_INVERTED_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CROSS :
			{
				name = SGDrawingElementSymbol.SYMBOL_CROSS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_PLUS :
			{
				name = SGDrawingElementSymbol.SYMBOL_PLUS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				name = SGDrawingElementSymbol.SYMBOL_TRANSVERSELINE;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}




}

