
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */
public abstract class SGDrawingElementBar extends SGDrawingElementRectangle
{

	/**
	 * 
	 */
	protected double mReferenceValue;


	/**
	 * 
	 */
	public SGDrawingElementBar()
	{
		super();
	}


	/**
	 * 
	 */
	public double getReferenceValue()
	{
		return this.mReferenceValue;
	}


	/**
	 * 
	 */
	public boolean setReferenceValue( final double value )
	{
		this.mReferenceValue = value;
		return true;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementBar) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementBar bar = (SGDrawingElementBar)element;
		this.setReferenceValue( bar.getReferenceValue() );

		return true;
	}



}
