
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.awt.Color;


/**
 *
 */

public abstract class SGDrawingElement
{

	/**
	 * zoom̔{
	 */
	protected float mMagnification = 1.0f;


	/**
	 *
	 */
	protected ArrayList mColorList = new ArrayList();



	/**
	 * 
	 */
	protected boolean mVisibleFlag = true;



	/**
	 *
	 */
	public SGDrawingElement()
	{
	}


	/**
	 *
	 */
	public abstract boolean contains( final int x, final int y );



	/**
	 *
	 */
	public boolean zoom( final float ratio )
	{
		this.setMagnification( ratio );
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean isVisible()
	{
		return this.mVisibleFlag;
	}


	/**
	 * 
	 * @param b
	 */
	public void setVisible( final boolean b )
	{
		this.mVisibleFlag = b;
	}



	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		mMagnification = mag;
		return true;
	}



	/**
	 * 
	 */
	public boolean setColorList( final ArrayList colorList )
	{
		mColorList = new ArrayList(colorList);
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		mColorList = new ArrayList();
		mColorList.add(color);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		if( mColorList == null )
		{
			mColorList = new ArrayList();
		}
		mColorList.add(color);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public ArrayList getColorList()
	{
		return mColorList;
	}


	/**
	 * 
	 */
	public Color getColor( final int index )
	{
		if( mColorList == null )
		{
			return null;
		}

		if( index >= mColorList.size() )
		{
			return null;
		}

		return (Color)mColorList.get(index);
	}


	/**
	 * 
	 */
	public float getMagnification()
	{
		return this.mMagnification;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		this.setMagnification( element.getMagnification() );
		this.setColorList( element.getColorList() );

		return true;
	}




	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
//System.out.println("setProperties");

		if( ( p instanceof DrawingElementProperties ) == false ) return false;

		DrawingElementProperties dp = (DrawingElementProperties)p;

		final Boolean b = dp.isVisible();
		if( b==null )
		{
			return false;
		}
		this.setVisible( b.booleanValue() );


		final ArrayList cList = dp.getColorList();
		if( cList==null )
		{
			return false;
		}
		this.setColorList( cList );


		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGProperties getProperties()
	{
		final DrawingElementProperties p = new DrawingElementProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}



	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( final SGProperties p )
	{
		if( ( p instanceof DrawingElementProperties ) == false )
		{
			return false;
		}
		
		final DrawingElementProperties dp = (DrawingElementProperties)p;
		dp.setVisible( this.isVisible() );
		dp.setColorList( this.getColorList() );

		return true;
	}




	public static final String KEY_COLOR_LIST = "Color List";
	public static final String KEY_VISIBLE = "Visible";



	/**
	 * Property of Drawing Element.
	 */
	public static class DrawingElementProperties extends SGProperties
	{

		public static final String[] keys = {
			KEY_VISIBLE, KEY_COLOR_LIST
		};


		/**
		 * 
		 */
		public DrawingElementProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof DrawingElementProperties ) == false )
			{
				return false;
			}

			DrawingElementProperties p = (DrawingElementProperties)obj;

			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Boolean isVisible()
		{
			final String value = this.getProperty(KEY_VISIBLE);
			return SGUtilityText.getBoolean(value);
		}

		public ArrayList getColorList()
		{
			final String value = this.getProperty(KEY_COLOR_LIST);
			return SGUtilityText.getColorList(value);
		}

		public boolean setVisible( final boolean b )
		{
			this.setProperty( KEY_VISIBLE, new Boolean(b).toString() );
			return true;
		}


		public boolean setColor( final Color cl )
		{
			if( cl==null )
			{
				new IllegalArgumentException("cl==null");
			}
			ArrayList list = new ArrayList();
			list.add(cl);
			String str = SGUtilityText.getColorListString(list);
			if( str==null )
			{
				new IllegalArgumentException("str==null");
			}
			this.setProperty( KEY_COLOR_LIST, str );
			return true;
		}

		public boolean setColorList( final ArrayList list )
		{
			if( list==null )
			{
				new IllegalArgumentException("list==null");
			}
			if( list.size()==0 )
			{
				new IllegalArgumentException("list.size()==0");
			}
			String str = SGUtilityText.getColorListString(list);
			if( str==null )
			{
				new IllegalArgumentException("str==null");
			}
			this.setProperty( KEY_COLOR_LIST, str );
			return true;
		}

	}

}
