/*
 * Created on 2004/06/18
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGWizardDialog extends JDialog
	implements ActionListener, WindowListener
{

	/**
	 * 
	 */
	public static final String FROM_WIZARD_DIALOG = "from wizard dialog";


	/**
	 * 
	 */
	public static final String OK_BUTTON_TEXT = "OK";


	/**
	 * 
	 */
	public static final String CANCEL_BUTTON_TEXT = "Cancel";


	/**
	 * 
	 */
	public static final String PREVIOUS_BUTTON_TEXT = "<Previous";


	/**
	 * 
	 */
	public static final String NEXT_BUTTON_TEXT = "Next";


	/**
	 * 
	 */
//	protected JButton mOKButton = new JButton(OK_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mPreviousButton = new JButton(PREVIOUS_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mNextButton = new JButton(NEXT_BUTTON_TEXT);

        
	/**
	 * 
	 */
//	protected JButton mCancelButton = new JButton(CANCEL_BUTTON_TEXT);



	/**
	 * 
	 */
	public static String PATH_NAME = "./";



	/**
	 * 
	 */
	protected ArrayList mActionListenerList = new ArrayList();



	/**
	 * 
	 */
	private SGWizardDialog mPreviousWizardDialog = null;


	/**
	 * 
	 */
	private SGWizardDialog mNextWizardDialog = null;



	/**
	 * 
	 */
	public SGWizardDialog()
	{
		super();
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner )
	{
		super(owner);
		this.init();
	}



	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title )
	{
		super(owner,title);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final boolean modal )
	{
		super(owner,modal);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title, final boolean modal )
	{
		super(owner,title,modal);
		this.init();
	}



	/**
	 * 
	 * @return
	 */
	private boolean init()
	{
		this.addWindowListener(this);
		return true;
	}


	/**
	 * 
	 */
	public SGDrawingWindow getOwnerWindow()
	{
		Window owner = this.getOwner();
		SGDrawingWindow wnd = null;
		if( owner instanceof SGDrawingWindow )
		{
			 wnd = (SGDrawingWindow)owner;
		}

//System.out.println("@@@@@@@@@@@@@@@ "+owner);

		return wnd;
	}



	/**
	 * 
	 */
	public SGWizardDialog getPrevious()
	{
		return this.mPreviousWizardDialog;
	}


	/**
	 * 
	 */
	public SGWizardDialog getNext()
	{
		return this.mNextWizardDialog;
	}


	/**
	 * 
	 */
	public boolean setPrevious( final SGWizardDialog dg )
	{
		this.mPreviousWizardDialog = dg;
		return true;
	}


	/**
	 * 
	 */
	public boolean setNext( final SGWizardDialog dg )
	{
		this.mNextWizardDialog = dg;
		return true;
	}


	/**
	 * 
	 */
	public void addActionListener( final ActionListener listener )
	{
		for( int ii=0; ii<mActionListenerList.size(); ii++ )
		{
			final ActionListener el = (ActionListener)mActionListenerList.get(ii);
			if( el.equals(listener) )
			{
				return;
			}
		}
		mActionListenerList.add(listener);
	}


	/**
	 * 
	 */
	public void removeActionListener( ActionListener listener )
	{
		for( int ii=mActionListenerList.size()-1; ii>=0; ii-- )
		{
			final ActionListener el = (ActionListener)mActionListenerList.get(ii);
			if( el.equals(listener) )
			{
				mActionListenerList.remove(listener);
			}
		}
	}


	/**
	 * 
	 */
	protected void notifyToListener( final String command )
	{
		for( int ii=0; ii<mActionListenerList.size(); ii++ )
		{
			final ActionListener el = (ActionListener)mActionListenerList.get(ii);
			el.actionPerformed( this.getActionEvent( command ) );
		}
	}


	/**
	 * 
	 */
	protected ActionEvent getActionEvent( final String command )
	{
		return new ActionEvent( this, 0, command );
	}



	/**
	 * 
	 */
	public void windowActivated(final WindowEvent e)
	{
//System.out.println("windowActivated");
	}


	/**
	 * 
	 */
	public void windowDeactivated(final WindowEvent e)
	{
//System.out.println("windowDeactivated");
	}


	/**
	 * 
	 */
	public void windowIconified(final WindowEvent e)
	{
//System.out.println("windowIconified");
	}


	/**
	 * 
	 */
	public void windowDeiconified(final WindowEvent e)
	{
//System.out.println("windowDeiconified");
	}


	/**
	 * 
	 */
	public void windowOpened(final WindowEvent e)
	{
//System.out.println("windowOpened");
	}


	/**
	 * 
	 */
	public void windowClosed(final WindowEvent e)
	{
System.out.println("windowClosed");
	}


	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
System.out.println("windowClosing");
		Object obj = e.getSource();
		if( obj.equals( this ) )
		{
			this.onCanceled();
		}
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{

	}



	/**
	 * 
	 */
	protected boolean onOK()
	{
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onPrevious()
	{
		this.notifyToListener( PREVIOUS_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onNext()
	{
		this.notifyToListener( NEXT_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	public void show()
	{
		SGDrawingWindow wnd = (SGDrawingWindow)this.getOwner();
		this.setLocation( wnd.getX(), wnd.getY() );

		super.show();
	}


}
