<?xml version="1.0"?>
<!-- last mod 14 July 2002 mg -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:mml="http://www.w3.org/1998/Math/MathML"
                version="1.0">

<xsl:import href="../../docbook/xsl/fo/docbook.xsl"/>
<!-- <xsl:include href="titlepage.xsl"/> -->

<xsl:strip-space elements="*"/>

<xsl:param name="author.othername.in.middle" select="1"/>
<xsl:param name="body.font.family" select="'Times-Roman'"/>
<xsl:param name="body.font.master" select="11"/>
<xsl:param name="callout.graphics.path" select="'graphics/'"/>
<xsl:param name="chapter.autolabel" select="1"/>
<!-- <xsl:param name="double.sided" select="'1'"/> -->
<xsl:param name="default.table.width" select="'6in'"/>
<xsl:param name="fop.extensions" select="1"/>
<!-- <xsl:param name="generate.book.equation.lot" select="1"/> -->
<!-- <xsl:param name="generate.book.example.lot" select="1"/> -->
<!-- <xsl:param name="generate.book.figure.lot" select="1"/> -->
<!-- <xsl:param name="generate.book.table.lot" select="1"/> -->
<xsl:param name="generate.book.toc" select="1"/>
<xsl:param name="generate.component.toc" select="0"/>
<xsl:param name="generate.division.equation.lot" select="0"/>
<xsl:param name="generate.division.example.lot" select="0"/>
<xsl:param name="generate.division.figure.lot" select="0"/>
<xsl:param name="generate.division.table.lot" select="0"/>
<xsl:param name="generate.division.toc" select="0"/>
<xsl:param name="generate.index" select="1"/>
<xsl:param name="generate.set.toc" select="0"/>
<xsl:param name="graphic.default.extension">png</xsl:param>
<xsl:param name="linenumbering.everyNth" select="5"/>
<xsl:param name="linenumbering.extension" select="1"/>
<xsl:param name="linenumbering.separator" select="' '"/>
<xsl:param name="linenumbering.width" select="3"/>
<xsl:param name="monospace.font.family" select="'Courier'"/>
<xsl:param name="page.margin.bottom">10mm</xsl:param>
<xsl:param name="page.margin.top">10mm</xsl:param>
<xsl:param name="paper.type" select="'A4'"/>
<xsl:param name="passivetex.extensions" select="0"/>
<xsl:param name="region.after.extent" select="'1mm'"/>
<xsl:param name="region.before.extent" select="'1mm'"/>
<xsl:param name="section.autolabel" select="1"/>
<xsl:param name="section.label.includes.component.label" select="1"/>
<xsl:param name="tablecolumns.extension" select="1"/>
<xsl:param name="textinsert.extension" select="1"/>
<xsl:param name="title.font.family" select="'Helvetica'"/>
<xsl:param name="toc.indent.width" select="5"/>
<xsl:param name="ulink.hyphenate" select="''"/>
<xsl:param name="ulink.footnotes" select="0"/>
<xsl:param name="use.extensions" select="1"/>
<xsl:param name="variablelist.as.blocks" select="1"/>

<!-- for bugs or short-comings in DocBook FO's stylesheets -->

<xsl:template match="markup|application">
  <xsl:call-template name="inline.monoseq"/>
</xsl:template>

<!-- just send the MathML all the way through... -->
<xsl:template match="mml:math" priority="5">
  <xsl:variable name="DISPLAY">
    <xsl:choose>
      <xsl:when test="parent::inlineequation">
        <xsl:text>inline</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>display</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:element name="mml:math">
    <xsl:attribute name="display">$DISPLAY</xsl:attribute>
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates select="node()"/>
  </xsl:element>
</xsl:template>

<xsl:template match="pagenums" priority="5"/>

<xsl:template match="processing-instruction()">
  <xsl:copy/>
</xsl:template>

</xsl:stylesheet>
