// Copyright 2000, FreeHEP.
package hep.graphics.heprep.util;

import java.awt.Color;
import org.freehep.swing.ColorConverter;

/**
 * Static class to allow for color manipulation
 *
 * @author M.Donszelmann
 *
 * @version $Id: HepRepColor.java,v 1.1.1.1 2004/05/31 05:08:55 kuromaru Exp $
 */

public class HepRepColor
{
   public static final String cvsId = "$Id: HepRepColor.java,v 1.1.1.1 2004/05/31 05:08:55 kuromaru Exp $";
   
   /**
    * This color is used to tag items which should not be drawn.  Users
    * should test to see if this color is set, and then simply not draw the
    * relevant figures.  Simply drawing with this color will probably not
    * have the desired effect.  This color can be selected only by name. */
   public static final Color invisible = new Color(255,255,255,0);
   private static final ColorConverter cc = new ColorConverter();
   static
   {
      cc.addEntry(invisible, "Invisible");
   }
   
   // not to be instantiated
   private HepRepColor()
   {
   }
   
   /**
    * this method returns a Color. Colors are supposedly immutable
    * and are returned from the same table.
    * The RGBA formats, where Alpha is optional and defaults to 1, are:
    * <pre>
    *      by name:          "yellow"                      , where alpha is always 1.0
    *      by int r,g,b,a:   "128, 255, 64, 255"           , where alpha (a) is optional
    *      by float r,g,b,a: "0.5, 1.0, 0.25, 1.0"         , where alpha (a) is optional
    *      by single number: "64637" or "0x0FFF08"         , where alpha is always 1.0
    * </pre>
    *
    *
    * @param name name/number of the color
    * @return requested Color or defaulting to white in case of a invalid name (message is printed).
    */
   public static final Color get(String name)
   {
      try
      {
         return cc.stringToColor(name);  
      } 
      catch (ColorConverter.ColorConversionException x)
      {
         System.err.println(x.getMessage()+" defaulting to 'white'.");
         return Color.white;
      }
      
   }
   
   public static String get(Color color)
   {
      return cc.colorToString(color);
   }
}
