
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.io.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * 
 */
public abstract class SGTimingElementGroupSet extends SGElementGroupSet
{

	/**
	 * 
	 */
	protected SGAxis mAxis = null;


	/**
	 * 
	 */
	protected SGDouble mValue = null;


	/**
	 * 
	 */
	public SGTimingElementGroupSet()
	{
		super();
	}


	/**
	 * 
	 */
	public abstract boolean addDrawingElementGroup( int type );


	/**
	 * 
	 */
	public abstract boolean addDrawingElementGroup( SGDrawingElement element );



	/**
	 * 
	 */
	public boolean writePropertyOfData( final Writer writer ) throws IOException
	{

		for( int ii=0; ii<this.mDrawingElementGroupList.size(); ii++ )
		{
			final SGElementGroup group = (SGElementGroup)this.mDrawingElementGroupList.get(ii);
			group.writePropertyOfData(writer);
		}

		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		TimingElementGroupSetProperties p = new TimingElementGroupSetProperties();

		if( super.getProperties(p) == false ) return null;

		p.axis = this.mAxis;
		p.value = this.mValue.mValue;

		return p;
	}



	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{

		if( ( p instanceof TimingElementGroupSetProperties ) == false )
		{
			return false;
		}

		TimingElementGroupSetProperties tp = (TimingElementGroupSetProperties)p;

		if( super.setProperties(p) == false ) return false;

		this.mAxis = tp.axis;
		this.mValue.mValue = tp.value;

		return true;

	}




	/**
	 * 
	 */
	public static class TimingElementGroupSetProperties
		extends ElementGroupSetProperties
	{

		SGAxis axis;
		double value;


		/**
		 * 
		 *
		 */
		public TimingElementGroupSetProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof TimingElementGroupSetProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			TimingElementGroupSetProperties p = (TimingElementGroupSetProperties)obj;
			if( p.axis != this.axis ) return false;
			if( p.value != this.value ) return false;

			return true;
		}

	}



}
