
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.*;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */
public abstract class SGDrawingElementString extends SGDrawingElement
{


	/**
	 *
	 */
	protected String mString = new String();


	/**
	 * 
	 */
	protected Font mFont = null;


	/**
	 * 
	 */
	protected String mFontFamilyName;


	/**
	 *
	 */
	protected float mFontSize;


	/**
	 *
	 */
	protected int mFontStyle;


	/**
	 * ̂wW
	 */
	protected float mX;


	/**
	 * ̂xW
	 */
	protected float mY;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	public SGDrawingElementString()
	{
		super();
	}


	/**
	 * 
	 */
	public SGDrawingElementString( final String str )
	{
		super();
		mString = new String( str );
	}


	/**
	 * 
	 */
	public SGDrawingElementString(
		final SGDrawingElementString element )
	{
		super();
		this.mMagnification = element.mMagnification;
		this.mString = new String( element.mString );
		this.setFont( element.getFontFamilyName(), element.getFontStyle(), element.getFontSize() );
		this.mX = element.mX;
		this.mY = element.mY;
		this.mAngle = element.mAngle;
		this.mColorList = new ArrayList( element.mColorList );
	}


	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final String fontFamilyName,
		final int fontStyle,
		final float fontSize )
	{
		super();
		this.mString = new String( str );
		this.setFont( fontFamilyName, fontStyle, fontSize );
	}
	

	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final String fontFamilyName,
		final int fontStyle,
		final float fontSize,
		final float x,
		final float y )
	{
		super();
		this.mString = new String( str );
		this.setFont( fontFamilyName, fontStyle, fontSize );
		this.mX = x;
		this.mY = y;
	}



	/**
	 * 
	 */
	public String toString()
	{
		return this.mString;
	}



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		this.mFontFamilyName = name;
		this.mFontStyle = style;
		this.mFontSize = size;

		this.mFont = new Font(
			this.mFontFamilyName,
			this.mFontStyle,
			(int)(this.mMagnification*this.mFontSize)
		);

		return true;
	}


	/**
	 *
	 */
	public boolean setString( final String str )
	{
		mString = str;
		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		super.setMagnification( mag );
		this.setFont( this.mFontFamilyName, this.mFontStyle, this.mFontSize );
		return true;
	}


	/**
	 *
	 */
	public String getString()
	{
		return mString;
	}



	/**
	 *
	 */
	public float getX()
	{
		return this.getLocation().x;
	}


	/**
	 *
	 */
	public float getY()
	{
		return this.getLocation().y;
	}



	/**
	 * 
	 * @return
	 */
	public SGTuple2f getLocation()
	{
		return new SGTuple2f( this.mX, this.mY );
	}



	/**
	 *
	 */
	public float getFontSize()
	{
		return mFontSize;
	}


	/**
	 *
	 */
	public int getFontStyle()
	{
		return mFontStyle;
	}



	/**
	 * 
	 * @param pos
	 * @return
	 */
	public boolean setLocation( final SGTuple2f pos )
	{
		if( pos==null )
		{
			throw new IllegalArgumentException("pos==null");
		}
		this.setLocation( pos.x, pos.y );
		return true;
	}



	/**
	 *
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mX = x;
		this.mY = y;
		return true;
	}



	/**
	 * 
	 */
	public boolean setX( final float x )
	{
		this.setLocation( x, this.getY() );
		return true;
	}


	/**
	 * 
	 */
	public boolean setY( final float y )
	{
		this.setLocation( this.getX(), y );
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return mAngle;
	}


	/**
	 * 
	 * @return
	 */
	public String getFontFamilyName()
	{
		return mFontFamilyName;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementString) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementString el = (SGDrawingElementString)element;

		this.setFont( el.getFontFamilyName(), el.getFontStyle(), el.getFontSize() );
//		this.setFontFamilyName( el.getFontFamilyName() );
//		this.setFontSize( el.getFontSize() );
//		this.setFontStyle( el.getFontStyle() );
		this.setAngle( el.getAngle() );

		return true;
	}



	/**
	 * 
	 * @param dx
	 * @param dy
	 * @return
	 */
	public boolean translate( final float dx, final float dy )
	{
		this.setLocation( this.getX() + dx, this.getY() + dy );
		return true;
	}



}
