/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement;

public class SGLegendDialog
extends SGPropertyDialog {
    public static final String TITLE = "Legend Dialog";
    private JButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBackgroundLabel;
    private JCheckBox mBackgroundTransparentCheckBox;
    private JButton mCancelButton;
    private JComboBox mFontFamilyNameComboBox;
    private JLabel mFontLabel;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFrameLabel;
    private JButton mFrameLineColorButton;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private JSeparator mFrameSeparator;
    private JCheckBox mFrameVisibleCheckBox;
    private JLabel mLabelSpace1;
    private JLabel mLeftSpaceLabel;
    private JPanel mLegendPanel;
    private JCheckBox mLegendVisibleCheckBox;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JButton mStringColorButton;
    private JLabel mStringColorLabel;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JPanel mlButtonPanel;

    public SGLegendDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mLabelSpace1 = new JLabel();
        this.mLegendPanel = new JPanel();
        this.mLegendVisibleCheckBox = new JCheckBox();
        this.mFrameVisibleCheckBox = new JCheckBox();
        this.mFrameLabel = new JLabel();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mBackgroundColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameLineColorButton = new JButton();
        this.mFrameSeparator = new JSeparator();
        this.mBackgroundColorButton = new JButton();
        this.mFontLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mStringColorLabel = new JLabel();
        this.mFontFamilyNameComboBox = new JComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontStyleComboBox = new JComboBox();
        this.mStringColorButton = new JButton();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBackgroundLabel = new JLabel();
        this.mBackgroundTransparentCheckBox = new JCheckBox();
        this.mlButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mLabelSpace1.setText("  ");
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGLegendDialog.this.closeDialog(windowEvent);
            }
        });
        this.mLegendPanel.setLayout(new GridBagLayout());
        this.mLegendPanel.setBorder(new BevelBorder(0));
        this.mLegendPanel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLegendVisibleCheckBox.setText("Visible");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.mLegendPanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameSeparator, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mFontLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mStringColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mStringColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorLabel, gridBagConstraints);
        this.mFontFamilyNameComboBox.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyNameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGLegendDialog.this.mFontFamilyNameComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontFamilyNameComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setMinimumSize(new Dimension(25, 20));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mStringColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorButton, gridBagConstraints);
        this.mStringLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mLegendPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        this.mBackgroundTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        gridBagConstraints.anchor = 17;
        this.mLegendPanel.add((Component)this.mBackgroundTransparentCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mLegendPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mlButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mlButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mlButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mlButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void mFontFamilyNameComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        new SGLegendDialog((Frame)new JFrame(), true).show();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontFamilyNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mFrameLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mStringColorButton.addActionListener(this);
        this.mFrameLineColorButton.addActionListener(this);
        this.mBackgroundColorButton.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mBackgroundTransparentCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mFrameLineColorButton;
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mLegendVisibleCheckBox)) {
            this.setLegendVisible(this.mLegendVisibleCheckBox.isSelected());
        } else if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameComponentsEnabled(this.mFrameVisibleCheckBox.isSelected());
        } else if (object.equals(this.mBackgroundTransparentCheckBox)) {
            this.setBackgroundComponentsEnabled(!this.mBackgroundTransparentCheckBox.isSelected());
        }
    }

    private boolean setAllLegendComponentsEnabled(boolean bl) {
        this.mStringLabel.setEnabled(bl);
        this.setStringComponentsEnabled(bl);
        this.mFrameLabel.setEnabled(bl);
        this.mFrameVisibleCheckBox.setEnabled(bl);
        boolean bl2 = this.mFrameVisibleCheckBox.isSelected();
        this.setFrameComponentsEnabled(bl & bl2);
        this.mBackgroundLabel.setEnabled(bl);
        this.mBackgroundTransparentCheckBox.setEnabled(bl);
        boolean bl3 = !this.mBackgroundTransparentCheckBox.isSelected();
        this.setBackgroundComponentsEnabled(bl & bl3);
        return true;
    }

    private boolean setStringComponentsEnabled(boolean bl) {
        this.mFontLabel.setEnabled(bl);
        this.mFontFamilyNameComboBox.setEnabled(bl);
        this.mFontStyleComboBox.setEnabled(bl);
        this.mFontSizeLabel.setEnabled(bl);
        this.mFontSizeSpinner.setEnabled(bl);
        this.mStringColorLabel.setEnabled(bl);
        this.mStringColorButton.setEnabled(bl);
        return true;
    }

    private boolean setFrameComponentsEnabled(boolean bl) {
        this.mFrameLineWidthLabel.setEnabled(bl);
        this.mFrameLineWidthSpinner.setEnabled(bl);
        this.mFrameLineColorLabel.setEnabled(bl);
        this.mFrameLineColorButton.setEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(boolean bl) {
        this.mBackgroundColorLabel.setEnabled(bl);
        this.mBackgroundColorButton.setEnabled(bl);
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.isSelected();
    }

    public boolean getFrameVisible() {
        return this.mFrameVisibleCheckBox.isSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColorButton.getBackground();
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColorButton.getBackground();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontFamilyName() {
        return (String)this.mFontFamilyNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mStringColorButton.getBackground();
    }

    public boolean isLegendTransparent() {
        return this.mBackgroundTransparentCheckBox.isSelected();
    }

    public boolean setLegendVisible(boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        this.setAllLegendComponentsEnabled(bl);
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        this.setFrameComponentsEnabled(bl);
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidthSpinner.setValue(new Float(f));
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColorButton.setBackground(color);
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColorButton.setBackground(color);
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.mFontFamilyNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColor(Color color) {
        this.mStringColorButton.setBackground(color);
        return true;
    }

    public boolean setLegendTransparent(boolean bl) {
        this.mBackgroundTransparentCheckBox.setSelected(bl);
        this.setBackgroundComponentsEnabled(!bl);
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mFrameLineColorButton);
        arrayList.add(this.mStringColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        return arrayList;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGLegendElement.LegendCommonProperties getCommonProperties() {
        SGLegendElement.LegendCommonProperties legendCommonProperties = new SGLegendElement.LegendCommonProperties();
        legendCommonProperties.visible = this.getLegendVisible();
        legendCommonProperties.frameLineVisible = this.getFrameVisible();
        Number number = this.getFrameLineWidth();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        legendCommonProperties.frameLineWidth = number.floatValue();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isLegendTransparent();
        legendCommonProperties.fontFamilyName = this.getFontFamilyName();
        Number number2 = this.getFontSize();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        legendCommonProperties.fontSize = number2.floatValue();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getTextColor();
        return legendCommonProperties;
    }
}

