/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;

public class SGDrawingElementString2DExtended
extends SGDrawingElementString2D {
    protected ArrayList mBaseElementList;
    protected ArrayList mSubscriptElementList;
    protected ArrayList mSuperscriptElementList;

    public SGDrawingElementString2DExtended() {
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string) {
        super(string);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f) {
        super(string, string2, n, f);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f, float f2, float f3) {
        super(string, string2, n, f, f2, f3);
        this.createStringElements();
    }

    public boolean containsSuperscripts() {
        return this.mString.indexOf("^") != -1;
    }

    public boolean containsSubscripts() {
        return this.mString.indexOf("_") != -1;
    }

    public boolean containsSubscriptsOfSuperscripts() {
        return this.containsSubscripts() || this.containsSuperscripts();
    }

    public boolean setMagnification(float f) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        super.setMagnification(f);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.setMagnification(f);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setMagnification(f);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setMagnification(f);
        }
        this.updateDrawingElements();
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        super.setColorList(arrayList);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.setColorList(arrayList);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setColorList(arrayList);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setColorList(arrayList);
        }
        return true;
    }

    public boolean setColor(Color color) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        super.setColor(color);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.setColor(color);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setColor(color);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setColor(color);
        }
        return true;
    }

    public boolean addColor(Color color) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        super.addColor(color);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.addColor(color);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.addColor(color);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.addColor(color);
        }
        return true;
    }

    public boolean setLocation(float f, float f2) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        float f3 = f - this.getX();
        float f4 = f2 - this.getY();
        super.setLocation(f, f2);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.translate(f3, f4);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.translate(f3, f4);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.translate(f3, f4);
        }
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        SGDrawingElementString sGDrawingElementString;
        int n2;
        super.setFont(string, n, f);
        if (this.mBaseElementList == null) {
            this.mBaseElementList = new ArrayList();
            this.mSubscriptElementList = new ArrayList();
            this.mSuperscriptElementList = new ArrayList();
            return true;
        }
        for (n2 = 0; n2 < this.mBaseElementList.size(); ++n2) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n2);
            sGDrawingElementString.setFont(string, n, f);
        }
        for (n2 = 0; n2 < this.mSubscriptElementList.size(); ++n2) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n2);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setFont(string, n, f / 2.0f);
        }
        for (n2 = 0; n2 < this.mSuperscriptElementList.size(); ++n2) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n2);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setFont(string, n, f / 2.0f);
        }
        this.updateDrawingElements();
        return true;
    }

    public boolean setString(String string) {
        super.setString(string);
        this.createStringElements();
        this.updateDrawingElements();
        return true;
    }

    public boolean setAngle(float f) {
        SGDrawingElementString sGDrawingElementString;
        int n;
        super.setAngle(f);
        for (n = 0; n < this.mBaseElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
            sGDrawingElementString.setAngle(f);
        }
        for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setAngle(f);
        }
        for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
            sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setAngle(f);
        }
        this.updateDrawingElements();
        return true;
    }

    private boolean createStringElementsDirectly() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D(this.mString);
        this.mBaseElementList.add(sGDrawingElementString2D);
        this.mSubscriptElementList.add(null);
        this.mSuperscriptElementList.add(null);
        this.setPropertiesToAllStringElements();
        return true;
    }

    private boolean createStringElements() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        if (this.mBaseElementList == null) {
            this.mBaseElementList = new ArrayList();
            this.mSubscriptElementList = new ArrayList();
            this.mSuperscriptElementList = new ArrayList();
        } else {
            this.mBaseElementList.clear();
            this.mSubscriptElementList.clear();
            this.mSuperscriptElementList.clear();
        }
        if (!this.containsSubscriptsOfSuperscripts()) {
            return this.createStringElementsDirectly();
        }
        String string = this.getString();
        if (!SGUtilityText.getSubscriptAndSuperscriptInfo(string, arrayList3 = new ArrayList(), arrayList2 = new ArrayList(), arrayList = new ArrayList())) {
            return this.createStringElementsDirectly();
        }
        if (arrayList3.size() != arrayList2.size() || arrayList2.size() != arrayList.size()) {
            return this.createStringElementsDirectly();
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            Character c = (Character)arrayList3.get(i);
            Object object = new char[]{c.charValue()};
            Object object2 = new String((char[])object);
            SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D((String)object2);
            this.mBaseElementList.add(sGDrawingElementString2D);
            c = arrayList.get(i);
            if (c != null) {
                object = (String)((Object)c);
                object2 = new SGDrawingElementString2DExtended((String)object);
                this.mSubscriptElementList.add(object2);
            } else {
                this.mSubscriptElementList.add(null);
            }
            object = arrayList2.get(i);
            if (object != null) {
                object2 = (String)object;
                sGDrawingElementString2D = new SGDrawingElementString2DExtended((String)object2);
                this.mSuperscriptElementList.add(sGDrawingElementString2D);
                continue;
            }
            this.mSuperscriptElementList.add(null);
        }
        this.setPropertiesToAllStringElements();
        return true;
    }

    public boolean setPropertiesToAllStringElements() {
        float f = this.getMagnification();
        ArrayList arrayList = this.getColorList();
        float f2 = this.getFontSize();
        String string = this.getFontFamilyName();
        int n = this.getFontStyle();
        float f3 = this.getAngle();
        for (int i = 0; i < this.mBaseElementList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2;
            SGDrawingElementString2D sGDrawingElementString2D3 = (SGDrawingElementString2D)this.mBaseElementList.get(i);
            sGDrawingElementString2D3.setMagnification(f);
            sGDrawingElementString2D3.setColorList(arrayList);
            sGDrawingElementString2D3.setFont(string, n, f2);
            sGDrawingElementString2D3.setAngle(f3);
            sGDrawingElementString2D3 = this.mSubscriptElementList.get(i);
            if (sGDrawingElementString2D3 != null) {
                sGDrawingElementString2D2 = sGDrawingElementString2D3;
                sGDrawingElementString2D2.setMagnification(f);
                sGDrawingElementString2D2.setColorList(arrayList);
                sGDrawingElementString2D2.setFont(string, n, f2 / 2.0f);
                sGDrawingElementString2D2.setAngle(f3);
                if (sGDrawingElementString2D2 instanceof SGDrawingElementString2DExtended) {
                    sGDrawingElementString2D = (SGDrawingElementString2DExtended)sGDrawingElementString2D2;
                    ((SGDrawingElementString2DExtended)sGDrawingElementString2D).setPropertiesToAllStringElements();
                }
            }
            if ((sGDrawingElementString2D2 = this.mSuperscriptElementList.get(i)) == null) continue;
            sGDrawingElementString2D = sGDrawingElementString2D2;
            sGDrawingElementString2D.setMagnification(f);
            sGDrawingElementString2D.setColorList(arrayList);
            sGDrawingElementString2D.setFont(string, n, f2 / 2.0f);
            sGDrawingElementString2D.setAngle(f3);
            if (!(sGDrawingElementString2D instanceof SGDrawingElementString2DExtended)) continue;
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
            sGDrawingElementString2DExtended.setPropertiesToAllStringElements();
        }
        return true;
    }

    public Rectangle2D getStringRect() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.mBaseElementList.size(); ++i) {
            Object object;
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mBaseElementList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
            f += (float)rectangle2D.getWidth();
            f2 = (float)rectangle2D.getHeight();
            sGDrawingElementString2D = this.mSubscriptElementList.get(i);
            float f3 = 0.0f;
            if (sGDrawingElementString2D != null) {
                object = (SGDrawingElementString2D)this.mSubscriptElementList.get(i);
                Rectangle2D rectangle2D2 = ((SGDrawingElementString2D)object).getStringRect();
                f3 += (float)rectangle2D2.getWidth();
            }
            object = this.mSuperscriptElementList.get(i);
            float f4 = 0.0f;
            if (object != null) {
                SGDrawingElementString2D sGDrawingElementString2D2 = (SGDrawingElementString2D)this.mSuperscriptElementList.get(i);
                Rectangle2D rectangle2D3 = sGDrawingElementString2D2.getStringRect();
                f4 += (float)rectangle2D3.getWidth();
            }
            if (object == null && sGDrawingElementString2D == null) continue;
            f += Math.max(f4, f3);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mBaseElementList.size(); ++i) {
            Object object;
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mBaseElementList.get(i);
            arrayList.add(sGDrawingElementString2D.getElementBounds());
            sGDrawingElementString2D = this.mSubscriptElementList.get(i);
            if (sGDrawingElementString2D != null) {
                object = (SGDrawingElementString2D)this.mSubscriptElementList.get(i);
                arrayList.add(((SGDrawingElementString2D)object).getElementBounds());
            }
            if ((object = this.mSuperscriptElementList.get(i)) == null) continue;
            SGDrawingElementString2D sGDrawingElementString2D2 = (SGDrawingElementString2D)this.mSuperscriptElementList.get(i);
            arrayList.add(sGDrawingElementString2D2.getElementBounds());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public boolean updateDrawingElements() {
        float f = this.getAngle();
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = 0.0f;
        for (int i = 0; i < this.mBaseElementList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2;
            SGDrawingElementString2D sGDrawingElementString2D3 = (SGDrawingElementString2D)this.mBaseElementList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D3.getStringRect();
            sGDrawingElementString2D3.setLocation(f4 + f6 * f2, f5 - f6 * f3);
            f6 += (float)rectangle2D.getWidth();
            sGDrawingElementString2D3 = this.mSuperscriptElementList.get(i);
            float f7 = 0.0f;
            if (sGDrawingElementString2D3 != null) {
                sGDrawingElementString2D2 = sGDrawingElementString2D3;
                Rectangle2D rectangle2D2 = sGDrawingElementString2D2.getStringRect();
                sGDrawingElementString2D2.setLocation(f4 + f6 * f2, f5 - f6 * f3);
                if (sGDrawingElementString2D2 instanceof SGDrawingElementString2DExtended) {
                    sGDrawingElementString2D = (SGDrawingElementString2DExtended)sGDrawingElementString2D2;
                    ((SGDrawingElementString2DExtended)sGDrawingElementString2D).updateDrawingElements();
                }
                f7 += (float)rectangle2D2.getWidth();
            }
            sGDrawingElementString2D2 = this.mSubscriptElementList.get(i);
            float f8 = 0.0f;
            if (sGDrawingElementString2D2 != null) {
                sGDrawingElementString2D = sGDrawingElementString2D2;
                Rectangle2D rectangle2D3 = sGDrawingElementString2D.getStringRect();
                float f9 = (float)rectangle2D3.getHeight();
                sGDrawingElementString2D.setLocation(f4 + f6 * f2 + f9 * f3, f5 - f6 * f3 + f9 * f2);
                if (sGDrawingElementString2D instanceof SGDrawingElementString2DExtended) {
                    SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
                    sGDrawingElementString2DExtended.updateDrawingElements();
                }
                f8 += (float)rectangle2D3.getWidth();
            }
            if (sGDrawingElementString2D3 == null && sGDrawingElementString2D2 == null) continue;
            f6 += Math.max(f7, f8);
        }
        return true;
    }

    public boolean drawString(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        if (!this.isVisible()) {
            return true;
        }
        for (int i = 0; i < this.mBaseElementList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2 = (SGDrawingElementString2D)this.mBaseElementList.get(i);
            sGDrawingElementString2D2.drawString(graphics2D);
            sGDrawingElementString2D2 = this.mSubscriptElementList.get(i);
            if (sGDrawingElementString2D2 != null) {
                sGDrawingElementString2D = sGDrawingElementString2D2;
                sGDrawingElementString2D.drawString(graphics2D);
            }
            if ((sGDrawingElementString2D = this.mSuperscriptElementList.get(i)) == null) continue;
            SGDrawingElementString2D sGDrawingElementString2D3 = sGDrawingElementString2D;
            sGDrawingElementString2D3.drawString(graphics2D);
        }
        return true;
    }
}

