/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGAxisBreakingSymbol
extends SGDrawingElement {
    public static final String KEY_TITLE = "[Axis Break]";
    public static final String KEY_X = "X";
    public static final String KEY_Y = "Y";
    public static final String KEY_LENGTH = "Length";
    public static final String KEY_INTERVAL = "Interval";
    public static final String KEY_DISTORTION = "Distortion";
    public static final String KEY_ANGLE = "Angle";
    public static final String KEY_HORIZONTAL = "Horizontal";
    public static final String KEY_LINE_WIDTH = "Line Width";
    public static final String KEY_INNER_COLOR = "Inner Color";
    public static final String KEY_LINE_COLOR = "Line Color";
    protected SGTuple2f mLocation = new SGTuple2f();
    protected float mLength;
    protected float mInterval;
    protected float mLineWidth;
    protected float mAngle;
    protected float mDistortion;
    protected Color mLineColor;
    protected boolean mForHorizontalAxisFlag;
    public static final float ANGLE_ABS_MAX = 1.0471976f;

    public SGAxisBreakingSymbol() {
    }

    protected SGAxisBreakingSymbol(float f, float f2, float f3, float f4, boolean bl) {
        this.setLength(f);
        this.setInterval(f2);
        this.setDistortion(f3);
        this.setAngle(f4);
        this.setForHorizontalAxisFlag(bl);
    }

    public SGTuple2f getLocation() {
        return this.mLocation;
    }

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public float getLength() {
        return this.mLength * this.mMagnification;
    }

    public float getInterval() {
        return this.mInterval * this.mMagnification;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public float getDistortion() {
        return this.mDistortion;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean isForHorizontalAxis() {
        return this.mForHorizontalAxisFlag;
    }

    public void setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
    }

    public void setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
    }

    public void setForm(float f, float f2, float f3, float f4, boolean bl) {
        this.setLength(f);
        this.setInterval(f2);
        this.setDistortion(f3);
        this.setAngle(f4);
        this.setForHorizontalAxisFlag(bl);
    }

    public void setLength(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLength = f / this.mMagnification;
    }

    public void setInterval(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mInterval = f / this.mMagnification;
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLineWidth = f;
    }

    public void setAngle(float f) {
        float f2 = f;
        if (f2 < -1.0471976f) {
            f2 = -1.0471976f;
        }
        if (1.0471976f < f2) {
            f2 = 1.0471976f;
        }
        this.mAngle = f2;
    }

    public void setDistortion(float f) {
        this.mDistortion = f;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            new IllegalArgumentException("color==null");
        }
        this.mLineColor = color;
    }

    public void setForHorizontalAxisFlag(boolean bl) {
        this.mForHorizontalAxisFlag = bl;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGAxisBreakingSymbol)) {
            return false;
        }
        super.setProperty(sGDrawingElement);
        SGAxisBreakingSymbol sGAxisBreakingSymbol = (SGAxisBreakingSymbol)sGDrawingElement;
        this.setLocation(sGAxisBreakingSymbol.getX(), sGAxisBreakingSymbol.getY());
        this.setLength(sGAxisBreakingSymbol.getLength());
        this.setInterval(sGAxisBreakingSymbol.getInterval());
        this.setDistortion(sGAxisBreakingSymbol.getDistortion());
        this.setAngle(sGAxisBreakingSymbol.getAngle());
        this.setForHorizontalAxisFlag(sGAxisBreakingSymbol.isForHorizontalAxis());
        this.setLineWidth(sGAxisBreakingSymbol.getLineWidth());
        this.setLineColor(sGAxisBreakingSymbol.getLineColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        Float f = axisBreakSymbolProperties.getX();
        if (f == null) {
            return false;
        }
        Float f2 = axisBreakSymbolProperties.getY();
        if (f2 == null) {
            return false;
        }
        this.mLocation = new SGTuple2f(f.floatValue(), f2.floatValue());
        Float f3 = axisBreakSymbolProperties.getLength();
        if (f3 == null) {
            return false;
        }
        this.mLength = f3.floatValue();
        Float f4 = axisBreakSymbolProperties.getInterval();
        if (f4 == null) {
            return false;
        }
        this.mInterval = f4.floatValue();
        Float f5 = axisBreakSymbolProperties.getDistortion();
        if (f5 == null) {
            return false;
        }
        this.mDistortion = f5.floatValue();
        Float f6 = axisBreakSymbolProperties.getAngle();
        if (f6 == null) {
            return false;
        }
        this.mAngle = f6.floatValue();
        Boolean bl = axisBreakSymbolProperties.isHorizontal();
        if (bl == null) {
            return false;
        }
        this.mForHorizontalAxisFlag = bl;
        Float f7 = axisBreakSymbolProperties.getLineWidth();
        if (f7 == null) {
            return false;
        }
        this.mLineWidth = f7.floatValue();
        Color color = axisBreakSymbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.mLineColor = color;
        return true;
    }

    public SGProperties getProperties() {
        AxisBreakSymbolProperties axisBreakSymbolProperties = new AxisBreakSymbolProperties();
        if (!this.getProperties(axisBreakSymbolProperties)) {
            return null;
        }
        return axisBreakSymbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        axisBreakSymbolProperties.setX(this.mLocation.x);
        axisBreakSymbolProperties.setY(this.mLocation.y);
        axisBreakSymbolProperties.setLength(this.mLength);
        axisBreakSymbolProperties.setInterval(this.mInterval);
        axisBreakSymbolProperties.setDistortion(this.mDistortion);
        axisBreakSymbolProperties.setAngle(this.mAngle);
        axisBreakSymbolProperties.setHorizontal(this.mForHorizontalAxisFlag);
        axisBreakSymbolProperties.setLineWidth(this.mLineWidth);
        axisBreakSymbolProperties.setLineColor(this.mLineColor);
        return true;
    }

    public static class AxisBreakSymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        public static final String[] keys = new String[]{"X", "Y", "Length", "Interval", "Distortion", "Angle", "Line Width", "Line Color"};

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(axisBreakSymbolProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getX() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_X);
            return SGUtilityText.getFloat(string);
        }

        public Float getY() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_Y);
            return SGUtilityText.getFloat(string);
        }

        public Float getLength() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_LENGTH);
            return SGUtilityText.getFloat(string);
        }

        public Float getInterval() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_INTERVAL);
            return SGUtilityText.getFloat(string);
        }

        public Float getDistortion() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_DISTORTION);
            return SGUtilityText.getFloat(string);
        }

        public Float getAngle() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_ANGLE);
            return SGUtilityText.getFloat(string);
        }

        public Boolean isHorizontal() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_HORIZONTAL);
            return SGUtilityText.getBoolean(string);
        }

        public Float getLineWidth() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Color getLineColor() {
            String string = this.getProperty(SGAxisBreakingSymbol.KEY_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public boolean setX(float f) {
            this.setProperty(SGAxisBreakingSymbol.KEY_X, new Float(f).toString());
            return true;
        }

        public boolean setY(float f) {
            this.setProperty(SGAxisBreakingSymbol.KEY_Y, new Float(f).toString());
            return true;
        }

        public boolean setLength(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_LENGTH, new Float(f).toString());
            return true;
        }

        public boolean setInterval(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_INTERVAL, new Float(f).toString());
            return true;
        }

        public boolean setDistortion(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_DISTORTION, new Float(f).toString());
            return true;
        }

        public boolean setAngle(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_ANGLE, new Float(f).toString());
            return true;
        }

        public boolean setHorizontal(boolean bl) {
            this.setProperty(SGAxisBreakingSymbol.KEY_HORIZONTAL, new Boolean(bl).toString());
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setLineColor(Color color) {
            String string;
            if (color == null) {
                new IllegalArgumentException("cl==null");
            }
            if ((string = SGUtilityText.getColorString(color)) == null) {
                new IllegalArgumentException("str==null");
            }
            this.setProperty(SGAxisBreakingSymbol.KEY_LINE_COLOR, string);
            return true;
        }
    }
}

