/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakingSymbol;

public class SGAxisBreakSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Axis Break Symbol";
    private JLabel mAngleLabel;
    private SGSpinner mAngleSpinner;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private JLabel mDistortionLabel;
    private SGSpinner mDistortionSpinner;
    private JLabel mFormLabel;
    private JSeparator mFormSeparator;
    private JRadioButton mHorizontalRadioButton;
    private JButton mInnerColorButton;
    private JLabel mInnerColorLabel;
    private JLabel mIntervalLabel;
    private SGSpinner mIntervalSpinner;
    private JLabel mLeftSpaceLabel;
    private JLabel mLengthLabel;
    private SGSpinner mLengthSpinner;
    private JButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JRadioButton mVerticalRadioButton;

    public SGAxisBreakSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mPanel = new JPanel();
        this.mDistortionLabel = new JLabel();
        this.mAngleLabel = new JLabel();
        this.mDistortionSpinner = new SGSpinner();
        this.mAngleSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mFormLabel = new JLabel();
        this.mLengthLabel = new JLabel();
        this.mLengthSpinner = new SGSpinner();
        this.mIntervalLabel = new JLabel();
        this.mIntervalSpinner = new SGSpinner();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mInnerColorButton = new JButton();
        this.mSizeSeparator = new JSeparator();
        this.mFormSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new JButton();
        this.mInnerColorLabel = new JLabel();
        this.mHorizontalRadioButton = new JRadioButton();
        this.mVerticalRadioButton = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        this.mDistortionLabel.setFont(new Font("Dialog", 0, 12));
        this.mDistortionLabel.setText("Distortion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mDistortionLabel, gridBagConstraints);
        this.mAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mAngleLabel, gridBagConstraints);
        this.mDistortionSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mDistortionSpinner, gridBagConstraints);
        this.mAngleSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mAngleSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mFormLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormLabel.setText("Form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFormLabel, gridBagConstraints);
        this.mLengthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLengthLabel.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLengthLabel, gridBagConstraints);
        this.mLengthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLengthSpinner, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mIntervalSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mIntervalSpinner, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mInnerColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mPanel.add((Component)this.mInnerColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 60, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mFormSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mInnerColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mInnerColorLabel.setText("Inner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mInnerColorLabel, gridBagConstraints);
        this.mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mHorizontalRadioButton, gridBagConstraints);
        this.mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mVerticalRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mLengthSpinner.initProperties(new SpinnerNumberModel(0.5, 0.5, 2.0, 0.1), " cm");
        this.mIntervalSpinner.initProperties(new SpinnerNumberModel(0.5, 0.1, 2.0, 0.1), " cm");
        this.mDistortionSpinner.initProperties(new SpinnerNumberModel(0.0, -1.0, 1.0, 0.1), null);
        this.mAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -60.000003814697266, 60.000003814697266, 1.0), "\u00b0");
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mHorizontalRadioButton);
        buttonGroup.add(this.mVerticalRadioButton);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mLineColorButton.addActionListener(this);
        this.mInnerColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        return true;
    }

    public Number getLength() {
        return this.mLengthSpinner.getNumber();
    }

    public Number getInterval() {
        return this.mIntervalSpinner.getNumber();
    }

    public Number getDistortion() {
        return this.mDistortionSpinner.getNumber();
    }

    public Number getAngle() {
        return this.mAngleSpinner.getNumber();
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public Boolean isHorizontal() {
        return new Boolean(this.mHorizontalRadioButton.isSelected());
    }

    public Color getLineColor() {
        return this.mLineColorButton.getBackground();
    }

    public Color getInnerColor() {
        return this.mInnerColorButton.getBackground();
    }

    public boolean setLength(Object object) {
        if (object == null) {
            this.mLengthSpinner.setText("");
            return false;
        }
        Float f = null;
        try {
            f = Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.mLengthSpinner.setValue(f);
        return true;
    }

    public boolean setInterval(Object object) {
        if (object == null) {
            this.mIntervalSpinner.setText("");
            return false;
        }
        Float f = null;
        try {
            f = Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.mIntervalSpinner.setValue(f);
        return true;
    }

    public boolean setDistortion(Object object) {
        if (object == null) {
            this.mDistortionSpinner.setText("");
            return false;
        }
        Float f = null;
        try {
            f = Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.mDistortionSpinner.setValue(f);
        return true;
    }

    public boolean setAngle(Object object) {
        if (object == null) {
            this.mAngleSpinner.setText("");
            return false;
        }
        Float f = null;
        try {
            f = Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.mAngleSpinner.setValue(f);
        return true;
    }

    public boolean setLineWidth(Object object) {
        if (object == null) {
            this.mLineWidthSpinner.setText("");
            return false;
        }
        Float f = null;
        try {
            f = Float.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.mLineWidthSpinner.setValue(f);
        return true;
    }

    public boolean setHorizontal(boolean bl) {
        this.mHorizontalRadioButton.setSelected(bl);
        this.mVerticalRadioButton.setSelected(!bl);
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public boolean setInnerColor(Color color) {
        this.mInnerColorButton.setBackground(color);
        return true;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mInnerColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLengthSpinner);
        arrayList.add(this.mIntervalSpinner);
        arrayList.add(this.mDistortionSpinner);
        arrayList.add(this.mAngleSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public SGAxisBreakingSymbol.AxisBreakSymbolProperties getProperties() {
        SGAxisBreakingSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = new SGAxisBreakingSymbol.AxisBreakSymbolProperties();
        Number number = this.getLength();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setLength(number.floatValue() / 0.035277776f);
        Number number2 = this.getInterval();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setInterval(number2.floatValue() / 0.035277776f);
        Number number3 = this.getDistortion();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setDistortion(number3.floatValue());
        Number number4 = this.getAngle();
        if (number4 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setAngle(number4.floatValue() * ((float)Math.PI / 180));
        Number number5 = this.getLineWidth();
        if (number5 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setLineWidth(number5.floatValue());
        Boolean bl = this.isHorizontal();
        if (bl == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolProperties.setHorizontal(bl);
        Color color = this.getLineColor();
        axisBreakSymbolProperties.setLineColor(color);
        Color color2 = this.getInnerColor();
        axisBreakSymbolProperties.setColor(color2);
        return axisBreakSymbolProperties;
    }
}

