/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;

public class SGSXYSamplingData
extends SGSXYMultipleData
implements SGITwoDimensionalData {
    private double mSamplingRate;

    public SGSXYSamplingData() {
    }

    public SGSXYSamplingData(double d, double[][] dArray) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (dArray == null) {
            throw new IllegalArgumentException();
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = dArray[0].length;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            throw new IllegalArgumentException();
        }
        this.mSamplingRate = d;
        this.setYValueArray(dArray);
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public double[] getXValueArray() {
        double[] dArray = new double[this.getDataLength()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)i / this.mSamplingRate;
        }
        return dArray;
    }

    public boolean setData(SGData sGData) {
        if (sGData == null) {
            return false;
        }
        if (!(sGData instanceof SGSXYSamplingData)) {
            return false;
        }
        SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
        this.mSamplingRate = sGSXYSamplingData.mSamplingRate;
        double[][] dArray = sGSXYSamplingData.getYValueArray();
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        this.setYValueArray(dArrayArray);
        return true;
    }

    public double getMinValueX() {
        return 0.0;
    }

    public double getMaxValueX() {
        return (double)(this.getDataLength() - 1) / this.mSamplingRate;
    }
}

