/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;

public class SGUtility {
    public static String[] getAvailableFontFamilyNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        return stringArray;
    }

    public static String getCanonicalPath(String string) {
        Object object;
        File file = new File(string);
        try {
            object = null;
            try {
                object = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return null;
            }
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        object = null;
        try {
            object = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return object;
    }

    public static Rectangle2D createUnion(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("rectList==null");
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)arrayList.get(i);
            if (rectangle2D2 == null) {
                throw new IllegalArgumentException("rect==null");
            }
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        return rectangle2D;
    }

    public static double getRectStart(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getX();
        }
        return rectangle2D.getY();
    }

    public static double getRectSize(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getHeight();
    }

    public static double getRectEnd(Rectangle2D rectangle2D, boolean bl) {
        return SGUtility.getRectStart(rectangle2D, bl) + SGUtility.getRectSize(rectangle2D, bl);
    }

    public static boolean setRectStart(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectEnd(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectSize(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return true;
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, double d, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), d);
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static double getOverlapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.getOverlap(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static boolean showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
        return true;
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component) {
        Toolkit.getDefaultToolkit().beep();
        SGUtility.showMessageDialog(component, "\u4e0d\u6b63\u306a\u5165\u529b\u3067\u3059\u3002", "Illegal input", 0);
        return true;
    }

    public static boolean showFileNotFoundMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Failed to open the file denoted by a specified pathname.", "File not found", -1);
        return true;
    }

    public static boolean showNotImplementedMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Sorry, not yet implemented.", "Not yet implemented", -1);
        return true;
    }
}

