/*
 * SGTimingLineDialog.java
 *
 * Created on 2004/06/09, 15:06
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 *
 * @author  kuromaru
 */
public class SGTimingLineDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Timing Line Dialog";


    /** Creates new form SGTimingLineDialog */
    public SGTimingLineDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTimingLinePanel = new javax.swing.JPanel();
        mTimingValueLabel = new javax.swing.JLabel();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mTimingValueTextField = new javax.swing.JTextField();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new javax.swing.JButton();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mTimingLinePanel.setLayout(new java.awt.GridBagLayout());

        mTimingLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mTimingLinePanel.setFont(new java.awt.Font("MS Sans Serif", 0, 10));
        mTimingValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTimingValueLabel.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueLabel, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        mTimingLinePanel.add(mLineTypeLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTimingLinePanel.add(mColorLabel, gridBagConstraints);

        mTimingValueTextField.setColumns(6);
        mTimingValueTextField.setPreferredSize(new java.awt.Dimension(59, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueTextField, gridBagConstraints);

        mLineWidthSpinner.setMinimumSize(new java.awt.Dimension(65, 20));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineColorButton, gridBagConstraints);

        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mLineTypeComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mLeftSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTimingLinePanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new SGTimingLineDialog(new javax.swing.JFrame(), true).show();
    }
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JPanel mTimingLinePanel;
    private javax.swing.JLabel mTimingValueLabel;
    private javax.swing.JTextField mTimingValueTextField;
    // ϐ錾̏I//GEN-END:variables




   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGTimingLineDialog.TITLE );


		//
		{
			final String typeArray[] = {
				SGDrawingElementLine.LINE_NAME_SOLID,
				SGDrawingElementLine.LINE_NAME_BROKEN,
				SGDrawingElementLine.LINE_NAME_DOT
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		this.pack();



		//
		// Xsi[f̓Kp
		//

		// line
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// FύX{^ɃANVXiǉ
		this.mLineColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;



		return true;
	}


	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		// ^C~OleLXgtB[hɃANVXiǉ
		this.mTimingValueTextField.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}


	/**
	 * 
	 */
	public String getTimingValueString()
	{
		return this.mTimingValueTextField.getText();
	}


	/**
	 * 
	 */
	public boolean setTiminValueString( final double value )
	{
		this.mTimingValueTextField.setText( new Double(value).toString() );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		final String typeName = SGDrawingElementLine.getLineTypeName( type );
		this.mLineTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		if( num==null )
		{
			throw new Error();
		}
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setLineColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mLineColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getLineColorList()
	{
		Color cl = this.mLineColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}




	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mLineColorButton);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add(this.mTimingValueTextField);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = null;

		array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );
			this.mTimingValueTextField.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGElementGroupLine.LineProperties getLineProperties()
	{
		SGElementGroupLine.LineProperties p
			= new SGElementGroupLine.LineProperties();

		Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineWidth( lineWidth.floatValue() );
		}

		p.setLineType( this.getLineType() );
		p.setColorList( this.getLineColorList() );

		return p;
	}


}
