
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.awt.*;
import java.awt.geom.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 *
 */

public class SGDrawingElementLine2D extends SGDrawingElementLine
	implements SGIDrawingElementJava2D
{


	/**
	 *
	 */
	public SGDrawingElementLine2D()
	{
		super();
	}


	/**
	 *
	 */
	public SGDrawingElementLine2D(
		final SGTuple2f start, final SGTuple2f end )
	{
		super( start, end );
	}


	/**
	 *
	 */
	public SGDrawingElementLine2D(
		final SGTuple2f start,
		final SGTuple2f end,
		final float lineWidth )
	{
		super( start, end, lineWidth );
	}



	/**
	 *
	 */
	public boolean contains( final int x, final int y )
	{
		Line2D line = new Line2D.Float(
			this.mStart.x, this.mStart.y, this.mEnd.x, this.mEnd.y );
		final float lw = 2.0f*this.mLineWidth*this.mMagnification;
		final double lensq = line.ptSegDistSq( x, y );
//System.out.println(this.mLineWidth+"  "+this.mMagnification+"  "+lensq);
		if( lensq < lw*lw )
		{
			return true;
		}

		return false;
	}



	/**
	 * 
	 */
	public Rectangle2D getElementBounds()
	{
		SGTuple2f start = this.getStart();
		SGTuple2f end = this.getEnd();
		final float x = ( start.x < end.x ? start.x : end.x ) - mLineWidth;
		final float y = ( start.y < end.y ? start.y : end.y ) - mLineWidth;
		final float w = (float)Math.abs( start.x - end.x ) + 2.0f*mLineWidth;
		final float h = (float)Math.abs( start.y - end.y ) + 2.0f*mLineWidth;
		Rectangle2D rect = new Rectangle2D.Float(x,y,w,h);
		return rect;
	}



	/**
	 * 
	 */
	public Shape getShape()
	{
		Line2D line = new Line2D.Float(
			this.getStart().x, this.getStart().y,
			this.getEnd().x, this.getEnd().y );
		return line;
	}



	/**
	 * 
	 * @param line
	 * @return
	 */
	public static Line2D getLine( final SGDrawingElementLine line )
	{
		SGTuple2f start = line.getStart();
		SGTuple2f end = line.getEnd();
		Line2D sh = new Line2D.Float( start.x, start.y, end.x, end.y );
		return sh;
	}



	/**
	 * 
	 */
	public ArrayList getShapeList()
	{
		ArrayList list = new ArrayList();
		list.add( this.getShape() );
		return list;
	}



	/**
	 * 
	 */
	public String toString()
	{
		String str = new String("[");
		str += this.mStart.toString();
		str += this.mEnd.toString();
		str += new String("]");
		return str;
	}


}
