/*
 * SGAboutDialog.java
 *
 * Created on 2004/09/14, 11:04
 */

package jp.riken.brain.ni.samuraigraph.base;

import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author  kuromaru
 */
public class SGAboutDialog extends JDialog implements ActionListener
{

   	/**
	 * 
	 *
	 */
	public SGAboutDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


	/**
	 * 
	 * @param owner
	 * @param modal
	 */
	public SGAboutDialog( Frame owner, boolean modal )
	{
		super( owner, modal );
		initComponents();
		this.initProperty();
	}


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mImagePanel = new jp.riken.brain.ni.samuraigraph.base.SGImagePanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mMiddleSpaceLabel = new javax.swing.JLabel();
        mTopSpaceLabel = new javax.swing.JLabel();
        mTextArea = new javax.swing.JTextArea();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBottomSpaceLabel = new javax.swing.JLabel();
        mMiddleSpaceLabel2 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mImagePanel.setPreferredSize(new java.awt.Dimension(50, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mImagePanel, gridBagConstraints);

        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mLeftSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mLeftSpaceLabel, gridBagConstraints);

        mMiddleSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mMiddleSpaceLabel, gridBagConstraints);

        mTopSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        getContentPane().add(mTopSpaceLabel, gridBagConstraints);

        mTextArea.setColumns(10);
        mTextArea.setEditable(false);
        mTextArea.setRows(10);
        mTextArea.setPreferredSize(new java.awt.Dimension(300, 170));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mTextArea, gridBagConstraints);

        mRightSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mRightSpaceLabel, gridBagConstraints);

        mBottomSpaceLabel.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        getContentPane().add(mBottomSpaceLabel, gridBagConstraints);

        mMiddleSpaceLabel2.setText("      ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        getContentPane().add(mMiddleSpaceLabel2, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mBottomSpaceLabel;
    private javax.swing.JPanel mButtonPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGImagePanel mImagePanel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel;
    private javax.swing.JLabel mMiddleSpaceLabel2;
    private javax.swing.JButton mOKButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JTextArea mTextArea;
    private javax.swing.JLabel mTopSpaceLabel;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * Title of this dialog.
	 */
	public static final String TITLE = "About Samurai Graph";


	public static final String TEXT
		= "Copyright (c) 2004 RIKEN (The Institute of Physical and Chemical Research)\nAll rights reserved.";



	/**
	 * 
	 */
	private boolean initProperty()
	{
		this.setTitle(TITLE);
		this.setVisible(false);
		this.setResizable(false);
		this.mTextArea.setBackground( this.getContentPane().getBackground() );

		//
		this.mOKButton.addActionListener(this);


		// get the image
		Class inClass = getClass();
		String name = SGConstants.RESOURCES_DIRNAME+"Samurai.gif";
		URL url = inClass.getResource(name);
		Image image = Toolkit.getDefaultToolkit().getImage( url );
		this.mImagePanel.setImage( image );

		// set the text
		this.mTextArea.append( this.createString() );

		return true;
	}


	private String createString()
	{
		String str = new String();

		str += "Samurai Graph " + SGDefaultValues.VERSION_NUMBER + "\n";
		str += "\n";
		str += "Copyright (c) 2004 RIKEN, Japan. All rights reserved.\n";
		str += "\n";
		str += "Created by Neuroinformatics Laboratory, BSI.\n";
		str += "\n";
		str += "This software is distributed under the LGPL\n";
		str += "(Lesser General Public License).\n";
		str += "\n";
		str += "http://samurai-graph.sourceforge.jp/\n";

		return str;
	}



	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		Object source = e.getSource();
		if( source.equals( this.mOKButton ) )
		{
			this.hide();
		}
	}


}
