/*
 * Created on 2004/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.*;
import java.util.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGSignificantDifferenceSymbol extends SGDrawingElement
{

	/**
	 * 
	 */
	public static final int OTHER = 0;


	/**
	 * 
	 */
	public static final int HORIZONTAL_MIDDLE = 1;


	/**
	 * 
	 */
	public static final int LEFT_MIDDLE = 2;


	/**
	 * 
	 */
	public static final int RIGHT_MIDDLE = 3;


	/**
	 * 
	 */
	public static final int LEFT_TERM = 4;


	/**
	 * 
	 */
	public static final int LEFT_JOINT = 5;


	/**
	 * 
	 */
	public static final int RIGHT_TERM = 6;


	/**
	 * 
	 */
	public static final int RIGHT_JOINT = 7;


	/**
	 * 
	 */
	public static final int ON_STRING = 8;



	/**
	 * 
	 */
	protected float mX;


	/**
	 * 
	 */
	protected float mY;


	/**
	 * 
	 */
	protected float mWidth;


	/**
	 * 
	 */
	protected float mPerpendicularHeight1;


	/**
	 * 
	 */
	protected float mPerpendicularHeight2;


	/**
	 * 
	 */
	protected float mSpace;


	/**
	 * 
	 */
	protected float mLineWidth;



	/**
	 * 
	 */
	public static final int mMinWidth = 10;
	
	
	/**
	 * 
	 */
	public static final int mMinHeight = 10;



	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol(
		final float x,
		final float y,
		final float w,
		final float hl,
		final float hr )
	{
		super();
		this.setLocation(x,y);
		this.setSize(w,hl,hr);
	}



	/**
	 * 
	 */
	public abstract float getX();


	/**
	 * 
	 */
	public abstract float getY();


	/**
	 * 
	 */
	public float getWidth()
	{
		return this.mWidth*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight1()
	{
		return this.mPerpendicularHeight1*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight2()
	{
		return this.mPerpendicularHeight2*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getSpace()
	{
		return this.mSpace*this.mMagnification;
	}


	/**
	 * 
	 */
	public abstract SGDrawingElementString getStringElement();


	/**
	 * 
	 */
	public String getText()
	{
		return this.getStringElement().getString();
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.getStringElement().getFontSize();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.getStringElement().getFontStyle();
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return this.getStringElement().getFontFamilyName();
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.getColor(0);
	}


	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}



	/**
	 * 
	 * @param x
	 * @return
	 */
	public abstract boolean setX( final float x );



	/**
	 * 
	 * @param y
	 * @return
	 */
	public abstract boolean setY( final float y );



	/**
	 * 
	 */
	public boolean setSize( final float w, final float h1, final float h2 )
	{
		this.setWidth(w);
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);

		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		this.mWidth = w/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight1( final float h )
	{
		this.mPerpendicularHeight1 = h/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight2( final float h )
	{
		this.mPerpendicularHeight2 = h/this.mMagnification;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		if( space<0 )
		{
			throw new IllegalArgumentException("space<0");
		}

		this.mSpace = space/this.mMagnification;

		return true;
	}



	/**
	 * 
	 */
	public boolean setText( final String text )
	{
		this.getStringElement().setString( text );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		this.mLineWidth = lineWidth;
		return true;
	}



	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.getStringElement().setFontSize(size);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		this.getStringElement().setFontStyle(style);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.getStringElement().setFontFamilyName(name);
		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{

		SigDiffProperties p = new SigDiffProperties();
		p.x = this.mX;
		p.y = this.mY;
		p.width = this.mWidth;
		p.height1 = this.mPerpendicularHeight1;
		p.height2 = this.mPerpendicularHeight2;
		p.space = this.mSpace;

		p.colorList = this.mColorList;

		p.lineWidth = this.mLineWidth;

		p.text = this.getText();
		p.fontFamilyName = this.getFontFamilyName();
		p.fontSize = this.getFontSize();
		p.fontStyle = this.getFontStyle();
			
		return p;
	}



	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{

		if( p==null ) return false;

		if( ( p instanceof SigDiffProperties ) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;

		this.mX = sp.x;
		this.mY = sp.y;
		this.mWidth = sp.width;
		this.mPerpendicularHeight1 = sp.height1;
		this.mPerpendicularHeight2 = sp.height2;
		this.mSpace = sp.space;

		this.setText( sp.text );

		this.setFontFamilyName( sp.fontFamilyName );
		this.setFontSize( sp.fontSize );
		this.setFontStyle( sp.fontStyle );
		this.setLineWidth( sp.lineWidth );
		this.setColorList( sp.colorList );

		return true;

	}



	/**
	 * 
	 */
	public static class SigDiffProperties extends SGProperties
	{
		
		public float x;
		public float y;
		public float width;
		public float height1;
		public float height2;
		public float space;
		public float lineWidth;
		public String text;
		public String fontFamilyName;
		public float fontSize;
		public int fontStyle;
		public ArrayList colorList = new ArrayList();


		public SigDiffProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffProperties ) == false ) return false;

			SigDiffProperties p = (SigDiffProperties)obj;

			if( p.x != this.x ) return false;
			if( p.y != this.y ) return false;
			if( p.width != this.width ) return false;
			if( p.height1 != this.height1 ) return false;
			if( p.height2 != this.height2 ) return false;
			if( p.space != this.space ) return false;
			if( p.lineWidth != this.lineWidth ) return false;
			if( p.text.equals(this.text) == false ) return false;
			if( p.fontFamilyName.equals(this.fontFamilyName) == false ) return false;
			if( p.fontSize != this.fontSize ) return false;
			if( p.fontStyle != this.fontStyle ) return false;
			if( p.colorList.equals(this.colorList) == false ) return false;

			return true;
		}

	}



}

