/*
 * 쐬: 2004/05/08
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import javax.swing.*;


/**
 * @author LANDAU
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SGUtility
{


	/**
	 * 
	 */
	public static String[] getAvailableFontFamilyNames()
	{
		final String fontArray[]
			= GraphicsEnvironment.getLocalGraphicsEnvironment().
			  getAvailableFontFamilyNames();

		return fontArray;
	}


	/**
	 * Get the canonical path.
	 */
	public static String getCanonicalPath( final String str )
	{

		File file = new File( str );
//		if( file.canRead() == false )
//		{
//			return null;
//		}

		try
		{
			FileInputStream fis = null;
			try
			{
				fis = new FileInputStream( str );
			}
			catch( FileNotFoundException ex )
			{
				System.out.println("t@C̓ǂݍ݂Ɏs܂B");
				return null;
			}

			fis.close();
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
			return null;
		}


		String pathName = null;
		try
		{
			pathName = file.getCanonicalPath();
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
			return null;
		}

		return pathName;

	}



	/**
	 * 
	 */
	public static Rectangle2D createUnion(
		final ArrayList rectList )
	{
		Rectangle2D rectAll = null;
		for( int ii=0; ii<rectList.size(); ii++ )
		{
			Rectangle2D rect = (Rectangle2D)rectList.get(ii);
//System.out.println(ii+"  "+rect);
			if( rectAll == null )
			{
				rectAll = rect;
				continue;
			}

			rectAll = rect.createUnion(rectAll);
		}

		return rectAll;		
	}



	/**
	 * 
	 * @param rect
	 * @param value
	 * @param direction
	 * @return
	 */
	public static boolean isRectContains(
		final Rectangle2D rect,
		final double value,
		final boolean direction )
	{
		boolean flag;
		if( direction )
		{
			flag = SGUtilityNumber.contains(
				rect.getX(), rect.getX()+rect.getWidth(), value );
		}
		else
		{
			flag =	SGUtilityNumber.contains(
				rect.getY(), rect.getY()+rect.getHeight(), value );
		}

		return flag;
	}




	/**
	 * 
	 * @param rect1
	 * @param rect2
	 * @param direction
	 * @return
	 */
	public static boolean isRectContains(
		final Rectangle2D rect1,
		final Rectangle2D rect2,
		final boolean direction )
	{
		boolean flag;
		if( direction )
		{
			flag = SGUtilityNumber.contains(
				rect1.getX(), rect1.getX()+rect1.getWidth(),
				rect2.getX(), rect2.getX()+rect2.getWidth() );
		}
		else
		{
			flag =	SGUtilityNumber.contains(
				rect1.getY(), rect1.getY()+rect1.getHeight(),
				rect2.getY(), rect2.getY()+rect2.getHeight() );
		}

		return flag;
	}



	/**
	 * 
	 * @param rect1
	 * @param rect2
	 * @param direction
	 * @return
	 */
	public static double getOverlapping(
		final Rectangle2D rect1,
		final Rectangle2D rect2,
		final boolean direction )
	{
		double value;
		if( direction )
		{
			value = SGUtilityNumber.getOverlap(
				rect1.getX(), rect1.getX()+rect1.getWidth(),
				rect2.getX(), rect2.getX()+rect2.getWidth() );
		}
		else
		{
			value = SGUtilityNumber.getOverlap(
				rect1.getY(), rect1.getY()+rect1.getHeight(),
				rect2.getY(), rect2.getY()+rect2.getHeight() );
		}

		return value;
	}



	/**
	 * 
	 */
	public static boolean showMessageDialog( Component parentComponent, Object message, String title, int messageType )
	{
		JOptionPane.showMessageDialog(
			parentComponent, message, title, messageType
		);
		return true;
	}



	/**
	 * 
	 * @param parentComponent
	 * @return
	 */
	public static boolean showIllegalInputErrorMessageDialog( Component parentComponent )
	{
		Toolkit.getDefaultToolkit().beep();
		SGUtility.showMessageDialog(
			parentComponent,
			"sȓ͂łB",
			"Illegal input", 
			JOptionPane.ERROR_MESSAGE );
		return true;
	}



}
