
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.awt.Color;


/**
 *
 */

public abstract class SGDrawingElement
{

	/**
	 * zoom̔{
	 */
	protected float mMagnification = 1.0f;


	/**
	 *
	 */
	protected ArrayList mColorList = new ArrayList();


	/**
	 *
	 */
	public SGDrawingElement()
	{
	}


	/**
	 *
	 */
	public abstract boolean contains( final int x, final int y );



	/**
	 *
	 */
	public boolean zoom( final float ratio )
	{
		this.setMagnification( ratio );
		return true;
	}



	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		mMagnification = mag;
		return true;
	}



	/**
	 * 
	 */
	public boolean setColorList( final ArrayList colorList )
	{
		mColorList = new ArrayList(colorList);
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		mColorList = new ArrayList();
		mColorList.add(color);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		if( mColorList == null )
		{
			mColorList = new ArrayList();
		}
		mColorList.add(color);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public ArrayList getColorList()
	{
		return mColorList;
	}


	/**
	 * 
	 */
	public Color getColor( final int index )
	{
		if( mColorList == null )
		{
			return null;
		}

		if( index >= mColorList.size() )
		{
			return null;
		}

		return (Color)mColorList.get(index);
	}


	/**
	 * 
	 */
	public float getMagnification()
	{
		return this.mMagnification;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		this.setMagnification( element.getMagnification() );
		this.setColorList( element.getColorList() );

		return true;
	}


}
