/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement;

public class SGAxisPanel
extends JPanel
implements ActionListener {
    private JLabel mAutoLabel;
    private JCheckBox mAutoScaleCheckBox;
    private JCheckBox mAxisVisibleCheckBox;
    private JLabel mBaseTickLabel;
    private JTextField mBaseTickTextField;
    private JCheckBox mExponentCheckBox;
    private JLabel mExponentLabel;
    private SGSpinner mExponentSpinner;
    private JLabel mIncrementLabel;
    private JTextField mIncrementTextField;
    private JRadioButton mInnerRadioButton;
    private JCheckBox mIntegerCheckBox;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLinearRadioButton;
    private JRadioButton mLogRadioButton;
    private JSeparator mManualScaleSeparator;
    private JLabel mMaxLabel;
    private JTextField mMaxValueTextField;
    private JLabel mMinLabel;
    private JTextField mMinValueTextField;
    private JRadioButton mOuterRadioButton;
    private JLabel mRightSpaceLabel;
    private JLabel mScaleExpressionLabel;
    private JSeparator mScaleExpressionSeparator;
    private JCheckBox mScaleExpressionVisibleCheckBox;
    private JCheckBox mScaleLineVisibleCheckBox;
    private JPanel mScalePanel;
    private JPanel mTitleAppearancePanel;
    private JLabel mTitleLabel;
    private JLabel mTitleLeftSpaceLabel;
    private JLabel mTitleRightSpaceLabel;
    private JTextField mTitleTextField;
    private JCheckBox mTitleVisibleCheckBox;

    public SGAxisPanel() {
        this.initComponents();
        this.initProerty();
    }

    private void initComponents() {
        this.mScalePanel = new JPanel();
        this.mAutoLabel = new JLabel();
        this.mAutoScaleCheckBox = new JCheckBox();
        this.mLinearRadioButton = new JRadioButton();
        this.mScaleLineVisibleCheckBox = new JCheckBox();
        this.mManualScaleSeparator = new JSeparator();
        this.mLogRadioButton = new JRadioButton();
        this.mMinLabel = new JLabel();
        this.mMaxLabel = new JLabel();
        this.mMinValueTextField = new JTextField();
        this.mMaxValueTextField = new JTextField();
        this.mBaseTickLabel = new JLabel();
        this.mBaseTickTextField = new JTextField();
        this.mIncrementTextField = new JTextField();
        this.mIncrementLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mOuterRadioButton = new JRadioButton();
        this.mInnerRadioButton = new JRadioButton();
        this.mExponentLabel = new JLabel();
        this.mIntegerCheckBox = new JCheckBox();
        this.mExponentCheckBox = new JCheckBox();
        this.mScaleExpressionVisibleCheckBox = new JCheckBox();
        this.mScaleExpressionLabel = new JLabel();
        this.mScaleExpressionSeparator = new JSeparator();
        this.mExponentSpinner = new SGSpinner();
        this.mTitleAppearancePanel = new JPanel();
        this.mTitleVisibleCheckBox = new JCheckBox();
        this.mTitleTextField = new JTextField();
        this.mTitleLabel = new JLabel();
        this.mTitleLeftSpaceLabel = new JLabel();
        this.mTitleRightSpaceLabel = new JLabel();
        this.mAxisVisibleCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.mScalePanel.setLayout(new GridBagLayout());
        this.mScalePanel.setBorder(new TitledBorder(null, "Scale", 0, 0, new Font("MS Sans Serif", 1, 12)));
        this.mAutoLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mAutoLabel.setText("Tick Label ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mAutoLabel, gridBagConstraints);
        this.mAutoScaleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mAutoScaleCheckBox.setText("Auto");
        this.mAutoScaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGAxisPanel.this.mAutoScaleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mAutoScaleCheckBox, gridBagConstraints);
        this.mLinearRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mLinearRadioButton.setText("Linear");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mLinearRadioButton, gridBagConstraints);
        this.mScaleLineVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mScaleLineVisibleCheckBox.setText("Visible");
        this.mScaleLineVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGAxisPanel.this.mScaleLineVisibleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mScaleLineVisibleCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.mScalePanel.add((Component)this.mManualScaleSeparator, gridBagConstraints);
        this.mLogRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mLogRadioButton.setText("Log");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mLogRadioButton, gridBagConstraints);
        this.mMinLabel.setFont(new Font("Dialog", 0, 12));
        this.mMinLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mMinLabel, gridBagConstraints);
        this.mMaxLabel.setFont(new Font("Dialog", 0, 12));
        this.mMaxLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mMaxLabel, gridBagConstraints);
        this.mMinValueTextField.setColumns(5);
        this.mMinValueTextField.setPreferredSize(new Dimension(51, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mMinValueTextField, gridBagConstraints);
        this.mMaxValueTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mMaxValueTextField, gridBagConstraints);
        this.mBaseTickLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseTickLabel.setText("Base");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mBaseTickLabel, gridBagConstraints);
        this.mBaseTickTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mBaseTickTextField, gridBagConstraints);
        this.mIncrementTextField.setColumns(5);
        this.mIncrementTextField.setPreferredSize(new Dimension(51, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mIncrementTextField, gridBagConstraints);
        this.mIncrementLabel.setFont(new Font("Dialog", 0, 12));
        this.mIncrementLabel.setText("Step");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mIncrementLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mScalePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mScalePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mOuterRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mOuterRadioButton.setText("Outer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mOuterRadioButton, gridBagConstraints);
        this.mInnerRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mInnerRadioButton.setText("Inner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mInnerRadioButton, gridBagConstraints);
        this.mExponentLabel.setFont(new Font("Dialog", 1, 14));
        this.mExponentLabel.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mScalePanel.add((Component)this.mExponentLabel, gridBagConstraints);
        this.mIntegerCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mIntegerCheckBox.setText("Integer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mIntegerCheckBox, gridBagConstraints);
        this.mExponentCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mExponentCheckBox.setText("Exp Part");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mExponentCheckBox, gridBagConstraints);
        this.mScaleExpressionVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mScaleExpressionVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mScaleExpressionVisibleCheckBox, gridBagConstraints);
        this.mScaleExpressionLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mScaleExpressionLabel.setText("Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mScaleExpressionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mScalePanel.add((Component)this.mScaleExpressionSeparator, gridBagConstraints);
        this.mExponentSpinner.setFont(new Font("MonoSpaced", 0, 10));
        this.mExponentSpinner.setPreferredSize(new Dimension(40, 20));
        this.mExponentSpinner.setValue(new Integer(0));
        this.mExponentSpinner.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mExponentSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mScalePanel, gridBagConstraints);
        this.mTitleAppearancePanel.setLayout(new GridBagLayout());
        this.mTitleAppearancePanel.setBorder(new TitledBorder(null, "Title", 0, 0, new Font("MS Sans Serif", 1, 12)));
        this.mTitleVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mTitleVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTitleAppearancePanel.add((Component)this.mTitleVisibleCheckBox, gridBagConstraints);
        this.mTitleTextField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTitleAppearancePanel.add((Component)this.mTitleTextField, gridBagConstraints);
        this.mTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTitleLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTitleAppearancePanel.add((Component)this.mTitleLabel, gridBagConstraints);
        this.mTitleLeftSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mTitleLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mTitleAppearancePanel.add((Component)this.mTitleLeftSpaceLabel, gridBagConstraints);
        this.mTitleRightSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mTitleRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.mTitleAppearancePanel.add((Component)this.mTitleRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mTitleAppearancePanel, gridBagConstraints);
        this.mAxisVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mAxisVisibleCheckBox.setText("Visible Axis");
        this.mAxisVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGAxisPanel.this.mAxisVisibleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        gridBagConstraints.anchor = 16;
        this.add((Component)this.mAxisVisibleCheckBox, gridBagConstraints);
    }

    private void mScaleLineVisibleCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void mAutoScaleCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void mAxisVisibleCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    public ArrayList getActiveComponentList() {
        ArrayList<JTextField> arrayList = new ArrayList<JTextField>();
        arrayList.add(this.mMinValueTextField);
        arrayList.add(this.mMaxValueTextField);
        arrayList.add(this.mTitleTextField);
        arrayList.add(this.mBaseTickTextField);
        arrayList.add(this.mIncrementTextField);
        ArrayList arrayList2 = this.getSpinnerList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            JSpinner jSpinner = (JSpinner)arrayList2.get(i);
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jSpinner.getEditor();
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            arrayList.add(jFormattedTextField);
        }
        return arrayList;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mMinValueTextField.addActionListener(actionListener);
        this.mMaxValueTextField.addActionListener(actionListener);
        this.mTitleTextField.addActionListener(actionListener);
        this.mBaseTickTextField.addActionListener(actionListener);
        this.mIncrementTextField.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mMinValueTextField.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mMinValueTextField.removeActionListener(actionListenerArray[i]);
            this.mMaxValueTextField.removeActionListener(actionListenerArray[i]);
            this.mTitleTextField.removeActionListener(actionListenerArray[i]);
            this.mBaseTickTextField.removeActionListener(actionListenerArray[i]);
            this.mIncrementTextField.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    private boolean initProerty() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mLinearRadioButton);
        buttonGroup.add(this.mLogRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mInnerRadioButton);
        buttonGroup.add(this.mOuterRadioButton);
        this.mAxisVisibleCheckBox.addActionListener(this);
        this.mTitleVisibleCheckBox.addActionListener(this);
        this.mScaleExpressionVisibleCheckBox.addActionListener(this);
        this.mScaleLineVisibleCheckBox.addActionListener(this);
        this.mAutoScaleCheckBox.addActionListener(this);
        this.mExponentCheckBox.addActionListener(this);
        this.mExponentSpinner.initProperties(new SpinnerNumberModel(0, -10, 10, 1), null);
        this.mExponentSpinner.setMinimumFractionDigits(0);
        this.mExponentSpinner.setMaximumFractionDigits(0);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mAxisVisibleCheckBox)) {
            this.setAxisPanelComponentsEnables(this.mAxisVisibleCheckBox.isSelected());
        } else if (object.equals(this.mTitleVisibleCheckBox)) {
            this.setTitleComponentsEnabled(this.mTitleVisibleCheckBox.isSelected());
        } else if (object.equals(this.mScaleExpressionVisibleCheckBox)) {
            this.setScaleNumberComponentsEnabled(this.mScaleExpressionVisibleCheckBox.isSelected());
        } else if (object.equals(this.mScaleLineVisibleCheckBox)) {
            this.setScaleLineComponentsEnabled(this.mScaleLineVisibleCheckBox.isSelected());
        } else if (object.equals(this.mAutoScaleCheckBox)) {
            boolean bl = this.mAutoScaleCheckBox.isSelected();
            this.mIncrementTextField.setEditable(!bl);
            this.mBaseTickTextField.setEditable(!bl);
        } else if (object.equals(this.mExponentCheckBox)) {
            this.setExponentFlag(this.mExponentCheckBox.isSelected());
        }
        this.repaint();
    }

    protected boolean setAxisPanelComponentsEnables(boolean bl) {
        this.mTitleVisibleCheckBox.setEnabled(bl);
        boolean bl2 = this.mTitleVisibleCheckBox.isSelected();
        this.setTitleComponentsEnabled(bl & bl2);
        this.setScaleComponentsEnabled(bl);
        return true;
    }

    private boolean setTitleComponentsEnabled(boolean bl) {
        this.mTitleLabel.setEnabled(bl);
        this.mTitleTextField.setEnabled(bl);
        return true;
    }

    private boolean setScaleComponentsEnabled(boolean bl) {
        this.mAutoLabel.setEnabled(bl);
        this.mAutoScaleCheckBox.setEnabled(bl);
        this.setManualComponentsEnabled(bl);
        this.mScaleExpressionLabel.setEnabled(bl);
        this.mScaleExpressionVisibleCheckBox.setEnabled(bl);
        boolean bl2 = this.mScaleExpressionVisibleCheckBox.isSelected();
        this.setScaleNumberComponentsEnabled(bl & bl2);
        this.mScaleLineVisibleCheckBox.setEnabled(bl);
        boolean bl3 = this.mScaleLineVisibleCheckBox.isSelected();
        this.setScaleLineComponentsEnabled(bl & bl3);
        return true;
    }

    private boolean setManualComponentsEnabled(boolean bl) {
        this.mLinearRadioButton.setEnabled(bl);
        this.mLogRadioButton.setEnabled(bl);
        this.mMinLabel.setEnabled(bl);
        this.mMinValueTextField.setEnabled(bl);
        this.mMaxLabel.setEnabled(bl);
        this.mMaxValueTextField.setEnabled(bl);
        this.mBaseTickLabel.setEnabled(bl);
        this.mBaseTickTextField.setEnabled(bl);
        this.mIncrementLabel.setEnabled(bl);
        this.mIncrementTextField.setEnabled(bl);
        return true;
    }

    private boolean setScaleNumberComponentsEnabled(boolean bl) {
        this.mIntegerCheckBox.setEnabled(bl);
        this.mExponentCheckBox.setEnabled(bl);
        boolean bl2 = bl && this.getExponentFlag();
        this.setExponentComponentEnabled(bl2);
        return true;
    }

    private boolean setExponentComponentEnabled(boolean bl) {
        this.mExponentLabel.setEnabled(bl);
        this.mExponentSpinner.setEnabled(bl);
        return true;
    }

    private boolean setScaleLineComponentsEnabled(boolean bl) {
        this.mInnerRadioButton.setEnabled(bl);
        this.mOuterRadioButton.setEnabled(bl);
        return true;
    }

    public int getScaleType() {
        int n;
        if (this.mLinearRadioButton.isSelected()) {
            n = 0;
        } else if (this.mLogRadioButton.isSelected()) {
            n = 1;
        } else {
            throw new Error();
        }
        return n;
    }

    public SGTuple2d getScale() {
        String string = this.mMinValueTextField.getText();
        String string2 = this.mMaxValueTextField.getText();
        if (string.length() == 0 || string2.length() == 0) {
            return null;
        }
        Double d = null;
        Double d2 = null;
        try {
            d = Double.valueOf(string);
            d2 = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
            return null;
        }
        double d3 = d;
        double d4 = d2;
        if (d3 >= d4) {
            System.out.println("min >= max");
            return null;
        }
        SGTuple2d sGTuple2d = new SGTuple2d(d3, d4);
        return sGTuple2d;
    }

    public boolean getAutoCalcFlag() {
        return this.mAutoScaleCheckBox.isSelected();
    }

    public Number getIncrementValue() {
        String string = this.mIncrementTextField.getText();
        Double d = null;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
        return d;
    }

    public Number getBaseTickValue() {
        String string = this.mBaseTickTextField.getText();
        Double d = null;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
        return d;
    }

    public String getTitleString() {
        String string = this.mTitleTextField.getText();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public boolean getAxisGroupVisible() {
        return this.mAxisVisibleCheckBox.isSelected();
    }

    public boolean getTitleVisible() {
        return this.mTitleVisibleCheckBox.isSelected();
    }

    public boolean getScaleNumbersVisible() {
        return this.mScaleExpressionVisibleCheckBox.isSelected();
    }

    public boolean getScaleLineVisible() {
        return this.mScaleLineVisibleCheckBox.isSelected();
    }

    public boolean getScaleLineDirection() {
        boolean bl;
        if (this.mInnerRadioButton.isSelected()) {
            bl = true;
        } else if (this.mOuterRadioButton.isSelected()) {
            bl = false;
        } else {
            throw new Error();
        }
        return bl;
    }

    public boolean getScaleNumbersInteger() {
        return this.mIntegerCheckBox.isSelected();
    }

    public boolean getExponentFlag() {
        return this.mExponentCheckBox.isSelected();
    }

    public Number getExponentValue() {
        return this.mExponentSpinner.getNumber();
    }

    public boolean setTitleTextField(String string) {
        this.mTitleTextField.setText(string);
        return true;
    }

    public boolean setScaleType(int n) {
        switch (n) {
            case 0: {
                this.mLinearRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mLogRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("The scale type is illegal.");
            }
        }
        return true;
    }

    public boolean setAxisVisible(boolean bl) {
        this.mAxisVisibleCheckBox.setSelected(bl);
        this.setAxisPanelComponentsEnables(bl);
        return true;
    }

    public boolean setTitleVisible(boolean bl) {
        this.mTitleVisibleCheckBox.setSelected(bl);
        this.setTitleComponentsEnabled(bl);
        return true;
    }

    public boolean setScaleLinesVisible(boolean bl) {
        this.mScaleLineVisibleCheckBox.setSelected(bl);
        this.setScaleLineComponentsEnabled(bl);
        return true;
    }

    public boolean setScaleLinesInside(boolean bl) {
        if (bl) {
            this.mInnerRadioButton.setSelected(true);
        } else {
            this.mOuterRadioButton.setSelected(true);
        }
        return true;
    }

    public boolean setScaleNumbersVisible(boolean bl) {
        this.mScaleExpressionVisibleCheckBox.setSelected(bl);
        this.setScaleNumberComponentsEnabled(bl);
        return true;
    }

    public boolean setScaleNumbersInteger(boolean bl) {
        this.mIntegerCheckBox.setSelected(bl);
        return true;
    }

    public boolean setRange(SGTuple2d sGTuple2d) {
        if (sGTuple2d == null) {
            return false;
        }
        this.mMinValueTextField.setText(new Double(sGTuple2d.x).toString());
        this.mMaxValueTextField.setText(new Double(sGTuple2d.y).toString());
        return true;
    }

    public boolean setAutoCalcFlag(boolean bl) {
        this.mAutoScaleCheckBox.setSelected(bl);
        this.mBaseTickTextField.setEditable(!bl);
        this.mIncrementTextField.setEditable(!bl);
        return true;
    }

    public boolean setBaseTickValue(double d) {
        this.mBaseTickTextField.setText(new Double(d).toString());
        return true;
    }

    public boolean setIncrementValue(double d) {
        this.mIncrementTextField.setText(new Double(d).toString());
        return true;
    }

    public boolean setExponentFlag(boolean bl) {
        this.mExponentCheckBox.setSelected(bl);
        this.mExponentLabel.setEnabled(bl);
        this.mExponentSpinner.setEnabled(bl);
        return true;
    }

    public boolean setExponentValue(int n) {
        this.mExponentSpinner.setValue(new Integer(n));
        return true;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mExponentSpinner);
        return arrayList;
    }

    public SGAxisElement.AxisIndividualProperties getProperties() {
        SGAxisElement.AxisIndividualProperties axisIndividualProperties = new SGAxisElement.AxisIndividualProperties();
        int n = this.getScaleType();
        SGTuple2d sGTuple2d = this.getScale();
        if (sGTuple2d == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        if (n == 1 && sGTuple2d.x < Double.MIN_VALUE) {
            System.out.println("Inappropriate range for the log scale");
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisIndividualProperties.scaleType = n;
        axisIndividualProperties.minValue = sGTuple2d.x;
        axisIndividualProperties.maxValue = sGTuple2d.y;
        axisIndividualProperties.autoCalcAxisNumberFlag = this.getAutoCalcFlag();
        Number number = this.getIncrementValue();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisIndividualProperties.incrementValue = number.doubleValue();
        Number number2 = this.getBaseTickValue();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisIndividualProperties.baseTickValue = number2.doubleValue();
        axisIndividualProperties.titleString = this.getTitleString();
        axisIndividualProperties.axisVisibleFlag = this.getAxisGroupVisible();
        axisIndividualProperties.titleVisibleFlag = this.getTitleVisible();
        axisIndividualProperties.scaleLinesVisibleFlag = this.getScaleLineVisible();
        axisIndividualProperties.scaleNumbersVisibleFlag = this.getScaleNumbersVisible();
        axisIndividualProperties.scaleLinesInsideFlag = this.getScaleLineDirection();
        axisIndividualProperties.scaleNumbersIntegerFlag = this.getScaleNumbersInteger();
        axisIndividualProperties.exponentFlag = this.getExponentFlag();
        Number number3 = this.getExponentValue();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisIndividualProperties.exponentValue = number3.intValue();
        return axisIndividualProperties;
    }
}

