/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;

public abstract class SGWizardDialog
extends JDialog
implements ActionListener,
WindowListener {
    public static final String FROM_WIZARD_DIALOG = "from wizard dialog";
    public static final String OK_BUTTON_TEXT = "OK";
    public static final String CANCEL_BUTTON_TEXT = "Cancel";
    public static final String PREVIOUS_BUTTON_TEXT = "<Previous";
    public static final String NEXT_BUTTON_TEXT = "Next";
    public static String PATH_NAME = "./";
    protected ArrayList mActionListenerList = new ArrayList();
    private SGWizardDialog mPreviousWizardDialog = null;
    private SGWizardDialog mNextWizardDialog = null;

    public SGWizardDialog() {
        this.init();
    }

    public SGWizardDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
    }

    public SGWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init();
    }

    private boolean init() {
        this.addWindowListener(this);
        return true;
    }

    public SGDrawingWindow getOwnerWindow() {
        Window window = this.getOwner();
        SGDrawingWindow sGDrawingWindow = null;
        if (window instanceof SGDrawingWindow) {
            sGDrawingWindow = (SGDrawingWindow)window;
        }
        return sGDrawingWindow;
    }

    public SGWizardDialog getPrevious() {
        return this.mPreviousWizardDialog;
    }

    public SGWizardDialog getNext() {
        return this.mNextWizardDialog;
    }

    public boolean setPrevious(SGWizardDialog sGWizardDialog) {
        this.mPreviousWizardDialog = sGWizardDialog;
        return true;
    }

    public boolean setNext(SGWizardDialog sGWizardDialog) {
        this.mNextWizardDialog = sGWizardDialog;
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    protected void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    protected ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("windowClosed");
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("windowClosing");
        Object object = windowEvent.getSource();
        if (object.equals(this)) {
            this.onCanceled();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected boolean onOK() {
        this.notifyToListener(OK_BUTTON_TEXT);
        return true;
    }

    protected boolean onCanceled() {
        this.notifyToListener(CANCEL_BUTTON_TEXT);
        return true;
    }

    protected boolean onPrevious() {
        this.notifyToListener(PREVIOUS_BUTTON_TEXT);
        return true;
    }

    protected boolean onNext() {
        this.notifyToListener(NEXT_BUTTON_TEXT);
        return true;
    }

    public void show() {
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)this.getOwner();
        this.setLocation(sGDrawingWindow.getX(), sGDrawingWindow.getY());
        super.show();
    }
}

