/*
 * SGSignificantDifferenceSymbolDialog.java
 *
 * Created on 2004/06/17, 14:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;



/**
 *
 * @author  kuromaru
 */
public class SGSignificantDifferenceSymbolDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Significant Difference Symbol Dialog";

    
    /** Creates new form SGSignificantDifferenceSymbolDialog */
    public SGSignificantDifferenceSymbolDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mTextPanel = new javax.swing.JPanel();
        mFontFamilyNameLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontFamilyNameComboBox = new javax.swing.JComboBox();
        mColorButton = new javax.swing.JButton();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mSpaceLabel = new javax.swing.JLabel();
        mSpaceSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mTextPanel.setLayout(new java.awt.GridBagLayout());

        mTextPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyNameLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mFontFamilyNameLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mTextPanel.add(mFontSizeLabel, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mColorLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mLineWidthLabel, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontFamilyNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontFamilyNameComboBox, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mColorButton, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 55, 5, 5);
        mTextPanel.add(mStringSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mTextPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        mTextPanel.add(mRightSpaceLabel, gridBagConstraints);

        mSpaceLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLabel.setText("Space");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mSpaceLabel, gridBagConstraints);

        mSpaceSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mSpaceSpinner, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTextPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new SGSignificantDifferenceSymbolDialog(new javax.swing.JFrame(), true).show();
    }
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mColorButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JComboBox mFontFamilyNameComboBox;
    private javax.swing.JLabel mFontFamilyNameLabel;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceSpinner;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JPanel mTextPanel;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	public Number getSpace()
	{
		return this.mSpaceSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}
	
	
	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return (String)this.mFontFamilyNameComboBox.getSelectedItem();
	}
	

	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}
	
	
	/**
	 * 
	 */
	public ArrayList getTextColorList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mColorButton.getBackground() );
		return list;
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}



	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		this.mSpaceSpinner.setValue( new Double(space) );
		return true;
	}



	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double(size) );
		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.mFontFamilyNameComboBox.setSelectedItem( name );
		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidthSpinner.setValue( new Double(width) );
		return true;
	}
	
	
	
	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mSpaceSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGSignificantDifferenceSymbolDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontFamilyNameComboBox.addItem( fontArray[ii] );
			}
	
			final String[] styleNameArray = {
				SGConstants.FONT_PLAIN,
				SGConstants.FONT_ITALIC,
				SGConstants.FONT_BOLD,
				SGConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}
	
		}
	
		this.pack();
	
	
	
		//
		// spinner model
		//

		// spinner
		this.mSpaceSpinner.initProperties(
			new SpinnerNumberModel( 0.1, 0.0, 1.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );
	
		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );
	
		// line width
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// FύX{^ɃANVXiǉ
		this.mColorButton.addActionListener(this);
	
	
		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;
	
	
		return true;
	}
	
	
	
	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		// OK,Cancel,Preview
		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}
	

	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGGraphElement.SigDiffProperties getProperties()
	{

		SGGraphElement.SigDiffProperties p
			= new SGGraphElement.SigDiffProperties();

		Number space = this.getSpace();
		if( space==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.space = space.floatValue()/SGConstants.CM_POINT_RATIO;
		}

		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize = fontSize.floatValue();
		}

		p.fontFamilyName = this.getFontFamilyName();
		p.fontStyle = this.getFontStyle();

		Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.lineWidth = lineWidth.floatValue();
		}

		p.colorList = this.getTextColorList();

		return p;

	}

    
}
